----------------------------------------------------------------------------------
-- }cdq
--
-- @@@@yMFPGA-BASEz@@FPGAg[jOpwKx[X{[h 
-- 
-- @@@@@@@\ؗp@TvR[h
--
-- ݌v	: VHDL
-- FPGA	: čeBXZ~R_N^Ё@LFXP2-5E-5TN144C
-- ݌v	: 2009N214
-- 񋟓	: 2009N410
-- o[W	: 1.0.0
--
----------------------------------------------------------------------------------
----------------------------------------------------------------------------------
-- Description: 
--		4digits 7segment LED HEX encoder
--
----------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity module_7seg_x4 is
	port (
	--**** Hexa-decimal data input ****--
		HEX_Data1_in	: in	std_logic_vector(3 downto 0) ;
		HEX_Data2_in	: in	std_logic_vector(3 downto 0) ;
		HEX_Data3_in	: in	std_logic_vector(3 downto 0) ;
		HEX_Data4_in	: in	std_logic_vector(3 downto 0) ;

		SEG7_porarity	: in	std_logic ;				-- 1 : H-Light, 0 : L-Light
		
	--**** 7segment array output ****--
		Seg_Data1_out	: out	std_logic_vector(7 downto 0) ;
		Seg_Data2_out	: out	std_logic_vector(7 downto 0) ;
		Seg_Data3_out	: out	std_logic_vector(7 downto 0) ;
		Seg_Data4_out	: out	std_logic_vector(7 downto 0)
	) ;
end module_7seg_x4 ;

architecture Behavioral of module_7seg_x4 is

component module_7seg is
	port (
	--**** Hexa-decimal data input ****--
		HEX_Data_in		: in	std_logic_vector(3 downto 0) ;
		SEG7_porarity	: in	std_logic ;				-- 1 : H-Light, 0 : L-Light
		
	--**** 7segment array output ****--
		Seg_Data_out	: out	std_logic_vector(7 downto 0)
	) ;
end component ;

begin

--*****************************************************************************************--
u_7Seg_digit_1 : Module_7seg
	port map (
	--**** Hexa-decimal data input ****--
		HEX_Data_in		=> HEX_Data1_in ,
		SEG7_porarity	=> SEG7_porarity ,		-- 1 : H-Light, 0 : L-Light
		
	--**** 7segment array output ****--
		Seg_Data_out	=> Seg_Data1_out
	) ;

--*****************************************************************************************--
u_7Seg_digit_2 : Module_7seg
	port map (
	--**** Hexa-decimal data input ****--
		HEX_Data_in		=> HEX_Data2_in ,
		SEG7_porarity	=> SEG7_porarity ,		-- 1 : H-Light, 0 : L-Light
		
	--**** 7segment array output ****--
		Seg_Data_out	=> Seg_Data2_out
	) ;

--*****************************************************************************************--
u_7Seg_digit_3 : Module_7seg
	port map (
	--**** Hexa-decimal data input ****--
		HEX_Data_in		=> HEX_Data3_in ,
		SEG7_porarity	=> SEG7_porarity ,		-- 1 : H-Light, 0 : L-Light
		
	--**** 7segment array output ****--
		Seg_Data_out	=> Seg_Data3_out
	) ;

--*****************************************************************************************--
u_7Seg_digit_4 : Module_7seg
	port map (
	--**** Hexa-decimal data input ****--
		HEX_Data_in		=> HEX_Data4_in ,
		SEG7_porarity	=> SEG7_porarity ,		-- 1 : H-Light, 0 : L-Light
		
	--**** 7segment array output ****--
		Seg_Data_out	=> Seg_Data4_out
	) ;

end Behavioral;

