----------------------------------------------------------------------------------
-- }cdg
--
-- @@@@yMFPGA-BASEz@@FPGAg[jOpwKx[X{[h 
-- 
-- @@@@@@@\ؗp@TvR[h
--
-- ݌v	: VHDL
-- FPGA	: čeBXZ~R_N^Ё@LFXP2-5E-5TN144C
-- ݌v	: 2009N214
-- 񋟓	: 2009N410
-- o[W	: 1.0.0
--
----------------------------------------------------------------------------------

-- Description: 
--
--		PUSH Switch clock synchronizer.
--		- 4channel control
--
----------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity Module_PUSHsw_sync4 is
	port (
		SysCLK_in		: in	std_logic ;
		SysRST_in		: in	std_logic ;
		
		PUSHSW_in		: in	std_logic_vector(4 downto 1) ;
		PUSHSW_porarity	: in	std_logic ;							-- 1 : Active-H, 0 : Active-L
		
	--********--
		PUSHSW_out		: out	std_logic_vector(4 downto 1) ;
		PUSHSW_H_edge	: out	std_logic_vector(4 downto 1) ;
		PUSHSW_L_edge	: out	std_logic_vector(4 downto 1)
	) ;
end Module_PUSHsw_sync4 ;

architecture Behavioral of Module_PUSHsw_sync4 is

component Module_PUSHsw_sync is
	port (
		SysCLK_in		: in	std_logic ;
		SysRST_in		: in	std_logic ;
		
		PUSHSW_in		: in	std_logic ;
		PUSHSW_porarity	: in	std_logic ;							-- 1 : Active-H, 0 : Active-L
		
	--********--
		PUSHSW_out		: out	std_logic ;
		PUSHSW_H_edge	: out	std_logic ;
		PUSHSW_L_edge	: out	std_logic
	) ;
end component ;

begin

--********************************************************--
u_SW1 : Module_PUSHsw_sync
	port map (
		SysCLK_in		=> SysCLK_in ,
		SysRST_in		=> SysRST_in ,
		
		PUSHSW_in		=> PUSHSW_in(1) ,
		PUSHSW_porarity	=> PUSHSW_porarity ,							-- 1 : Active-H, 0 : Active-L
		
	--********--
		PUSHSW_out		=> PUSHSW_out(1) ,
		PUSHSW_H_edge	=> PUSHSW_H_edge(1) ,
		PUSHSW_L_edge	=> PUSHSW_L_edge(1)
	) ;

--********************************************************--
u_SW2 : Module_PUSHsw_sync
	port map (
		SysCLK_in		=> SysCLK_in ,
		SysRST_in		=> SysRST_in ,
		
		PUSHSW_in		=> PUSHSW_in(2) ,
		PUSHSW_porarity	=> PUSHSW_porarity ,							-- 1 : Active-H, 0 : Active-L
		
	--********--
		PUSHSW_out		=> PUSHSW_out(2) ,
		PUSHSW_H_edge	=> PUSHSW_H_edge(2) ,
		PUSHSW_L_edge	=> PUSHSW_L_edge(2)
	) ;

--********************************************************--
u_SW3 : Module_PUSHsw_sync
	port map (
		SysCLK_in		=> SysCLK_in ,
		SysRST_in		=> SysRST_in ,
		
		PUSHSW_in		=> PUSHSW_in(3) ,
		PUSHSW_porarity	=> PUSHSW_porarity ,							-- 1 : Active-H, 0 : Active-L
		
	--********--
		PUSHSW_out		=> PUSHSW_out(3) ,
		PUSHSW_H_edge	=> PUSHSW_H_edge(3) ,
		PUSHSW_L_edge	=> PUSHSW_L_edge(3)
	) ;

--********************************************************--
u_SW4 : Module_PUSHsw_sync
	port map (
		SysCLK_in		=> SysCLK_in ,
		SysRST_in		=> SysRST_in ,
		
		PUSHSW_in		=> PUSHSW_in(4) ,
		PUSHSW_porarity	=> PUSHSW_porarity ,							-- 1 : Active-H, 0 : Active-L
		
	--********--
		PUSHSW_out		=> PUSHSW_out(4) ,
		PUSHSW_H_edge	=> PUSHSW_H_edge(4) ,
		PUSHSW_L_edge	=> PUSHSW_L_edge(4)
	) ;

end Behavioral;

