----------------------------------------------------------------------------------
-- }cdg
--
-- @@@@yMFPGA-BASEz@@FPGAg[jOpwKx[X{[h 
-- 
-- @@@@@@@\ؗp@TvR[h
--
-- ݌v	: VHDL
-- FPGA	: čeBXZ~R_N^Ё@LFXP2-5E-5TN144C
-- ݌v	: 2009N214
-- 񋟓	: 2009N410
-- o[W	: 1.0.0
--
----------------------------------------------------------------------------------

-- Description: 
--
--		16bit precision SIN table
--
----------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity module_sintable is
	port (
		SysCLK_in	: in	std_logic ;		-- Operation clock
		SysRST_in	: in	std_logic ;		-- System reset
		adrs		: in	std_logic_vector(13 downto 0) ;		-- Table address
		
		dout1		: out	std_logic_vector(15 downto 0) ;
								-- Sin(x) value. + range : 0x0000 - 0x7FFF, - range : 0x8000 - 0xFFFF. Signed.
		dout2		: out	std_logic_vector(15 downto 0)
								-- Sin(x) value. - range : 0x0000 - 0x7FFF, + range : 0x8000 - 0xFFFF. Unsigned.
	) ;
end module_sintable ;

architecture Behavioral of module_sintable is

--***************************************************************--
	
	signal	sin_out			: std_logic_vector(15 downto 0) ;
	signal	sin_table_adrs	: std_logic_vector(11 downto 0) ;

	signal	phase_adrs		: std_logic_vector(1 downto 0) ;
	signal	dly1_phase_adrs	: std_logic_vector(1 downto 0) ;

	signal	rom_data		: std_logic_vector(14 downto 0) ;
	signal	reg_sin_out1	: std_logic_vector(15 downto 0) ;		-- Signed output
	signal	reg_sin_out2	: std_logic_vector(15 downto 0) ;		-- Unsigned output
	
begin
--***************************************************************--
	phase_adrs		<=     adrs(13 downto 12)	after 1 ns ;
	sin_table_adrs	<=     adrs(11 downto  0)	when ( phase_adrs = "00" ) else
					   not adrs(11 downto  0)	when ( phase_adrs = "01" ) else
					       adrs(11 downto  0)	when ( phase_adrs = "10" ) else
					   not adrs(11 downto  0)	after 1 ns ;

sin_tbl_rom_equ : process ( sin_table_adrs )
begin
	case sin_table_adrs is
		when x"000" => sin_out <= x"0000";
		when x"001" => sin_out <= x"000d";
		when x"002" => sin_out <= x"0019";
		when x"003" => sin_out <= x"0026";
		when x"004" => sin_out <= x"0032";
		when x"005" => sin_out <= x"003f";
		when x"006" => sin_out <= x"004b";
		when x"007" => sin_out <= x"0058";
		when x"008" => sin_out <= x"0065";
		when x"009" => sin_out <= x"0071";
		when x"00a" => sin_out <= x"007e";
		when x"00b" => sin_out <= x"008a";
		when x"00c" => sin_out <= x"0097";
		when x"00d" => sin_out <= x"00a3";
		when x"00e" => sin_out <= x"00b0";
		when x"00f" => sin_out <= x"00bc";
		when x"010" => sin_out <= x"00c9";
		when x"011" => sin_out <= x"00d6";
		when x"012" => sin_out <= x"00e2";
		when x"013" => sin_out <= x"00ef";
		when x"014" => sin_out <= x"00fb";
		when x"015" => sin_out <= x"0108";
		when x"016" => sin_out <= x"0114";
		when x"017" => sin_out <= x"0121";
		when x"018" => sin_out <= x"012e";
		when x"019" => sin_out <= x"013a";
		when x"01a" => sin_out <= x"0147";
		when x"01b" => sin_out <= x"0153";
		when x"01c" => sin_out <= x"0160";
		when x"01d" => sin_out <= x"016c";
		when x"01e" => sin_out <= x"0179";
		when x"01f" => sin_out <= x"0186";
		when x"020" => sin_out <= x"0192";
		when x"021" => sin_out <= x"019f";
		when x"022" => sin_out <= x"01ab";
		when x"023" => sin_out <= x"01b8";
		when x"024" => sin_out <= x"01c4";
		when x"025" => sin_out <= x"01d1";
		when x"026" => sin_out <= x"01dd";
		when x"027" => sin_out <= x"01ea";
		when x"028" => sin_out <= x"01f7";
		when x"029" => sin_out <= x"0203";
		when x"02a" => sin_out <= x"0210";
		when x"02b" => sin_out <= x"021c";
		when x"02c" => sin_out <= x"0229";
		when x"02d" => sin_out <= x"0235";
		when x"02e" => sin_out <= x"0242";
		when x"02f" => sin_out <= x"024f";
		when x"030" => sin_out <= x"025b";
		when x"031" => sin_out <= x"0268";
		when x"032" => sin_out <= x"0274";
		when x"033" => sin_out <= x"0281";
		when x"034" => sin_out <= x"028d";
		when x"035" => sin_out <= x"029a";
		when x"036" => sin_out <= x"02a7";
		when x"037" => sin_out <= x"02b3";
		when x"038" => sin_out <= x"02c0";
		when x"039" => sin_out <= x"02cc";
		when x"03a" => sin_out <= x"02d9";
		when x"03b" => sin_out <= x"02e5";
		when x"03c" => sin_out <= x"02f2";
		when x"03d" => sin_out <= x"02fe";
		when x"03e" => sin_out <= x"030b";
		when x"03f" => sin_out <= x"0318";
		when x"040" => sin_out <= x"0324";
		when x"041" => sin_out <= x"0331";
		when x"042" => sin_out <= x"033d";
		when x"043" => sin_out <= x"034a";
		when x"044" => sin_out <= x"0356";
		when x"045" => sin_out <= x"0363";
		when x"046" => sin_out <= x"0370";
		when x"047" => sin_out <= x"037c";
		when x"048" => sin_out <= x"0389";
		when x"049" => sin_out <= x"0395";
		when x"04a" => sin_out <= x"03a2";
		when x"04b" => sin_out <= x"03ae";
		when x"04c" => sin_out <= x"03bb";
		when x"04d" => sin_out <= x"03c7";
		when x"04e" => sin_out <= x"03d4";
		when x"04f" => sin_out <= x"03e1";
		when x"050" => sin_out <= x"03ed";
		when x"051" => sin_out <= x"03fa";
		when x"052" => sin_out <= x"0406";
		when x"053" => sin_out <= x"0413";
		when x"054" => sin_out <= x"041f";
		when x"055" => sin_out <= x"042c";
		when x"056" => sin_out <= x"0438";
		when x"057" => sin_out <= x"0445";
		when x"058" => sin_out <= x"0452";
		when x"059" => sin_out <= x"045e";
		when x"05a" => sin_out <= x"046b";
		when x"05b" => sin_out <= x"0477";
		when x"05c" => sin_out <= x"0484";
		when x"05d" => sin_out <= x"0490";
		when x"05e" => sin_out <= x"049d";
		when x"05f" => sin_out <= x"04aa";
		when x"060" => sin_out <= x"04b6";
		when x"061" => sin_out <= x"04c3";
		when x"062" => sin_out <= x"04cf";
		when x"063" => sin_out <= x"04dc";
		when x"064" => sin_out <= x"04e8";
		when x"065" => sin_out <= x"04f5";
		when x"066" => sin_out <= x"0501";
		when x"067" => sin_out <= x"050e";
		when x"068" => sin_out <= x"051b";
		when x"069" => sin_out <= x"0527";
		when x"06a" => sin_out <= x"0534";
		when x"06b" => sin_out <= x"0540";
		when x"06c" => sin_out <= x"054d";
		when x"06d" => sin_out <= x"0559";
		when x"06e" => sin_out <= x"0566";
		when x"06f" => sin_out <= x"0572";
		when x"070" => sin_out <= x"057f";
		when x"071" => sin_out <= x"058c";
		when x"072" => sin_out <= x"0598";
		when x"073" => sin_out <= x"05a5";
		when x"074" => sin_out <= x"05b1";
		when x"075" => sin_out <= x"05be";
		when x"076" => sin_out <= x"05ca";
		when x"077" => sin_out <= x"05d7";
		when x"078" => sin_out <= x"05e3";
		when x"079" => sin_out <= x"05f0";
		when x"07a" => sin_out <= x"05fc";
		when x"07b" => sin_out <= x"0609";
		when x"07c" => sin_out <= x"0616";
		when x"07d" => sin_out <= x"0622";
		when x"07e" => sin_out <= x"062f";
		when x"07f" => sin_out <= x"063b";
		when x"080" => sin_out <= x"0648";
		when x"081" => sin_out <= x"0654";
		when x"082" => sin_out <= x"0661";
		when x"083" => sin_out <= x"066d";
		when x"084" => sin_out <= x"067a";
		when x"085" => sin_out <= x"0687";
		when x"086" => sin_out <= x"0693";
		when x"087" => sin_out <= x"06a0";
		when x"088" => sin_out <= x"06ac";
		when x"089" => sin_out <= x"06b9";
		when x"08a" => sin_out <= x"06c5";
		when x"08b" => sin_out <= x"06d2";
		when x"08c" => sin_out <= x"06de";
		when x"08d" => sin_out <= x"06eb";
		when x"08e" => sin_out <= x"06f7";
		when x"08f" => sin_out <= x"0704";
		when x"090" => sin_out <= x"0711";
		when x"091" => sin_out <= x"071d";
		when x"092" => sin_out <= x"072a";
		when x"093" => sin_out <= x"0736";
		when x"094" => sin_out <= x"0743";
		when x"095" => sin_out <= x"074f";
		when x"096" => sin_out <= x"075c";
		when x"097" => sin_out <= x"0768";
		when x"098" => sin_out <= x"0775";
		when x"099" => sin_out <= x"0781";
		when x"09a" => sin_out <= x"078e";
		when x"09b" => sin_out <= x"079b";
		when x"09c" => sin_out <= x"07a7";
		when x"09d" => sin_out <= x"07b4";
		when x"09e" => sin_out <= x"07c0";
		when x"09f" => sin_out <= x"07cd";
		when x"0a0" => sin_out <= x"07d9";
		when x"0a1" => sin_out <= x"07e6";
		when x"0a2" => sin_out <= x"07f2";
		when x"0a3" => sin_out <= x"07ff";
		when x"0a4" => sin_out <= x"080b";
		when x"0a5" => sin_out <= x"0818";
		when x"0a6" => sin_out <= x"0825";
		when x"0a7" => sin_out <= x"0831";
		when x"0a8" => sin_out <= x"083e";
		when x"0a9" => sin_out <= x"084a";
		when x"0aa" => sin_out <= x"0857";
		when x"0ab" => sin_out <= x"0863";
		when x"0ac" => sin_out <= x"0870";
		when x"0ad" => sin_out <= x"087c";
		when x"0ae" => sin_out <= x"0889";
		when x"0af" => sin_out <= x"0895";
		when x"0b0" => sin_out <= x"08a2";
		when x"0b1" => sin_out <= x"08ae";
		when x"0b2" => sin_out <= x"08bb";
		when x"0b3" => sin_out <= x"08c8";
		when x"0b4" => sin_out <= x"08d4";
		when x"0b5" => sin_out <= x"08e1";
		when x"0b6" => sin_out <= x"08ed";
		when x"0b7" => sin_out <= x"08fa";
		when x"0b8" => sin_out <= x"0906";
		when x"0b9" => sin_out <= x"0913";
		when x"0ba" => sin_out <= x"091f";
		when x"0bb" => sin_out <= x"092c";
		when x"0bc" => sin_out <= x"0938";
		when x"0bd" => sin_out <= x"0945";
		when x"0be" => sin_out <= x"0951";
		when x"0bf" => sin_out <= x"095e";
		when x"0c0" => sin_out <= x"096a";
		when x"0c1" => sin_out <= x"0977";
		when x"0c2" => sin_out <= x"0984";
		when x"0c3" => sin_out <= x"0990";
		when x"0c4" => sin_out <= x"099d";
		when x"0c5" => sin_out <= x"09a9";
		when x"0c6" => sin_out <= x"09b6";
		when x"0c7" => sin_out <= x"09c2";
		when x"0c8" => sin_out <= x"09cf";
		when x"0c9" => sin_out <= x"09db";
		when x"0ca" => sin_out <= x"09e8";
		when x"0cb" => sin_out <= x"09f4";
		when x"0cc" => sin_out <= x"0a01";
		when x"0cd" => sin_out <= x"0a0d";
		when x"0ce" => sin_out <= x"0a1a";
		when x"0cf" => sin_out <= x"0a26";
		when x"0d0" => sin_out <= x"0a33";
		when x"0d1" => sin_out <= x"0a3f";
		when x"0d2" => sin_out <= x"0a4c";
		when x"0d3" => sin_out <= x"0a59";
		when x"0d4" => sin_out <= x"0a65";
		when x"0d5" => sin_out <= x"0a72";
		when x"0d6" => sin_out <= x"0a7e";
		when x"0d7" => sin_out <= x"0a8b";
		when x"0d8" => sin_out <= x"0a97";
		when x"0d9" => sin_out <= x"0aa4";
		when x"0da" => sin_out <= x"0ab0";
		when x"0db" => sin_out <= x"0abd";
		when x"0dc" => sin_out <= x"0ac9";
		when x"0dd" => sin_out <= x"0ad6";
		when x"0de" => sin_out <= x"0ae2";
		when x"0df" => sin_out <= x"0aef";
		when x"0e0" => sin_out <= x"0afb";
		when x"0e1" => sin_out <= x"0b08";
		when x"0e2" => sin_out <= x"0b14";
		when x"0e3" => sin_out <= x"0b21";
		when x"0e4" => sin_out <= x"0b2d";
		when x"0e5" => sin_out <= x"0b3a";
		when x"0e6" => sin_out <= x"0b46";
		when x"0e7" => sin_out <= x"0b53";
		when x"0e8" => sin_out <= x"0b5f";
		when x"0e9" => sin_out <= x"0b6c";
		when x"0ea" => sin_out <= x"0b78";
		when x"0eb" => sin_out <= x"0b85";
		when x"0ec" => sin_out <= x"0b92";
		when x"0ed" => sin_out <= x"0b9e";
		when x"0ee" => sin_out <= x"0bab";
		when x"0ef" => sin_out <= x"0bb7";
		when x"0f0" => sin_out <= x"0bc4";
		when x"0f1" => sin_out <= x"0bd0";
		when x"0f2" => sin_out <= x"0bdd";
		when x"0f3" => sin_out <= x"0be9";
		when x"0f4" => sin_out <= x"0bf6";
		when x"0f5" => sin_out <= x"0c02";
		when x"0f6" => sin_out <= x"0c0f";
		when x"0f7" => sin_out <= x"0c1b";
		when x"0f8" => sin_out <= x"0c28";
		when x"0f9" => sin_out <= x"0c34";
		when x"0fa" => sin_out <= x"0c41";
		when x"0fb" => sin_out <= x"0c4d";
		when x"0fc" => sin_out <= x"0c5a";
		when x"0fd" => sin_out <= x"0c66";
		when x"0fe" => sin_out <= x"0c73";
		when x"0ff" => sin_out <= x"0c7f";
		when x"100" => sin_out <= x"0c8c";
		when x"101" => sin_out <= x"0c98";
		when x"102" => sin_out <= x"0ca5";
		when x"103" => sin_out <= x"0cb1";
		when x"104" => sin_out <= x"0cbe";
		when x"105" => sin_out <= x"0cca";
		when x"106" => sin_out <= x"0cd7";
		when x"107" => sin_out <= x"0ce3";
		when x"108" => sin_out <= x"0cf0";
		when x"109" => sin_out <= x"0cfc";
		when x"10a" => sin_out <= x"0d09";
		when x"10b" => sin_out <= x"0d15";
		when x"10c" => sin_out <= x"0d22";
		when x"10d" => sin_out <= x"0d2e";
		when x"10e" => sin_out <= x"0d3b";
		when x"10f" => sin_out <= x"0d47";
		when x"110" => sin_out <= x"0d54";
		when x"111" => sin_out <= x"0d60";
		when x"112" => sin_out <= x"0d6d";
		when x"113" => sin_out <= x"0d79";
		when x"114" => sin_out <= x"0d86";
		when x"115" => sin_out <= x"0d92";
		when x"116" => sin_out <= x"0d9f";
		when x"117" => sin_out <= x"0dab";
		when x"118" => sin_out <= x"0db8";
		when x"119" => sin_out <= x"0dc4";
		when x"11a" => sin_out <= x"0dd1";
		when x"11b" => sin_out <= x"0ddd";
		when x"11c" => sin_out <= x"0dea";
		when x"11d" => sin_out <= x"0df6";
		when x"11e" => sin_out <= x"0e03";
		when x"11f" => sin_out <= x"0e0f";
		when x"120" => sin_out <= x"0e1c";
		when x"121" => sin_out <= x"0e28";
		when x"122" => sin_out <= x"0e35";
		when x"123" => sin_out <= x"0e41";
		when x"124" => sin_out <= x"0e4e";
		when x"125" => sin_out <= x"0e5a";
		when x"126" => sin_out <= x"0e67";
		when x"127" => sin_out <= x"0e73";
		when x"128" => sin_out <= x"0e80";
		when x"129" => sin_out <= x"0e8c";
		when x"12a" => sin_out <= x"0e99";
		when x"12b" => sin_out <= x"0ea5";
		when x"12c" => sin_out <= x"0eb1";
		when x"12d" => sin_out <= x"0ebe";
		when x"12e" => sin_out <= x"0eca";
		when x"12f" => sin_out <= x"0ed7";
		when x"130" => sin_out <= x"0ee3";
		when x"131" => sin_out <= x"0ef0";
		when x"132" => sin_out <= x"0efc";
		when x"133" => sin_out <= x"0f09";
		when x"134" => sin_out <= x"0f15";
		when x"135" => sin_out <= x"0f22";
		when x"136" => sin_out <= x"0f2e";
		when x"137" => sin_out <= x"0f3b";
		when x"138" => sin_out <= x"0f47";
		when x"139" => sin_out <= x"0f54";
		when x"13a" => sin_out <= x"0f60";
		when x"13b" => sin_out <= x"0f6d";
		when x"13c" => sin_out <= x"0f79";
		when x"13d" => sin_out <= x"0f86";
		when x"13e" => sin_out <= x"0f92";
		when x"13f" => sin_out <= x"0f9f";
		when x"140" => sin_out <= x"0fab";
		when x"141" => sin_out <= x"0fb8";
		when x"142" => sin_out <= x"0fc4";
		when x"143" => sin_out <= x"0fd0";
		when x"144" => sin_out <= x"0fdd";
		when x"145" => sin_out <= x"0fe9";
		when x"146" => sin_out <= x"0ff6";
		when x"147" => sin_out <= x"1002";
		when x"148" => sin_out <= x"100f";
		when x"149" => sin_out <= x"101b";
		when x"14a" => sin_out <= x"1028";
		when x"14b" => sin_out <= x"1034";
		when x"14c" => sin_out <= x"1041";
		when x"14d" => sin_out <= x"104d";
		when x"14e" => sin_out <= x"105a";
		when x"14f" => sin_out <= x"1066";
		when x"150" => sin_out <= x"1072";
		when x"151" => sin_out <= x"107f";
		when x"152" => sin_out <= x"108b";
		when x"153" => sin_out <= x"1098";
		when x"154" => sin_out <= x"10a4";
		when x"155" => sin_out <= x"10b1";
		when x"156" => sin_out <= x"10bd";
		when x"157" => sin_out <= x"10ca";
		when x"158" => sin_out <= x"10d6";
		when x"159" => sin_out <= x"10e3";
		when x"15a" => sin_out <= x"10ef";
		when x"15b" => sin_out <= x"10fc";
		when x"15c" => sin_out <= x"1108";
		when x"15d" => sin_out <= x"1114";
		when x"15e" => sin_out <= x"1121";
		when x"15f" => sin_out <= x"112d";
		when x"160" => sin_out <= x"113a";
		when x"161" => sin_out <= x"1146";
		when x"162" => sin_out <= x"1153";
		when x"163" => sin_out <= x"115f";
		when x"164" => sin_out <= x"116c";
		when x"165" => sin_out <= x"1178";
		when x"166" => sin_out <= x"1185";
		when x"167" => sin_out <= x"1191";
		when x"168" => sin_out <= x"119d";
		when x"169" => sin_out <= x"11aa";
		when x"16a" => sin_out <= x"11b6";
		when x"16b" => sin_out <= x"11c3";
		when x"16c" => sin_out <= x"11cf";
		when x"16d" => sin_out <= x"11dc";
		when x"16e" => sin_out <= x"11e8";
		when x"16f" => sin_out <= x"11f5";
		when x"170" => sin_out <= x"1201";
		when x"171" => sin_out <= x"120d";
		when x"172" => sin_out <= x"121a";
		when x"173" => sin_out <= x"1226";
		when x"174" => sin_out <= x"1233";
		when x"175" => sin_out <= x"123f";
		when x"176" => sin_out <= x"124c";
		when x"177" => sin_out <= x"1258";
		when x"178" => sin_out <= x"1264";
		when x"179" => sin_out <= x"1271";
		when x"17a" => sin_out <= x"127d";
		when x"17b" => sin_out <= x"128a";
		when x"17c" => sin_out <= x"1296";
		when x"17d" => sin_out <= x"12a3";
		when x"17e" => sin_out <= x"12af";
		when x"17f" => sin_out <= x"12bb";
		when x"180" => sin_out <= x"12c8";
		when x"181" => sin_out <= x"12d4";
		when x"182" => sin_out <= x"12e1";
		when x"183" => sin_out <= x"12ed";
		when x"184" => sin_out <= x"12fa";
		when x"185" => sin_out <= x"1306";
		when x"186" => sin_out <= x"1312";
		when x"187" => sin_out <= x"131f";
		when x"188" => sin_out <= x"132b";
		when x"189" => sin_out <= x"1338";
		when x"18a" => sin_out <= x"1344";
		when x"18b" => sin_out <= x"1351";
		when x"18c" => sin_out <= x"135d";
		when x"18d" => sin_out <= x"1369";
		when x"18e" => sin_out <= x"1376";
		when x"18f" => sin_out <= x"1382";
		when x"190" => sin_out <= x"138f";
		when x"191" => sin_out <= x"139b";
		when x"192" => sin_out <= x"13a8";
		when x"193" => sin_out <= x"13b4";
		when x"194" => sin_out <= x"13c0";
		when x"195" => sin_out <= x"13cd";
		when x"196" => sin_out <= x"13d9";
		when x"197" => sin_out <= x"13e6";
		when x"198" => sin_out <= x"13f2";
		when x"199" => sin_out <= x"13fe";
		when x"19a" => sin_out <= x"140b";
		when x"19b" => sin_out <= x"1417";
		when x"19c" => sin_out <= x"1424";
		when x"19d" => sin_out <= x"1430";
		when x"19e" => sin_out <= x"143c";
		when x"19f" => sin_out <= x"1449";
		when x"1a0" => sin_out <= x"1455";
		when x"1a1" => sin_out <= x"1462";
		when x"1a2" => sin_out <= x"146e";
		when x"1a3" => sin_out <= x"147b";
		when x"1a4" => sin_out <= x"1487";
		when x"1a5" => sin_out <= x"1493";
		when x"1a6" => sin_out <= x"14a0";
		when x"1a7" => sin_out <= x"14ac";
		when x"1a8" => sin_out <= x"14b9";
		when x"1a9" => sin_out <= x"14c5";
		when x"1aa" => sin_out <= x"14d1";
		when x"1ab" => sin_out <= x"14de";
		when x"1ac" => sin_out <= x"14ea";
		when x"1ad" => sin_out <= x"14f7";
		when x"1ae" => sin_out <= x"1503";
		when x"1af" => sin_out <= x"150f";
		when x"1b0" => sin_out <= x"151c";
		when x"1b1" => sin_out <= x"1528";
		when x"1b2" => sin_out <= x"1534";
		when x"1b3" => sin_out <= x"1541";
		when x"1b4" => sin_out <= x"154d";
		when x"1b5" => sin_out <= x"155a";
		when x"1b6" => sin_out <= x"1566";
		when x"1b7" => sin_out <= x"1572";
		when x"1b8" => sin_out <= x"157f";
		when x"1b9" => sin_out <= x"158b";
		when x"1ba" => sin_out <= x"1598";
		when x"1bb" => sin_out <= x"15a4";
		when x"1bc" => sin_out <= x"15b0";
		when x"1bd" => sin_out <= x"15bd";
		when x"1be" => sin_out <= x"15c9";
		when x"1bf" => sin_out <= x"15d6";
		when x"1c0" => sin_out <= x"15e2";
		when x"1c1" => sin_out <= x"15ee";
		when x"1c2" => sin_out <= x"15fb";
		when x"1c3" => sin_out <= x"1607";
		when x"1c4" => sin_out <= x"1613";
		when x"1c5" => sin_out <= x"1620";
		when x"1c6" => sin_out <= x"162c";
		when x"1c7" => sin_out <= x"1639";
		when x"1c8" => sin_out <= x"1645";
		when x"1c9" => sin_out <= x"1651";
		when x"1ca" => sin_out <= x"165e";
		when x"1cb" => sin_out <= x"166a";
		when x"1cc" => sin_out <= x"1676";
		when x"1cd" => sin_out <= x"1683";
		when x"1ce" => sin_out <= x"168f";
		when x"1cf" => sin_out <= x"169c";
		when x"1d0" => sin_out <= x"16a8";
		when x"1d1" => sin_out <= x"16b4";
		when x"1d2" => sin_out <= x"16c1";
		when x"1d3" => sin_out <= x"16cd";
		when x"1d4" => sin_out <= x"16d9";
		when x"1d5" => sin_out <= x"16e6";
		when x"1d6" => sin_out <= x"16f2";
		when x"1d7" => sin_out <= x"16fe";
		when x"1d8" => sin_out <= x"170b";
		when x"1d9" => sin_out <= x"1717";
		when x"1da" => sin_out <= x"1724";
		when x"1db" => sin_out <= x"1730";
		when x"1dc" => sin_out <= x"173c";
		when x"1dd" => sin_out <= x"1749";
		when x"1de" => sin_out <= x"1755";
		when x"1df" => sin_out <= x"1761";
		when x"1e0" => sin_out <= x"176e";
		when x"1e1" => sin_out <= x"177a";
		when x"1e2" => sin_out <= x"1786";
		when x"1e3" => sin_out <= x"1793";
		when x"1e4" => sin_out <= x"179f";
		when x"1e5" => sin_out <= x"17ab";
		when x"1e6" => sin_out <= x"17b8";
		when x"1e7" => sin_out <= x"17c4";
		when x"1e8" => sin_out <= x"17d0";
		when x"1e9" => sin_out <= x"17dd";
		when x"1ea" => sin_out <= x"17e9";
		when x"1eb" => sin_out <= x"17f6";
		when x"1ec" => sin_out <= x"1802";
		when x"1ed" => sin_out <= x"180e";
		when x"1ee" => sin_out <= x"181b";
		when x"1ef" => sin_out <= x"1827";
		when x"1f0" => sin_out <= x"1833";
		when x"1f1" => sin_out <= x"1840";
		when x"1f2" => sin_out <= x"184c";
		when x"1f3" => sin_out <= x"1858";
		when x"1f4" => sin_out <= x"1865";
		when x"1f5" => sin_out <= x"1871";
		when x"1f6" => sin_out <= x"187d";
		when x"1f7" => sin_out <= x"188a";
		when x"1f8" => sin_out <= x"1896";
		when x"1f9" => sin_out <= x"18a2";
		when x"1fa" => sin_out <= x"18af";
		when x"1fb" => sin_out <= x"18bb";
		when x"1fc" => sin_out <= x"18c7";
		when x"1fd" => sin_out <= x"18d4";
		when x"1fe" => sin_out <= x"18e0";
		when x"1ff" => sin_out <= x"18ec";
		when x"200" => sin_out <= x"18f9";
		when x"201" => sin_out <= x"1905";
		when x"202" => sin_out <= x"1911";
		when x"203" => sin_out <= x"191d";
		when x"204" => sin_out <= x"192a";
		when x"205" => sin_out <= x"1936";
		when x"206" => sin_out <= x"1942";
		when x"207" => sin_out <= x"194f";
		when x"208" => sin_out <= x"195b";
		when x"209" => sin_out <= x"1967";
		when x"20a" => sin_out <= x"1974";
		when x"20b" => sin_out <= x"1980";
		when x"20c" => sin_out <= x"198c";
		when x"20d" => sin_out <= x"1999";
		when x"20e" => sin_out <= x"19a5";
		when x"20f" => sin_out <= x"19b1";
		when x"210" => sin_out <= x"19be";
		when x"211" => sin_out <= x"19ca";
		when x"212" => sin_out <= x"19d6";
		when x"213" => sin_out <= x"19e3";
		when x"214" => sin_out <= x"19ef";
		when x"215" => sin_out <= x"19fb";
		when x"216" => sin_out <= x"1a07";
		when x"217" => sin_out <= x"1a14";
		when x"218" => sin_out <= x"1a20";
		when x"219" => sin_out <= x"1a2c";
		when x"21a" => sin_out <= x"1a39";
		when x"21b" => sin_out <= x"1a45";
		when x"21c" => sin_out <= x"1a51";
		when x"21d" => sin_out <= x"1a5e";
		when x"21e" => sin_out <= x"1a6a";
		when x"21f" => sin_out <= x"1a76";
		when x"220" => sin_out <= x"1a82";
		when x"221" => sin_out <= x"1a8f";
		when x"222" => sin_out <= x"1a9b";
		when x"223" => sin_out <= x"1aa7";
		when x"224" => sin_out <= x"1ab4";
		when x"225" => sin_out <= x"1ac0";
		when x"226" => sin_out <= x"1acc";
		when x"227" => sin_out <= x"1ad8";
		when x"228" => sin_out <= x"1ae5";
		when x"229" => sin_out <= x"1af1";
		when x"22a" => sin_out <= x"1afd";
		when x"22b" => sin_out <= x"1b0a";
		when x"22c" => sin_out <= x"1b16";
		when x"22d" => sin_out <= x"1b22";
		when x"22e" => sin_out <= x"1b2e";
		when x"22f" => sin_out <= x"1b3b";
		when x"230" => sin_out <= x"1b47";
		when x"231" => sin_out <= x"1b53";
		when x"232" => sin_out <= x"1b60";
		when x"233" => sin_out <= x"1b6c";
		when x"234" => sin_out <= x"1b78";
		when x"235" => sin_out <= x"1b84";
		when x"236" => sin_out <= x"1b91";
		when x"237" => sin_out <= x"1b9d";
		when x"238" => sin_out <= x"1ba9";
		when x"239" => sin_out <= x"1bb5";
		when x"23a" => sin_out <= x"1bc2";
		when x"23b" => sin_out <= x"1bce";
		when x"23c" => sin_out <= x"1bda";
		when x"23d" => sin_out <= x"1be7";
		when x"23e" => sin_out <= x"1bf3";
		when x"23f" => sin_out <= x"1bff";
		when x"240" => sin_out <= x"1c0b";
		when x"241" => sin_out <= x"1c18";
		when x"242" => sin_out <= x"1c24";
		when x"243" => sin_out <= x"1c30";
		when x"244" => sin_out <= x"1c3c";
		when x"245" => sin_out <= x"1c49";
		when x"246" => sin_out <= x"1c55";
		when x"247" => sin_out <= x"1c61";
		when x"248" => sin_out <= x"1c6d";
		when x"249" => sin_out <= x"1c7a";
		when x"24a" => sin_out <= x"1c86";
		when x"24b" => sin_out <= x"1c92";
		when x"24c" => sin_out <= x"1c9e";
		when x"24d" => sin_out <= x"1cab";
		when x"24e" => sin_out <= x"1cb7";
		when x"24f" => sin_out <= x"1cc3";
		when x"250" => sin_out <= x"1ccf";
		when x"251" => sin_out <= x"1cdc";
		when x"252" => sin_out <= x"1ce8";
		when x"253" => sin_out <= x"1cf4";
		when x"254" => sin_out <= x"1d00";
		when x"255" => sin_out <= x"1d0d";
		when x"256" => sin_out <= x"1d19";
		when x"257" => sin_out <= x"1d25";
		when x"258" => sin_out <= x"1d31";
		when x"259" => sin_out <= x"1d3d";
		when x"25a" => sin_out <= x"1d4a";
		when x"25b" => sin_out <= x"1d56";
		when x"25c" => sin_out <= x"1d62";
		when x"25d" => sin_out <= x"1d6e";
		when x"25e" => sin_out <= x"1d7b";
		when x"25f" => sin_out <= x"1d87";
		when x"260" => sin_out <= x"1d93";
		when x"261" => sin_out <= x"1d9f";
		when x"262" => sin_out <= x"1dac";
		when x"263" => sin_out <= x"1db8";
		when x"264" => sin_out <= x"1dc4";
		when x"265" => sin_out <= x"1dd0";
		when x"266" => sin_out <= x"1ddc";
		when x"267" => sin_out <= x"1de9";
		when x"268" => sin_out <= x"1df5";
		when x"269" => sin_out <= x"1e01";
		when x"26a" => sin_out <= x"1e0d";
		when x"26b" => sin_out <= x"1e19";
		when x"26c" => sin_out <= x"1e26";
		when x"26d" => sin_out <= x"1e32";
		when x"26e" => sin_out <= x"1e3e";
		when x"26f" => sin_out <= x"1e4a";
		when x"270" => sin_out <= x"1e57";
		when x"271" => sin_out <= x"1e63";
		when x"272" => sin_out <= x"1e6f";
		when x"273" => sin_out <= x"1e7b";
		when x"274" => sin_out <= x"1e87";
		when x"275" => sin_out <= x"1e94";
		when x"276" => sin_out <= x"1ea0";
		when x"277" => sin_out <= x"1eac";
		when x"278" => sin_out <= x"1eb8";
		when x"279" => sin_out <= x"1ec4";
		when x"27a" => sin_out <= x"1ed1";
		when x"27b" => sin_out <= x"1edd";
		when x"27c" => sin_out <= x"1ee9";
		when x"27d" => sin_out <= x"1ef5";
		when x"27e" => sin_out <= x"1f01";
		when x"27f" => sin_out <= x"1f0e";
		when x"280" => sin_out <= x"1f1a";
		when x"281" => sin_out <= x"1f26";
		when x"282" => sin_out <= x"1f32";
		when x"283" => sin_out <= x"1f3e";
		when x"284" => sin_out <= x"1f4a";
		when x"285" => sin_out <= x"1f57";
		when x"286" => sin_out <= x"1f63";
		when x"287" => sin_out <= x"1f6f";
		when x"288" => sin_out <= x"1f7b";
		when x"289" => sin_out <= x"1f87";
		when x"28a" => sin_out <= x"1f94";
		when x"28b" => sin_out <= x"1fa0";
		when x"28c" => sin_out <= x"1fac";
		when x"28d" => sin_out <= x"1fb8";
		when x"28e" => sin_out <= x"1fc4";
		when x"28f" => sin_out <= x"1fd0";
		when x"290" => sin_out <= x"1fdd";
		when x"291" => sin_out <= x"1fe9";
		when x"292" => sin_out <= x"1ff5";
		when x"293" => sin_out <= x"2001";
		when x"294" => sin_out <= x"200d";
		when x"295" => sin_out <= x"2019";
		when x"296" => sin_out <= x"2026";
		when x"297" => sin_out <= x"2032";
		when x"298" => sin_out <= x"203e";
		when x"299" => sin_out <= x"204a";
		when x"29a" => sin_out <= x"2056";
		when x"29b" => sin_out <= x"2062";
		when x"29c" => sin_out <= x"206f";
		when x"29d" => sin_out <= x"207b";
		when x"29e" => sin_out <= x"2087";
		when x"29f" => sin_out <= x"2093";
		when x"2a0" => sin_out <= x"209f";
		when x"2a1" => sin_out <= x"20ab";
		when x"2a2" => sin_out <= x"20b7";
		when x"2a3" => sin_out <= x"20c4";
		when x"2a4" => sin_out <= x"20d0";
		when x"2a5" => sin_out <= x"20dc";
		when x"2a6" => sin_out <= x"20e8";
		when x"2a7" => sin_out <= x"20f4";
		when x"2a8" => sin_out <= x"2100";
		when x"2a9" => sin_out <= x"210c";
		when x"2aa" => sin_out <= x"2119";
		when x"2ab" => sin_out <= x"2125";
		when x"2ac" => sin_out <= x"2131";
		when x"2ad" => sin_out <= x"213d";
		when x"2ae" => sin_out <= x"2149";
		when x"2af" => sin_out <= x"2155";
		when x"2b0" => sin_out <= x"2161";
		when x"2b1" => sin_out <= x"216e";
		when x"2b2" => sin_out <= x"217a";
		when x"2b3" => sin_out <= x"2186";
		when x"2b4" => sin_out <= x"2192";
		when x"2b5" => sin_out <= x"219e";
		when x"2b6" => sin_out <= x"21aa";
		when x"2b7" => sin_out <= x"21b6";
		when x"2b8" => sin_out <= x"21c2";
		when x"2b9" => sin_out <= x"21cf";
		when x"2ba" => sin_out <= x"21db";
		when x"2bb" => sin_out <= x"21e7";
		when x"2bc" => sin_out <= x"21f3";
		when x"2bd" => sin_out <= x"21ff";
		when x"2be" => sin_out <= x"220b";
		when x"2bf" => sin_out <= x"2217";
		when x"2c0" => sin_out <= x"2223";
		when x"2c1" => sin_out <= x"222f";
		when x"2c2" => sin_out <= x"223c";
		when x"2c3" => sin_out <= x"2248";
		when x"2c4" => sin_out <= x"2254";
		when x"2c5" => sin_out <= x"2260";
		when x"2c6" => sin_out <= x"226c";
		when x"2c7" => sin_out <= x"2278";
		when x"2c8" => sin_out <= x"2284";
		when x"2c9" => sin_out <= x"2290";
		when x"2ca" => sin_out <= x"229c";
		when x"2cb" => sin_out <= x"22a9";
		when x"2cc" => sin_out <= x"22b5";
		when x"2cd" => sin_out <= x"22c1";
		when x"2ce" => sin_out <= x"22cd";
		when x"2cf" => sin_out <= x"22d9";
		when x"2d0" => sin_out <= x"22e5";
		when x"2d1" => sin_out <= x"22f1";
		when x"2d2" => sin_out <= x"22fd";
		when x"2d3" => sin_out <= x"2309";
		when x"2d4" => sin_out <= x"2315";
		when x"2d5" => sin_out <= x"2321";
		when x"2d6" => sin_out <= x"232e";
		when x"2d7" => sin_out <= x"233a";
		when x"2d8" => sin_out <= x"2346";
		when x"2d9" => sin_out <= x"2352";
		when x"2da" => sin_out <= x"235e";
		when x"2db" => sin_out <= x"236a";
		when x"2dc" => sin_out <= x"2376";
		when x"2dd" => sin_out <= x"2382";
		when x"2de" => sin_out <= x"238e";
		when x"2df" => sin_out <= x"239a";
		when x"2e0" => sin_out <= x"23a6";
		when x"2e1" => sin_out <= x"23b2";
		when x"2e2" => sin_out <= x"23be";
		when x"2e3" => sin_out <= x"23ca";
		when x"2e4" => sin_out <= x"23d7";
		when x"2e5" => sin_out <= x"23e3";
		when x"2e6" => sin_out <= x"23ef";
		when x"2e7" => sin_out <= x"23fb";
		when x"2e8" => sin_out <= x"2407";
		when x"2e9" => sin_out <= x"2413";
		when x"2ea" => sin_out <= x"241f";
		when x"2eb" => sin_out <= x"242b";
		when x"2ec" => sin_out <= x"2437";
		when x"2ed" => sin_out <= x"2443";
		when x"2ee" => sin_out <= x"244f";
		when x"2ef" => sin_out <= x"245b";
		when x"2f0" => sin_out <= x"2467";
		when x"2f1" => sin_out <= x"2473";
		when x"2f2" => sin_out <= x"247f";
		when x"2f3" => sin_out <= x"248b";
		when x"2f4" => sin_out <= x"2497";
		when x"2f5" => sin_out <= x"24a3";
		when x"2f6" => sin_out <= x"24af";
		when x"2f7" => sin_out <= x"24bb";
		when x"2f8" => sin_out <= x"24c8";
		when x"2f9" => sin_out <= x"24d4";
		when x"2fa" => sin_out <= x"24e0";
		when x"2fb" => sin_out <= x"24ec";
		when x"2fc" => sin_out <= x"24f8";
		when x"2fd" => sin_out <= x"2504";
		when x"2fe" => sin_out <= x"2510";
		when x"2ff" => sin_out <= x"251c";
		when x"300" => sin_out <= x"2528";
		when x"301" => sin_out <= x"2534";
		when x"302" => sin_out <= x"2540";
		when x"303" => sin_out <= x"254c";
		when x"304" => sin_out <= x"2558";
		when x"305" => sin_out <= x"2564";
		when x"306" => sin_out <= x"2570";
		when x"307" => sin_out <= x"257c";
		when x"308" => sin_out <= x"2588";
		when x"309" => sin_out <= x"2594";
		when x"30a" => sin_out <= x"25a0";
		when x"30b" => sin_out <= x"25ac";
		when x"30c" => sin_out <= x"25b8";
		when x"30d" => sin_out <= x"25c4";
		when x"30e" => sin_out <= x"25d0";
		when x"30f" => sin_out <= x"25dc";
		when x"310" => sin_out <= x"25e8";
		when x"311" => sin_out <= x"25f4";
		when x"312" => sin_out <= x"2600";
		when x"313" => sin_out <= x"260c";
		when x"314" => sin_out <= x"2618";
		when x"315" => sin_out <= x"2624";
		when x"316" => sin_out <= x"2630";
		when x"317" => sin_out <= x"263c";
		when x"318" => sin_out <= x"2648";
		when x"319" => sin_out <= x"2654";
		when x"31a" => sin_out <= x"2660";
		when x"31b" => sin_out <= x"266c";
		when x"31c" => sin_out <= x"2678";
		when x"31d" => sin_out <= x"2684";
		when x"31e" => sin_out <= x"2690";
		when x"31f" => sin_out <= x"269c";
		when x"320" => sin_out <= x"26a8";
		when x"321" => sin_out <= x"26b4";
		when x"322" => sin_out <= x"26c0";
		when x"323" => sin_out <= x"26cc";
		when x"324" => sin_out <= x"26d8";
		when x"325" => sin_out <= x"26e4";
		when x"326" => sin_out <= x"26f0";
		when x"327" => sin_out <= x"26fc";
		when x"328" => sin_out <= x"2708";
		when x"329" => sin_out <= x"2714";
		when x"32a" => sin_out <= x"2720";
		when x"32b" => sin_out <= x"272c";
		when x"32c" => sin_out <= x"2737";
		when x"32d" => sin_out <= x"2743";
		when x"32e" => sin_out <= x"274f";
		when x"32f" => sin_out <= x"275b";
		when x"330" => sin_out <= x"2767";
		when x"331" => sin_out <= x"2773";
		when x"332" => sin_out <= x"277f";
		when x"333" => sin_out <= x"278b";
		when x"334" => sin_out <= x"2797";
		when x"335" => sin_out <= x"27a3";
		when x"336" => sin_out <= x"27af";
		when x"337" => sin_out <= x"27bb";
		when x"338" => sin_out <= x"27c7";
		when x"339" => sin_out <= x"27d3";
		when x"33a" => sin_out <= x"27df";
		when x"33b" => sin_out <= x"27eb";
		when x"33c" => sin_out <= x"27f7";
		when x"33d" => sin_out <= x"2803";
		when x"33e" => sin_out <= x"280f";
		when x"33f" => sin_out <= x"281a";
		when x"340" => sin_out <= x"2826";
		when x"341" => sin_out <= x"2832";
		when x"342" => sin_out <= x"283e";
		when x"343" => sin_out <= x"284a";
		when x"344" => sin_out <= x"2856";
		when x"345" => sin_out <= x"2862";
		when x"346" => sin_out <= x"286e";
		when x"347" => sin_out <= x"287a";
		when x"348" => sin_out <= x"2886";
		when x"349" => sin_out <= x"2892";
		when x"34a" => sin_out <= x"289e";
		when x"34b" => sin_out <= x"28aa";
		when x"34c" => sin_out <= x"28b5";
		when x"34d" => sin_out <= x"28c1";
		when x"34e" => sin_out <= x"28cd";
		when x"34f" => sin_out <= x"28d9";
		when x"350" => sin_out <= x"28e5";
		when x"351" => sin_out <= x"28f1";
		when x"352" => sin_out <= x"28fd";
		when x"353" => sin_out <= x"2909";
		when x"354" => sin_out <= x"2915";
		when x"355" => sin_out <= x"2921";
		when x"356" => sin_out <= x"292d";
		when x"357" => sin_out <= x"2938";
		when x"358" => sin_out <= x"2944";
		when x"359" => sin_out <= x"2950";
		when x"35a" => sin_out <= x"295c";
		when x"35b" => sin_out <= x"2968";
		when x"35c" => sin_out <= x"2974";
		when x"35d" => sin_out <= x"2980";
		when x"35e" => sin_out <= x"298c";
		when x"35f" => sin_out <= x"2998";
		when x"360" => sin_out <= x"29a3";
		when x"361" => sin_out <= x"29af";
		when x"362" => sin_out <= x"29bb";
		when x"363" => sin_out <= x"29c7";
		when x"364" => sin_out <= x"29d3";
		when x"365" => sin_out <= x"29df";
		when x"366" => sin_out <= x"29eb";
		when x"367" => sin_out <= x"29f7";
		when x"368" => sin_out <= x"2a02";
		when x"369" => sin_out <= x"2a0e";
		when x"36a" => sin_out <= x"2a1a";
		when x"36b" => sin_out <= x"2a26";
		when x"36c" => sin_out <= x"2a32";
		when x"36d" => sin_out <= x"2a3e";
		when x"36e" => sin_out <= x"2a4a";
		when x"36f" => sin_out <= x"2a56";
		when x"370" => sin_out <= x"2a61";
		when x"371" => sin_out <= x"2a6d";
		when x"372" => sin_out <= x"2a79";
		when x"373" => sin_out <= x"2a85";
		when x"374" => sin_out <= x"2a91";
		when x"375" => sin_out <= x"2a9d";
		when x"376" => sin_out <= x"2aa8";
		when x"377" => sin_out <= x"2ab4";
		when x"378" => sin_out <= x"2ac0";
		when x"379" => sin_out <= x"2acc";
		when x"37a" => sin_out <= x"2ad8";
		when x"37b" => sin_out <= x"2ae4";
		when x"37c" => sin_out <= x"2af0";
		when x"37d" => sin_out <= x"2afb";
		when x"37e" => sin_out <= x"2b07";
		when x"37f" => sin_out <= x"2b13";
		when x"380" => sin_out <= x"2b1f";
		when x"381" => sin_out <= x"2b2b";
		when x"382" => sin_out <= x"2b37";
		when x"383" => sin_out <= x"2b42";
		when x"384" => sin_out <= x"2b4e";
		when x"385" => sin_out <= x"2b5a";
		when x"386" => sin_out <= x"2b66";
		when x"387" => sin_out <= x"2b72";
		when x"388" => sin_out <= x"2b7d";
		when x"389" => sin_out <= x"2b89";
		when x"38a" => sin_out <= x"2b95";
		when x"38b" => sin_out <= x"2ba1";
		when x"38c" => sin_out <= x"2bad";
		when x"38d" => sin_out <= x"2bb9";
		when x"38e" => sin_out <= x"2bc4";
		when x"38f" => sin_out <= x"2bd0";
		when x"390" => sin_out <= x"2bdc";
		when x"391" => sin_out <= x"2be8";
		when x"392" => sin_out <= x"2bf4";
		when x"393" => sin_out <= x"2bff";
		when x"394" => sin_out <= x"2c0b";
		when x"395" => sin_out <= x"2c17";
		when x"396" => sin_out <= x"2c23";
		when x"397" => sin_out <= x"2c2f";
		when x"398" => sin_out <= x"2c3a";
		when x"399" => sin_out <= x"2c46";
		when x"39a" => sin_out <= x"2c52";
		when x"39b" => sin_out <= x"2c5e";
		when x"39c" => sin_out <= x"2c6a";
		when x"39d" => sin_out <= x"2c75";
		when x"39e" => sin_out <= x"2c81";
		when x"39f" => sin_out <= x"2c8d";
		when x"3a0" => sin_out <= x"2c99";
		when x"3a1" => sin_out <= x"2ca4";
		when x"3a2" => sin_out <= x"2cb0";
		when x"3a3" => sin_out <= x"2cbc";
		when x"3a4" => sin_out <= x"2cc8";
		when x"3a5" => sin_out <= x"2cd4";
		when x"3a6" => sin_out <= x"2cdf";
		when x"3a7" => sin_out <= x"2ceb";
		when x"3a8" => sin_out <= x"2cf7";
		when x"3a9" => sin_out <= x"2d03";
		when x"3aa" => sin_out <= x"2d0e";
		when x"3ab" => sin_out <= x"2d1a";
		when x"3ac" => sin_out <= x"2d26";
		when x"3ad" => sin_out <= x"2d32";
		when x"3ae" => sin_out <= x"2d3d";
		when x"3af" => sin_out <= x"2d49";
		when x"3b0" => sin_out <= x"2d55";
		when x"3b1" => sin_out <= x"2d61";
		when x"3b2" => sin_out <= x"2d6c";
		when x"3b3" => sin_out <= x"2d78";
		when x"3b4" => sin_out <= x"2d84";
		when x"3b5" => sin_out <= x"2d90";
		when x"3b6" => sin_out <= x"2d9b";
		when x"3b7" => sin_out <= x"2da7";
		when x"3b8" => sin_out <= x"2db3";
		when x"3b9" => sin_out <= x"2dbf";
		when x"3ba" => sin_out <= x"2dca";
		when x"3bb" => sin_out <= x"2dd6";
		when x"3bc" => sin_out <= x"2de2";
		when x"3bd" => sin_out <= x"2dee";
		when x"3be" => sin_out <= x"2df9";
		when x"3bf" => sin_out <= x"2e05";
		when x"3c0" => sin_out <= x"2e11";
		when x"3c1" => sin_out <= x"2e1c";
		when x"3c2" => sin_out <= x"2e28";
		when x"3c3" => sin_out <= x"2e34";
		when x"3c4" => sin_out <= x"2e40";
		when x"3c5" => sin_out <= x"2e4b";
		when x"3c6" => sin_out <= x"2e57";
		when x"3c7" => sin_out <= x"2e63";
		when x"3c8" => sin_out <= x"2e6e";
		when x"3c9" => sin_out <= x"2e7a";
		when x"3ca" => sin_out <= x"2e86";
		when x"3cb" => sin_out <= x"2e92";
		when x"3cc" => sin_out <= x"2e9d";
		when x"3cd" => sin_out <= x"2ea9";
		when x"3ce" => sin_out <= x"2eb5";
		when x"3cf" => sin_out <= x"2ec0";
		when x"3d0" => sin_out <= x"2ecc";
		when x"3d1" => sin_out <= x"2ed8";
		when x"3d2" => sin_out <= x"2ee3";
		when x"3d3" => sin_out <= x"2eef";
		when x"3d4" => sin_out <= x"2efb";
		when x"3d5" => sin_out <= x"2f06";
		when x"3d6" => sin_out <= x"2f12";
		when x"3d7" => sin_out <= x"2f1e";
		when x"3d8" => sin_out <= x"2f2a";
		when x"3d9" => sin_out <= x"2f35";
		when x"3da" => sin_out <= x"2f41";
		when x"3db" => sin_out <= x"2f4d";
		when x"3dc" => sin_out <= x"2f58";
		when x"3dd" => sin_out <= x"2f64";
		when x"3de" => sin_out <= x"2f70";
		when x"3df" => sin_out <= x"2f7b";
		when x"3e0" => sin_out <= x"2f87";
		when x"3e1" => sin_out <= x"2f93";
		when x"3e2" => sin_out <= x"2f9e";
		when x"3e3" => sin_out <= x"2faa";
		when x"3e4" => sin_out <= x"2fb6";
		when x"3e5" => sin_out <= x"2fc1";
		when x"3e6" => sin_out <= x"2fcd";
		when x"3e7" => sin_out <= x"2fd9";
		when x"3e8" => sin_out <= x"2fe4";
		when x"3e9" => sin_out <= x"2ff0";
		when x"3ea" => sin_out <= x"2ffc";
		when x"3eb" => sin_out <= x"3007";
		when x"3ec" => sin_out <= x"3013";
		when x"3ed" => sin_out <= x"301e";
		when x"3ee" => sin_out <= x"302a";
		when x"3ef" => sin_out <= x"3036";
		when x"3f0" => sin_out <= x"3041";
		when x"3f1" => sin_out <= x"304d";
		when x"3f2" => sin_out <= x"3059";
		when x"3f3" => sin_out <= x"3064";
		when x"3f4" => sin_out <= x"3070";
		when x"3f5" => sin_out <= x"307c";
		when x"3f6" => sin_out <= x"3087";
		when x"3f7" => sin_out <= x"3093";
		when x"3f8" => sin_out <= x"309e";
		when x"3f9" => sin_out <= x"30aa";
		when x"3fa" => sin_out <= x"30b6";
		when x"3fb" => sin_out <= x"30c1";
		when x"3fc" => sin_out <= x"30cd";
		when x"3fd" => sin_out <= x"30d9";
		when x"3fe" => sin_out <= x"30e4";
		when x"3ff" => sin_out <= x"30f0";
		when x"400" => sin_out <= x"30fb";
		when x"401" => sin_out <= x"3107";
		when x"402" => sin_out <= x"3113";
		when x"403" => sin_out <= x"311e";
		when x"404" => sin_out <= x"312a";
		when x"405" => sin_out <= x"3135";
		when x"406" => sin_out <= x"3141";
		when x"407" => sin_out <= x"314d";
		when x"408" => sin_out <= x"3158";
		when x"409" => sin_out <= x"3164";
		when x"40a" => sin_out <= x"316f";
		when x"40b" => sin_out <= x"317b";
		when x"40c" => sin_out <= x"3187";
		when x"40d" => sin_out <= x"3192";
		when x"40e" => sin_out <= x"319e";
		when x"40f" => sin_out <= x"31a9";
		when x"410" => sin_out <= x"31b5";
		when x"411" => sin_out <= x"31c0";
		when x"412" => sin_out <= x"31cc";
		when x"413" => sin_out <= x"31d8";
		when x"414" => sin_out <= x"31e3";
		when x"415" => sin_out <= x"31ef";
		when x"416" => sin_out <= x"31fa";
		when x"417" => sin_out <= x"3206";
		when x"418" => sin_out <= x"3211";
		when x"419" => sin_out <= x"321d";
		when x"41a" => sin_out <= x"3229";
		when x"41b" => sin_out <= x"3234";
		when x"41c" => sin_out <= x"3240";
		when x"41d" => sin_out <= x"324b";
		when x"41e" => sin_out <= x"3257";
		when x"41f" => sin_out <= x"3262";
		when x"420" => sin_out <= x"326e";
		when x"421" => sin_out <= x"3279";
		when x"422" => sin_out <= x"3285";
		when x"423" => sin_out <= x"3291";
		when x"424" => sin_out <= x"329c";
		when x"425" => sin_out <= x"32a8";
		when x"426" => sin_out <= x"32b3";
		when x"427" => sin_out <= x"32bf";
		when x"428" => sin_out <= x"32ca";
		when x"429" => sin_out <= x"32d6";
		when x"42a" => sin_out <= x"32e1";
		when x"42b" => sin_out <= x"32ed";
		when x"42c" => sin_out <= x"32f8";
		when x"42d" => sin_out <= x"3304";
		when x"42e" => sin_out <= x"330f";
		when x"42f" => sin_out <= x"331b";
		when x"430" => sin_out <= x"3326";
		when x"431" => sin_out <= x"3332";
		when x"432" => sin_out <= x"333e";
		when x"433" => sin_out <= x"3349";
		when x"434" => sin_out <= x"3355";
		when x"435" => sin_out <= x"3360";
		when x"436" => sin_out <= x"336c";
		when x"437" => sin_out <= x"3377";
		when x"438" => sin_out <= x"3383";
		when x"439" => sin_out <= x"338e";
		when x"43a" => sin_out <= x"339a";
		when x"43b" => sin_out <= x"33a5";
		when x"43c" => sin_out <= x"33b1";
		when x"43d" => sin_out <= x"33bc";
		when x"43e" => sin_out <= x"33c8";
		when x"43f" => sin_out <= x"33d3";
		when x"440" => sin_out <= x"33df";
		when x"441" => sin_out <= x"33ea";
		when x"442" => sin_out <= x"33f6";
		when x"443" => sin_out <= x"3401";
		when x"444" => sin_out <= x"340c";
		when x"445" => sin_out <= x"3418";
		when x"446" => sin_out <= x"3423";
		when x"447" => sin_out <= x"342f";
		when x"448" => sin_out <= x"343a";
		when x"449" => sin_out <= x"3446";
		when x"44a" => sin_out <= x"3451";
		when x"44b" => sin_out <= x"345d";
		when x"44c" => sin_out <= x"3468";
		when x"44d" => sin_out <= x"3474";
		when x"44e" => sin_out <= x"347f";
		when x"44f" => sin_out <= x"348b";
		when x"450" => sin_out <= x"3496";
		when x"451" => sin_out <= x"34a2";
		when x"452" => sin_out <= x"34ad";
		when x"453" => sin_out <= x"34b8";
		when x"454" => sin_out <= x"34c4";
		when x"455" => sin_out <= x"34cf";
		when x"456" => sin_out <= x"34db";
		when x"457" => sin_out <= x"34e6";
		when x"458" => sin_out <= x"34f2";
		when x"459" => sin_out <= x"34fd";
		when x"45a" => sin_out <= x"3509";
		when x"45b" => sin_out <= x"3514";
		when x"45c" => sin_out <= x"351f";
		when x"45d" => sin_out <= x"352b";
		when x"45e" => sin_out <= x"3536";
		when x"45f" => sin_out <= x"3542";
		when x"460" => sin_out <= x"354d";
		when x"461" => sin_out <= x"3559";
		when x"462" => sin_out <= x"3564";
		when x"463" => sin_out <= x"356f";
		when x"464" => sin_out <= x"357b";
		when x"465" => sin_out <= x"3586";
		when x"466" => sin_out <= x"3592";
		when x"467" => sin_out <= x"359d";
		when x"468" => sin_out <= x"35a8";
		when x"469" => sin_out <= x"35b4";
		when x"46a" => sin_out <= x"35bf";
		when x"46b" => sin_out <= x"35cb";
		when x"46c" => sin_out <= x"35d6";
		when x"46d" => sin_out <= x"35e1";
		when x"46e" => sin_out <= x"35ed";
		when x"46f" => sin_out <= x"35f8";
		when x"470" => sin_out <= x"3604";
		when x"471" => sin_out <= x"360f";
		when x"472" => sin_out <= x"361a";
		when x"473" => sin_out <= x"3626";
		when x"474" => sin_out <= x"3631";
		when x"475" => sin_out <= x"363d";
		when x"476" => sin_out <= x"3648";
		when x"477" => sin_out <= x"3653";
		when x"478" => sin_out <= x"365f";
		when x"479" => sin_out <= x"366a";
		when x"47a" => sin_out <= x"3676";
		when x"47b" => sin_out <= x"3681";
		when x"47c" => sin_out <= x"368c";
		when x"47d" => sin_out <= x"3698";
		when x"47e" => sin_out <= x"36a3";
		when x"47f" => sin_out <= x"36ae";
		when x"480" => sin_out <= x"36ba";
		when x"481" => sin_out <= x"36c5";
		when x"482" => sin_out <= x"36d0";
		when x"483" => sin_out <= x"36dc";
		when x"484" => sin_out <= x"36e7";
		when x"485" => sin_out <= x"36f2";
		when x"486" => sin_out <= x"36fe";
		when x"487" => sin_out <= x"3709";
		when x"488" => sin_out <= x"3715";
		when x"489" => sin_out <= x"3720";
		when x"48a" => sin_out <= x"372b";
		when x"48b" => sin_out <= x"3737";
		when x"48c" => sin_out <= x"3742";
		when x"48d" => sin_out <= x"374d";
		when x"48e" => sin_out <= x"3759";
		when x"48f" => sin_out <= x"3764";
		when x"490" => sin_out <= x"376f";
		when x"491" => sin_out <= x"377b";
		when x"492" => sin_out <= x"3786";
		when x"493" => sin_out <= x"3791";
		when x"494" => sin_out <= x"379c";
		when x"495" => sin_out <= x"37a8";
		when x"496" => sin_out <= x"37b3";
		when x"497" => sin_out <= x"37be";
		when x"498" => sin_out <= x"37ca";
		when x"499" => sin_out <= x"37d5";
		when x"49a" => sin_out <= x"37e0";
		when x"49b" => sin_out <= x"37ec";
		when x"49c" => sin_out <= x"37f7";
		when x"49d" => sin_out <= x"3802";
		when x"49e" => sin_out <= x"380e";
		when x"49f" => sin_out <= x"3819";
		when x"4a0" => sin_out <= x"3824";
		when x"4a1" => sin_out <= x"382f";
		when x"4a2" => sin_out <= x"383b";
		when x"4a3" => sin_out <= x"3846";
		when x"4a4" => sin_out <= x"3851";
		when x"4a5" => sin_out <= x"385d";
		when x"4a6" => sin_out <= x"3868";
		when x"4a7" => sin_out <= x"3873";
		when x"4a8" => sin_out <= x"387e";
		when x"4a9" => sin_out <= x"388a";
		when x"4aa" => sin_out <= x"3895";
		when x"4ab" => sin_out <= x"38a0";
		when x"4ac" => sin_out <= x"38ab";
		when x"4ad" => sin_out <= x"38b7";
		when x"4ae" => sin_out <= x"38c2";
		when x"4af" => sin_out <= x"38cd";
		when x"4b0" => sin_out <= x"38d9";
		when x"4b1" => sin_out <= x"38e4";
		when x"4b2" => sin_out <= x"38ef";
		when x"4b3" => sin_out <= x"38fa";
		when x"4b4" => sin_out <= x"3906";
		when x"4b5" => sin_out <= x"3911";
		when x"4b6" => sin_out <= x"391c";
		when x"4b7" => sin_out <= x"3927";
		when x"4b8" => sin_out <= x"3933";
		when x"4b9" => sin_out <= x"393e";
		when x"4ba" => sin_out <= x"3949";
		when x"4bb" => sin_out <= x"3954";
		when x"4bc" => sin_out <= x"3960";
		when x"4bd" => sin_out <= x"396b";
		when x"4be" => sin_out <= x"3976";
		when x"4bf" => sin_out <= x"3981";
		when x"4c0" => sin_out <= x"398c";
		when x"4c1" => sin_out <= x"3998";
		when x"4c2" => sin_out <= x"39a3";
		when x"4c3" => sin_out <= x"39ae";
		when x"4c4" => sin_out <= x"39b9";
		when x"4c5" => sin_out <= x"39c5";
		when x"4c6" => sin_out <= x"39d0";
		when x"4c7" => sin_out <= x"39db";
		when x"4c8" => sin_out <= x"39e6";
		when x"4c9" => sin_out <= x"39f1";
		when x"4ca" => sin_out <= x"39fd";
		when x"4cb" => sin_out <= x"3a08";
		when x"4cc" => sin_out <= x"3a13";
		when x"4cd" => sin_out <= x"3a1e";
		when x"4ce" => sin_out <= x"3a29";
		when x"4cf" => sin_out <= x"3a35";
		when x"4d0" => sin_out <= x"3a40";
		when x"4d1" => sin_out <= x"3a4b";
		when x"4d2" => sin_out <= x"3a56";
		when x"4d3" => sin_out <= x"3a61";
		when x"4d4" => sin_out <= x"3a6c";
		when x"4d5" => sin_out <= x"3a78";
		when x"4d6" => sin_out <= x"3a83";
		when x"4d7" => sin_out <= x"3a8e";
		when x"4d8" => sin_out <= x"3a99";
		when x"4d9" => sin_out <= x"3aa4";
		when x"4da" => sin_out <= x"3ab0";
		when x"4db" => sin_out <= x"3abb";
		when x"4dc" => sin_out <= x"3ac6";
		when x"4dd" => sin_out <= x"3ad1";
		when x"4de" => sin_out <= x"3adc";
		when x"4df" => sin_out <= x"3ae7";
		when x"4e0" => sin_out <= x"3af2";
		when x"4e1" => sin_out <= x"3afe";
		when x"4e2" => sin_out <= x"3b09";
		when x"4e3" => sin_out <= x"3b14";
		when x"4e4" => sin_out <= x"3b1f";
		when x"4e5" => sin_out <= x"3b2a";
		when x"4e6" => sin_out <= x"3b35";
		when x"4e7" => sin_out <= x"3b40";
		when x"4e8" => sin_out <= x"3b4c";
		when x"4e9" => sin_out <= x"3b57";
		when x"4ea" => sin_out <= x"3b62";
		when x"4eb" => sin_out <= x"3b6d";
		when x"4ec" => sin_out <= x"3b78";
		when x"4ed" => sin_out <= x"3b83";
		when x"4ee" => sin_out <= x"3b8e";
		when x"4ef" => sin_out <= x"3b9a";
		when x"4f0" => sin_out <= x"3ba5";
		when x"4f1" => sin_out <= x"3bb0";
		when x"4f2" => sin_out <= x"3bbb";
		when x"4f3" => sin_out <= x"3bc6";
		when x"4f4" => sin_out <= x"3bd1";
		when x"4f5" => sin_out <= x"3bdc";
		when x"4f6" => sin_out <= x"3be7";
		when x"4f7" => sin_out <= x"3bf2";
		when x"4f8" => sin_out <= x"3bfe";
		when x"4f9" => sin_out <= x"3c09";
		when x"4fa" => sin_out <= x"3c14";
		when x"4fb" => sin_out <= x"3c1f";
		when x"4fc" => sin_out <= x"3c2a";
		when x"4fd" => sin_out <= x"3c35";
		when x"4fe" => sin_out <= x"3c40";
		when x"4ff" => sin_out <= x"3c4b";
		when x"500" => sin_out <= x"3c56";
		when x"501" => sin_out <= x"3c61";
		when x"502" => sin_out <= x"3c6c";
		when x"503" => sin_out <= x"3c77";
		when x"504" => sin_out <= x"3c83";
		when x"505" => sin_out <= x"3c8e";
		when x"506" => sin_out <= x"3c99";
		when x"507" => sin_out <= x"3ca4";
		when x"508" => sin_out <= x"3caf";
		when x"509" => sin_out <= x"3cba";
		when x"50a" => sin_out <= x"3cc5";
		when x"50b" => sin_out <= x"3cd0";
		when x"50c" => sin_out <= x"3cdb";
		when x"50d" => sin_out <= x"3ce6";
		when x"50e" => sin_out <= x"3cf1";
		when x"50f" => sin_out <= x"3cfc";
		when x"510" => sin_out <= x"3d07";
		when x"511" => sin_out <= x"3d12";
		when x"512" => sin_out <= x"3d1d";
		when x"513" => sin_out <= x"3d28";
		when x"514" => sin_out <= x"3d33";
		when x"515" => sin_out <= x"3d3e";
		when x"516" => sin_out <= x"3d4a";
		when x"517" => sin_out <= x"3d55";
		when x"518" => sin_out <= x"3d60";
		when x"519" => sin_out <= x"3d6b";
		when x"51a" => sin_out <= x"3d76";
		when x"51b" => sin_out <= x"3d81";
		when x"51c" => sin_out <= x"3d8c";
		when x"51d" => sin_out <= x"3d97";
		when x"51e" => sin_out <= x"3da2";
		when x"51f" => sin_out <= x"3dad";
		when x"520" => sin_out <= x"3db8";
		when x"521" => sin_out <= x"3dc3";
		when x"522" => sin_out <= x"3dce";
		when x"523" => sin_out <= x"3dd9";
		when x"524" => sin_out <= x"3de4";
		when x"525" => sin_out <= x"3def";
		when x"526" => sin_out <= x"3dfa";
		when x"527" => sin_out <= x"3e05";
		when x"528" => sin_out <= x"3e10";
		when x"529" => sin_out <= x"3e1b";
		when x"52a" => sin_out <= x"3e26";
		when x"52b" => sin_out <= x"3e31";
		when x"52c" => sin_out <= x"3e3c";
		when x"52d" => sin_out <= x"3e47";
		when x"52e" => sin_out <= x"3e52";
		when x"52f" => sin_out <= x"3e5d";
		when x"530" => sin_out <= x"3e68";
		when x"531" => sin_out <= x"3e73";
		when x"532" => sin_out <= x"3e7d";
		when x"533" => sin_out <= x"3e88";
		when x"534" => sin_out <= x"3e93";
		when x"535" => sin_out <= x"3e9e";
		when x"536" => sin_out <= x"3ea9";
		when x"537" => sin_out <= x"3eb4";
		when x"538" => sin_out <= x"3ebf";
		when x"539" => sin_out <= x"3eca";
		when x"53a" => sin_out <= x"3ed5";
		when x"53b" => sin_out <= x"3ee0";
		when x"53c" => sin_out <= x"3eeb";
		when x"53d" => sin_out <= x"3ef6";
		when x"53e" => sin_out <= x"3f01";
		when x"53f" => sin_out <= x"3f0c";
		when x"540" => sin_out <= x"3f17";
		when x"541" => sin_out <= x"3f22";
		when x"542" => sin_out <= x"3f2d";
		when x"543" => sin_out <= x"3f38";
		when x"544" => sin_out <= x"3f43";
		when x"545" => sin_out <= x"3f4d";
		when x"546" => sin_out <= x"3f58";
		when x"547" => sin_out <= x"3f63";
		when x"548" => sin_out <= x"3f6e";
		when x"549" => sin_out <= x"3f79";
		when x"54a" => sin_out <= x"3f84";
		when x"54b" => sin_out <= x"3f8f";
		when x"54c" => sin_out <= x"3f9a";
		when x"54d" => sin_out <= x"3fa5";
		when x"54e" => sin_out <= x"3fb0";
		when x"54f" => sin_out <= x"3fbb";
		when x"550" => sin_out <= x"3fc5";
		when x"551" => sin_out <= x"3fd0";
		when x"552" => sin_out <= x"3fdb";
		when x"553" => sin_out <= x"3fe6";
		when x"554" => sin_out <= x"3ff1";
		when x"555" => sin_out <= x"3ffc";
		when x"556" => sin_out <= x"4007";
		when x"557" => sin_out <= x"4012";
		when x"558" => sin_out <= x"401d";
		when x"559" => sin_out <= x"4027";
		when x"55a" => sin_out <= x"4032";
		when x"55b" => sin_out <= x"403d";
		when x"55c" => sin_out <= x"4048";
		when x"55d" => sin_out <= x"4053";
		when x"55e" => sin_out <= x"405e";
		when x"55f" => sin_out <= x"4069";
		when x"560" => sin_out <= x"4073";
		when x"561" => sin_out <= x"407e";
		when x"562" => sin_out <= x"4089";
		when x"563" => sin_out <= x"4094";
		when x"564" => sin_out <= x"409f";
		when x"565" => sin_out <= x"40aa";
		when x"566" => sin_out <= x"40b5";
		when x"567" => sin_out <= x"40bf";
		when x"568" => sin_out <= x"40ca";
		when x"569" => sin_out <= x"40d5";
		when x"56a" => sin_out <= x"40e0";
		when x"56b" => sin_out <= x"40eb";
		when x"56c" => sin_out <= x"40f6";
		when x"56d" => sin_out <= x"4100";
		when x"56e" => sin_out <= x"410b";
		when x"56f" => sin_out <= x"4116";
		when x"570" => sin_out <= x"4121";
		when x"571" => sin_out <= x"412c";
		when x"572" => sin_out <= x"4136";
		when x"573" => sin_out <= x"4141";
		when x"574" => sin_out <= x"414c";
		when x"575" => sin_out <= x"4157";
		when x"576" => sin_out <= x"4162";
		when x"577" => sin_out <= x"416d";
		when x"578" => sin_out <= x"4177";
		when x"579" => sin_out <= x"4182";
		when x"57a" => sin_out <= x"418d";
		when x"57b" => sin_out <= x"4198";
		when x"57c" => sin_out <= x"41a2";
		when x"57d" => sin_out <= x"41ad";
		when x"57e" => sin_out <= x"41b8";
		when x"57f" => sin_out <= x"41c3";
		when x"580" => sin_out <= x"41ce";
		when x"581" => sin_out <= x"41d8";
		when x"582" => sin_out <= x"41e3";
		when x"583" => sin_out <= x"41ee";
		when x"584" => sin_out <= x"41f9";
		when x"585" => sin_out <= x"4203";
		when x"586" => sin_out <= x"420e";
		when x"587" => sin_out <= x"4219";
		when x"588" => sin_out <= x"4224";
		when x"589" => sin_out <= x"422f";
		when x"58a" => sin_out <= x"4239";
		when x"58b" => sin_out <= x"4244";
		when x"58c" => sin_out <= x"424f";
		when x"58d" => sin_out <= x"425a";
		when x"58e" => sin_out <= x"4264";
		when x"58f" => sin_out <= x"426f";
		when x"590" => sin_out <= x"427a";
		when x"591" => sin_out <= x"4284";
		when x"592" => sin_out <= x"428f";
		when x"593" => sin_out <= x"429a";
		when x"594" => sin_out <= x"42a5";
		when x"595" => sin_out <= x"42af";
		when x"596" => sin_out <= x"42ba";
		when x"597" => sin_out <= x"42c5";
		when x"598" => sin_out <= x"42d0";
		when x"599" => sin_out <= x"42da";
		when x"59a" => sin_out <= x"42e5";
		when x"59b" => sin_out <= x"42f0";
		when x"59c" => sin_out <= x"42fa";
		when x"59d" => sin_out <= x"4305";
		when x"59e" => sin_out <= x"4310";
		when x"59f" => sin_out <= x"431b";
		when x"5a0" => sin_out <= x"4325";
		when x"5a1" => sin_out <= x"4330";
		when x"5a2" => sin_out <= x"433b";
		when x"5a3" => sin_out <= x"4345";
		when x"5a4" => sin_out <= x"4350";
		when x"5a5" => sin_out <= x"435b";
		when x"5a6" => sin_out <= x"4365";
		when x"5a7" => sin_out <= x"4370";
		when x"5a8" => sin_out <= x"437b";
		when x"5a9" => sin_out <= x"4385";
		when x"5aa" => sin_out <= x"4390";
		when x"5ab" => sin_out <= x"439b";
		when x"5ac" => sin_out <= x"43a5";
		when x"5ad" => sin_out <= x"43b0";
		when x"5ae" => sin_out <= x"43bb";
		when x"5af" => sin_out <= x"43c5";
		when x"5b0" => sin_out <= x"43d0";
		when x"5b1" => sin_out <= x"43db";
		when x"5b2" => sin_out <= x"43e5";
		when x"5b3" => sin_out <= x"43f0";
		when x"5b4" => sin_out <= x"43fb";
		when x"5b5" => sin_out <= x"4405";
		when x"5b6" => sin_out <= x"4410";
		when x"5b7" => sin_out <= x"441b";
		when x"5b8" => sin_out <= x"4425";
		when x"5b9" => sin_out <= x"4430";
		when x"5ba" => sin_out <= x"443b";
		when x"5bb" => sin_out <= x"4445";
		when x"5bc" => sin_out <= x"4450";
		when x"5bd" => sin_out <= x"445a";
		when x"5be" => sin_out <= x"4465";
		when x"5bf" => sin_out <= x"4470";
		when x"5c0" => sin_out <= x"447a";
		when x"5c1" => sin_out <= x"4485";
		when x"5c2" => sin_out <= x"448f";
		when x"5c3" => sin_out <= x"449a";
		when x"5c4" => sin_out <= x"44a5";
		when x"5c5" => sin_out <= x"44af";
		when x"5c6" => sin_out <= x"44ba";
		when x"5c7" => sin_out <= x"44c5";
		when x"5c8" => sin_out <= x"44cf";
		when x"5c9" => sin_out <= x"44da";
		when x"5ca" => sin_out <= x"44e4";
		when x"5cb" => sin_out <= x"44ef";
		when x"5cc" => sin_out <= x"44f9";
		when x"5cd" => sin_out <= x"4504";
		when x"5ce" => sin_out <= x"450f";
		when x"5cf" => sin_out <= x"4519";
		when x"5d0" => sin_out <= x"4524";
		when x"5d1" => sin_out <= x"452e";
		when x"5d2" => sin_out <= x"4539";
		when x"5d3" => sin_out <= x"4544";
		when x"5d4" => sin_out <= x"454e";
		when x"5d5" => sin_out <= x"4559";
		when x"5d6" => sin_out <= x"4563";
		when x"5d7" => sin_out <= x"456e";
		when x"5d8" => sin_out <= x"4578";
		when x"5d9" => sin_out <= x"4583";
		when x"5da" => sin_out <= x"458d";
		when x"5db" => sin_out <= x"4598";
		when x"5dc" => sin_out <= x"45a3";
		when x"5dd" => sin_out <= x"45ad";
		when x"5de" => sin_out <= x"45b8";
		when x"5df" => sin_out <= x"45c2";
		when x"5e0" => sin_out <= x"45cd";
		when x"5e1" => sin_out <= x"45d7";
		when x"5e2" => sin_out <= x"45e2";
		when x"5e3" => sin_out <= x"45ec";
		when x"5e4" => sin_out <= x"45f7";
		when x"5e5" => sin_out <= x"4601";
		when x"5e6" => sin_out <= x"460c";
		when x"5e7" => sin_out <= x"4616";
		when x"5e8" => sin_out <= x"4621";
		when x"5e9" => sin_out <= x"462b";
		when x"5ea" => sin_out <= x"4636";
		when x"5eb" => sin_out <= x"4640";
		when x"5ec" => sin_out <= x"464b";
		when x"5ed" => sin_out <= x"4655";
		when x"5ee" => sin_out <= x"4660";
		when x"5ef" => sin_out <= x"466a";
		when x"5f0" => sin_out <= x"4675";
		when x"5f1" => sin_out <= x"467f";
		when x"5f2" => sin_out <= x"468a";
		when x"5f3" => sin_out <= x"4694";
		when x"5f4" => sin_out <= x"469f";
		when x"5f5" => sin_out <= x"46a9";
		when x"5f6" => sin_out <= x"46b4";
		when x"5f7" => sin_out <= x"46be";
		when x"5f8" => sin_out <= x"46c9";
		when x"5f9" => sin_out <= x"46d3";
		when x"5fa" => sin_out <= x"46de";
		when x"5fb" => sin_out <= x"46e8";
		when x"5fc" => sin_out <= x"46f3";
		when x"5fd" => sin_out <= x"46fd";
		when x"5fe" => sin_out <= x"4707";
		when x"5ff" => sin_out <= x"4712";
		when x"600" => sin_out <= x"471c";
		when x"601" => sin_out <= x"4727";
		when x"602" => sin_out <= x"4731";
		when x"603" => sin_out <= x"473c";
		when x"604" => sin_out <= x"4746";
		when x"605" => sin_out <= x"4751";
		when x"606" => sin_out <= x"475b";
		when x"607" => sin_out <= x"4765";
		when x"608" => sin_out <= x"4770";
		when x"609" => sin_out <= x"477a";
		when x"60a" => sin_out <= x"4785";
		when x"60b" => sin_out <= x"478f";
		when x"60c" => sin_out <= x"479a";
		when x"60d" => sin_out <= x"47a4";
		when x"60e" => sin_out <= x"47ae";
		when x"60f" => sin_out <= x"47b9";
		when x"610" => sin_out <= x"47c3";
		when x"611" => sin_out <= x"47ce";
		when x"612" => sin_out <= x"47d8";
		when x"613" => sin_out <= x"47e2";
		when x"614" => sin_out <= x"47ed";
		when x"615" => sin_out <= x"47f7";
		when x"616" => sin_out <= x"4802";
		when x"617" => sin_out <= x"480c";
		when x"618" => sin_out <= x"4816";
		when x"619" => sin_out <= x"4821";
		when x"61a" => sin_out <= x"482b";
		when x"61b" => sin_out <= x"4835";
		when x"61c" => sin_out <= x"4840";
		when x"61d" => sin_out <= x"484a";
		when x"61e" => sin_out <= x"4855";
		when x"61f" => sin_out <= x"485f";
		when x"620" => sin_out <= x"4869";
		when x"621" => sin_out <= x"4874";
		when x"622" => sin_out <= x"487e";
		when x"623" => sin_out <= x"4888";
		when x"624" => sin_out <= x"4893";
		when x"625" => sin_out <= x"489d";
		when x"626" => sin_out <= x"48a7";
		when x"627" => sin_out <= x"48b2";
		when x"628" => sin_out <= x"48bc";
		when x"629" => sin_out <= x"48c6";
		when x"62a" => sin_out <= x"48d1";
		when x"62b" => sin_out <= x"48db";
		when x"62c" => sin_out <= x"48e5";
		when x"62d" => sin_out <= x"48f0";
		when x"62e" => sin_out <= x"48fa";
		when x"62f" => sin_out <= x"4904";
		when x"630" => sin_out <= x"490f";
		when x"631" => sin_out <= x"4919";
		when x"632" => sin_out <= x"4923";
		when x"633" => sin_out <= x"492e";
		when x"634" => sin_out <= x"4938";
		when x"635" => sin_out <= x"4942";
		when x"636" => sin_out <= x"494d";
		when x"637" => sin_out <= x"4957";
		when x"638" => sin_out <= x"4961";
		when x"639" => sin_out <= x"496c";
		when x"63a" => sin_out <= x"4976";
		when x"63b" => sin_out <= x"4980";
		when x"63c" => sin_out <= x"498a";
		when x"63d" => sin_out <= x"4995";
		when x"63e" => sin_out <= x"499f";
		when x"63f" => sin_out <= x"49a9";
		when x"640" => sin_out <= x"49b4";
		when x"641" => sin_out <= x"49be";
		when x"642" => sin_out <= x"49c8";
		when x"643" => sin_out <= x"49d2";
		when x"644" => sin_out <= x"49dd";
		when x"645" => sin_out <= x"49e7";
		when x"646" => sin_out <= x"49f1";
		when x"647" => sin_out <= x"49fb";
		when x"648" => sin_out <= x"4a06";
		when x"649" => sin_out <= x"4a10";
		when x"64a" => sin_out <= x"4a1a";
		when x"64b" => sin_out <= x"4a24";
		when x"64c" => sin_out <= x"4a2f";
		when x"64d" => sin_out <= x"4a39";
		when x"64e" => sin_out <= x"4a43";
		when x"64f" => sin_out <= x"4a4d";
		when x"650" => sin_out <= x"4a58";
		when x"651" => sin_out <= x"4a62";
		when x"652" => sin_out <= x"4a6c";
		when x"653" => sin_out <= x"4a76";
		when x"654" => sin_out <= x"4a80";
		when x"655" => sin_out <= x"4a8b";
		when x"656" => sin_out <= x"4a95";
		when x"657" => sin_out <= x"4a9f";
		when x"658" => sin_out <= x"4aa9";
		when x"659" => sin_out <= x"4ab3";
		when x"65a" => sin_out <= x"4abe";
		when x"65b" => sin_out <= x"4ac8";
		when x"65c" => sin_out <= x"4ad2";
		when x"65d" => sin_out <= x"4adc";
		when x"65e" => sin_out <= x"4ae6";
		when x"65f" => sin_out <= x"4af1";
		when x"660" => sin_out <= x"4afb";
		when x"661" => sin_out <= x"4b05";
		when x"662" => sin_out <= x"4b0f";
		when x"663" => sin_out <= x"4b19";
		when x"664" => sin_out <= x"4b24";
		when x"665" => sin_out <= x"4b2e";
		when x"666" => sin_out <= x"4b38";
		when x"667" => sin_out <= x"4b42";
		when x"668" => sin_out <= x"4b4c";
		when x"669" => sin_out <= x"4b56";
		when x"66a" => sin_out <= x"4b61";
		when x"66b" => sin_out <= x"4b6b";
		when x"66c" => sin_out <= x"4b75";
		when x"66d" => sin_out <= x"4b7f";
		when x"66e" => sin_out <= x"4b89";
		when x"66f" => sin_out <= x"4b93";
		when x"670" => sin_out <= x"4b9d";
		when x"671" => sin_out <= x"4ba8";
		when x"672" => sin_out <= x"4bb2";
		when x"673" => sin_out <= x"4bbc";
		when x"674" => sin_out <= x"4bc6";
		when x"675" => sin_out <= x"4bd0";
		when x"676" => sin_out <= x"4bda";
		when x"677" => sin_out <= x"4be4";
		when x"678" => sin_out <= x"4bee";
		when x"679" => sin_out <= x"4bf9";
		when x"67a" => sin_out <= x"4c03";
		when x"67b" => sin_out <= x"4c0d";
		when x"67c" => sin_out <= x"4c17";
		when x"67d" => sin_out <= x"4c21";
		when x"67e" => sin_out <= x"4c2b";
		when x"67f" => sin_out <= x"4c35";
		when x"680" => sin_out <= x"4c3f";
		when x"681" => sin_out <= x"4c49";
		when x"682" => sin_out <= x"4c53";
		when x"683" => sin_out <= x"4c5e";
		when x"684" => sin_out <= x"4c68";
		when x"685" => sin_out <= x"4c72";
		when x"686" => sin_out <= x"4c7c";
		when x"687" => sin_out <= x"4c86";
		when x"688" => sin_out <= x"4c90";
		when x"689" => sin_out <= x"4c9a";
		when x"68a" => sin_out <= x"4ca4";
		when x"68b" => sin_out <= x"4cae";
		when x"68c" => sin_out <= x"4cb8";
		when x"68d" => sin_out <= x"4cc2";
		when x"68e" => sin_out <= x"4ccc";
		when x"68f" => sin_out <= x"4cd6";
		when x"690" => sin_out <= x"4ce0";
		when x"691" => sin_out <= x"4cea";
		when x"692" => sin_out <= x"4cf4";
		when x"693" => sin_out <= x"4cff";
		when x"694" => sin_out <= x"4d09";
		when x"695" => sin_out <= x"4d13";
		when x"696" => sin_out <= x"4d1d";
		when x"697" => sin_out <= x"4d27";
		when x"698" => sin_out <= x"4d31";
		when x"699" => sin_out <= x"4d3b";
		when x"69a" => sin_out <= x"4d45";
		when x"69b" => sin_out <= x"4d4f";
		when x"69c" => sin_out <= x"4d59";
		when x"69d" => sin_out <= x"4d63";
		when x"69e" => sin_out <= x"4d6d";
		when x"69f" => sin_out <= x"4d77";
		when x"6a0" => sin_out <= x"4d81";
		when x"6a1" => sin_out <= x"4d8b";
		when x"6a2" => sin_out <= x"4d95";
		when x"6a3" => sin_out <= x"4d9f";
		when x"6a4" => sin_out <= x"4da9";
		when x"6a5" => sin_out <= x"4db3";
		when x"6a6" => sin_out <= x"4dbd";
		when x"6a7" => sin_out <= x"4dc7";
		when x"6a8" => sin_out <= x"4dd1";
		when x"6a9" => sin_out <= x"4ddb";
		when x"6aa" => sin_out <= x"4de5";
		when x"6ab" => sin_out <= x"4def";
		when x"6ac" => sin_out <= x"4df9";
		when x"6ad" => sin_out <= x"4e03";
		when x"6ae" => sin_out <= x"4e0d";
		when x"6af" => sin_out <= x"4e16";
		when x"6b0" => sin_out <= x"4e20";
		when x"6b1" => sin_out <= x"4e2a";
		when x"6b2" => sin_out <= x"4e34";
		when x"6b3" => sin_out <= x"4e3e";
		when x"6b4" => sin_out <= x"4e48";
		when x"6b5" => sin_out <= x"4e52";
		when x"6b6" => sin_out <= x"4e5c";
		when x"6b7" => sin_out <= x"4e66";
		when x"6b8" => sin_out <= x"4e70";
		when x"6b9" => sin_out <= x"4e7a";
		when x"6ba" => sin_out <= x"4e84";
		when x"6bb" => sin_out <= x"4e8e";
		when x"6bc" => sin_out <= x"4e98";
		when x"6bd" => sin_out <= x"4ea2";
		when x"6be" => sin_out <= x"4eab";
		when x"6bf" => sin_out <= x"4eb5";
		when x"6c0" => sin_out <= x"4ebf";
		when x"6c1" => sin_out <= x"4ec9";
		when x"6c2" => sin_out <= x"4ed3";
		when x"6c3" => sin_out <= x"4edd";
		when x"6c4" => sin_out <= x"4ee7";
		when x"6c5" => sin_out <= x"4ef1";
		when x"6c6" => sin_out <= x"4efb";
		when x"6c7" => sin_out <= x"4f05";
		when x"6c8" => sin_out <= x"4f0e";
		when x"6c9" => sin_out <= x"4f18";
		when x"6ca" => sin_out <= x"4f22";
		when x"6cb" => sin_out <= x"4f2c";
		when x"6cc" => sin_out <= x"4f36";
		when x"6cd" => sin_out <= x"4f40";
		when x"6ce" => sin_out <= x"4f4a";
		when x"6cf" => sin_out <= x"4f54";
		when x"6d0" => sin_out <= x"4f5d";
		when x"6d1" => sin_out <= x"4f67";
		when x"6d2" => sin_out <= x"4f71";
		when x"6d3" => sin_out <= x"4f7b";
		when x"6d4" => sin_out <= x"4f85";
		when x"6d5" => sin_out <= x"4f8f";
		when x"6d6" => sin_out <= x"4f99";
		when x"6d7" => sin_out <= x"4fa2";
		when x"6d8" => sin_out <= x"4fac";
		when x"6d9" => sin_out <= x"4fb6";
		when x"6da" => sin_out <= x"4fc0";
		when x"6db" => sin_out <= x"4fca";
		when x"6dc" => sin_out <= x"4fd4";
		when x"6dd" => sin_out <= x"4fdd";
		when x"6de" => sin_out <= x"4fe7";
		when x"6df" => sin_out <= x"4ff1";
		when x"6e0" => sin_out <= x"4ffb";
		when x"6e1" => sin_out <= x"5005";
		when x"6e2" => sin_out <= x"500e";
		when x"6e3" => sin_out <= x"5018";
		when x"6e4" => sin_out <= x"5022";
		when x"6e5" => sin_out <= x"502c";
		when x"6e6" => sin_out <= x"5036";
		when x"6e7" => sin_out <= x"503f";
		when x"6e8" => sin_out <= x"5049";
		when x"6e9" => sin_out <= x"5053";
		when x"6ea" => sin_out <= x"505d";
		when x"6eb" => sin_out <= x"5067";
		when x"6ec" => sin_out <= x"5070";
		when x"6ed" => sin_out <= x"507a";
		when x"6ee" => sin_out <= x"5084";
		when x"6ef" => sin_out <= x"508e";
		when x"6f0" => sin_out <= x"5097";
		when x"6f1" => sin_out <= x"50a1";
		when x"6f2" => sin_out <= x"50ab";
		when x"6f3" => sin_out <= x"50b5";
		when x"6f4" => sin_out <= x"50be";
		when x"6f5" => sin_out <= x"50c8";
		when x"6f6" => sin_out <= x"50d2";
		when x"6f7" => sin_out <= x"50dc";
		when x"6f8" => sin_out <= x"50e5";
		when x"6f9" => sin_out <= x"50ef";
		when x"6fa" => sin_out <= x"50f9";
		when x"6fb" => sin_out <= x"5103";
		when x"6fc" => sin_out <= x"510c";
		when x"6fd" => sin_out <= x"5116";
		when x"6fe" => sin_out <= x"5120";
		when x"6ff" => sin_out <= x"5129";
		when x"700" => sin_out <= x"5133";
		when x"701" => sin_out <= x"513d";
		when x"702" => sin_out <= x"5147";
		when x"703" => sin_out <= x"5150";
		when x"704" => sin_out <= x"515a";
		when x"705" => sin_out <= x"5164";
		when x"706" => sin_out <= x"516d";
		when x"707" => sin_out <= x"5177";
		when x"708" => sin_out <= x"5181";
		when x"709" => sin_out <= x"518a";
		when x"70a" => sin_out <= x"5194";
		when x"70b" => sin_out <= x"519e";
		when x"70c" => sin_out <= x"51a8";
		when x"70d" => sin_out <= x"51b1";
		when x"70e" => sin_out <= x"51bb";
		when x"70f" => sin_out <= x"51c5";
		when x"710" => sin_out <= x"51ce";
		when x"711" => sin_out <= x"51d8";
		when x"712" => sin_out <= x"51e2";
		when x"713" => sin_out <= x"51eb";
		when x"714" => sin_out <= x"51f5";
		when x"715" => sin_out <= x"51fe";
		when x"716" => sin_out <= x"5208";
		when x"717" => sin_out <= x"5212";
		when x"718" => sin_out <= x"521b";
		when x"719" => sin_out <= x"5225";
		when x"71a" => sin_out <= x"522f";
		when x"71b" => sin_out <= x"5238";
		when x"71c" => sin_out <= x"5242";
		when x"71d" => sin_out <= x"524c";
		when x"71e" => sin_out <= x"5255";
		when x"71f" => sin_out <= x"525f";
		when x"720" => sin_out <= x"5268";
		when x"721" => sin_out <= x"5272";
		when x"722" => sin_out <= x"527c";
		when x"723" => sin_out <= x"5285";
		when x"724" => sin_out <= x"528f";
		when x"725" => sin_out <= x"5298";
		when x"726" => sin_out <= x"52a2";
		when x"727" => sin_out <= x"52ac";
		when x"728" => sin_out <= x"52b5";
		when x"729" => sin_out <= x"52bf";
		when x"72a" => sin_out <= x"52c8";
		when x"72b" => sin_out <= x"52d2";
		when x"72c" => sin_out <= x"52dc";
		when x"72d" => sin_out <= x"52e5";
		when x"72e" => sin_out <= x"52ef";
		when x"72f" => sin_out <= x"52f8";
		when x"730" => sin_out <= x"5302";
		when x"731" => sin_out <= x"530b";
		when x"732" => sin_out <= x"5315";
		when x"733" => sin_out <= x"531f";
		when x"734" => sin_out <= x"5328";
		when x"735" => sin_out <= x"5332";
		when x"736" => sin_out <= x"533b";
		when x"737" => sin_out <= x"5345";
		when x"738" => sin_out <= x"534e";
		when x"739" => sin_out <= x"5358";
		when x"73a" => sin_out <= x"5361";
		when x"73b" => sin_out <= x"536b";
		when x"73c" => sin_out <= x"5374";
		when x"73d" => sin_out <= x"537e";
		when x"73e" => sin_out <= x"5387";
		when x"73f" => sin_out <= x"5391";
		when x"740" => sin_out <= x"539b";
		when x"741" => sin_out <= x"53a4";
		when x"742" => sin_out <= x"53ae";
		when x"743" => sin_out <= x"53b7";
		when x"744" => sin_out <= x"53c1";
		when x"745" => sin_out <= x"53ca";
		when x"746" => sin_out <= x"53d4";
		when x"747" => sin_out <= x"53dd";
		when x"748" => sin_out <= x"53e7";
		when x"749" => sin_out <= x"53f0";
		when x"74a" => sin_out <= x"53fa";
		when x"74b" => sin_out <= x"5403";
		when x"74c" => sin_out <= x"540c";
		when x"74d" => sin_out <= x"5416";
		when x"74e" => sin_out <= x"541f";
		when x"74f" => sin_out <= x"5429";
		when x"750" => sin_out <= x"5432";
		when x"751" => sin_out <= x"543c";
		when x"752" => sin_out <= x"5445";
		when x"753" => sin_out <= x"544f";
		when x"754" => sin_out <= x"5458";
		when x"755" => sin_out <= x"5462";
		when x"756" => sin_out <= x"546b";
		when x"757" => sin_out <= x"5475";
		when x"758" => sin_out <= x"547e";
		when x"759" => sin_out <= x"5487";
		when x"75a" => sin_out <= x"5491";
		when x"75b" => sin_out <= x"549a";
		when x"75c" => sin_out <= x"54a4";
		when x"75d" => sin_out <= x"54ad";
		when x"75e" => sin_out <= x"54b7";
		when x"75f" => sin_out <= x"54c0";
		when x"760" => sin_out <= x"54c9";
		when x"761" => sin_out <= x"54d3";
		when x"762" => sin_out <= x"54dc";
		when x"763" => sin_out <= x"54e6";
		when x"764" => sin_out <= x"54ef";
		when x"765" => sin_out <= x"54f8";
		when x"766" => sin_out <= x"5502";
		when x"767" => sin_out <= x"550b";
		when x"768" => sin_out <= x"5515";
		when x"769" => sin_out <= x"551e";
		when x"76a" => sin_out <= x"5527";
		when x"76b" => sin_out <= x"5531";
		when x"76c" => sin_out <= x"553a";
		when x"76d" => sin_out <= x"5543";
		when x"76e" => sin_out <= x"554d";
		when x"76f" => sin_out <= x"5556";
		when x"770" => sin_out <= x"5560";
		when x"771" => sin_out <= x"5569";
		when x"772" => sin_out <= x"5572";
		when x"773" => sin_out <= x"557c";
		when x"774" => sin_out <= x"5585";
		when x"775" => sin_out <= x"558e";
		when x"776" => sin_out <= x"5598";
		when x"777" => sin_out <= x"55a1";
		when x"778" => sin_out <= x"55aa";
		when x"779" => sin_out <= x"55b4";
		when x"77a" => sin_out <= x"55bd";
		when x"77b" => sin_out <= x"55c6";
		when x"77c" => sin_out <= x"55d0";
		when x"77d" => sin_out <= x"55d9";
		when x"77e" => sin_out <= x"55e2";
		when x"77f" => sin_out <= x"55ec";
		when x"780" => sin_out <= x"55f5";
		when x"781" => sin_out <= x"55fe";
		when x"782" => sin_out <= x"5608";
		when x"783" => sin_out <= x"5611";
		when x"784" => sin_out <= x"561a";
		when x"785" => sin_out <= x"5623";
		when x"786" => sin_out <= x"562d";
		when x"787" => sin_out <= x"5636";
		when x"788" => sin_out <= x"563f";
		when x"789" => sin_out <= x"5649";
		when x"78a" => sin_out <= x"5652";
		when x"78b" => sin_out <= x"565b";
		when x"78c" => sin_out <= x"5664";
		when x"78d" => sin_out <= x"566e";
		when x"78e" => sin_out <= x"5677";
		when x"78f" => sin_out <= x"5680";
		when x"790" => sin_out <= x"568a";
		when x"791" => sin_out <= x"5693";
		when x"792" => sin_out <= x"569c";
		when x"793" => sin_out <= x"56a5";
		when x"794" => sin_out <= x"56af";
		when x"795" => sin_out <= x"56b8";
		when x"796" => sin_out <= x"56c1";
		when x"797" => sin_out <= x"56ca";
		when x"798" => sin_out <= x"56d3";
		when x"799" => sin_out <= x"56dd";
		when x"79a" => sin_out <= x"56e6";
		when x"79b" => sin_out <= x"56ef";
		when x"79c" => sin_out <= x"56f8";
		when x"79d" => sin_out <= x"5702";
		when x"79e" => sin_out <= x"570b";
		when x"79f" => sin_out <= x"5714";
		when x"7a0" => sin_out <= x"571d";
		when x"7a1" => sin_out <= x"5726";
		when x"7a2" => sin_out <= x"5730";
		when x"7a3" => sin_out <= x"5739";
		when x"7a4" => sin_out <= x"5742";
		when x"7a5" => sin_out <= x"574b";
		when x"7a6" => sin_out <= x"5754";
		when x"7a7" => sin_out <= x"575e";
		when x"7a8" => sin_out <= x"5767";
		when x"7a9" => sin_out <= x"5770";
		when x"7aa" => sin_out <= x"5779";
		when x"7ab" => sin_out <= x"5782";
		when x"7ac" => sin_out <= x"578b";
		when x"7ad" => sin_out <= x"5795";
		when x"7ae" => sin_out <= x"579e";
		when x"7af" => sin_out <= x"57a7";
		when x"7b0" => sin_out <= x"57b0";
		when x"7b1" => sin_out <= x"57b9";
		when x"7b2" => sin_out <= x"57c2";
		when x"7b3" => sin_out <= x"57cc";
		when x"7b4" => sin_out <= x"57d5";
		when x"7b5" => sin_out <= x"57de";
		when x"7b6" => sin_out <= x"57e7";
		when x"7b7" => sin_out <= x"57f0";
		when x"7b8" => sin_out <= x"57f9";
		when x"7b9" => sin_out <= x"5802";
		when x"7ba" => sin_out <= x"580c";
		when x"7bb" => sin_out <= x"5815";
		when x"7bc" => sin_out <= x"581e";
		when x"7bd" => sin_out <= x"5827";
		when x"7be" => sin_out <= x"5830";
		when x"7bf" => sin_out <= x"5839";
		when x"7c0" => sin_out <= x"5842";
		when x"7c1" => sin_out <= x"584b";
		when x"7c2" => sin_out <= x"5854";
		when x"7c3" => sin_out <= x"585d";
		when x"7c4" => sin_out <= x"5867";
		when x"7c5" => sin_out <= x"5870";
		when x"7c6" => sin_out <= x"5879";
		when x"7c7" => sin_out <= x"5882";
		when x"7c8" => sin_out <= x"588b";
		when x"7c9" => sin_out <= x"5894";
		when x"7ca" => sin_out <= x"589d";
		when x"7cb" => sin_out <= x"58a6";
		when x"7cc" => sin_out <= x"58af";
		when x"7cd" => sin_out <= x"58b8";
		when x"7ce" => sin_out <= x"58c1";
		when x"7cf" => sin_out <= x"58ca";
		when x"7d0" => sin_out <= x"58d3";
		when x"7d1" => sin_out <= x"58dc";
		when x"7d2" => sin_out <= x"58e5";
		when x"7d3" => sin_out <= x"58ee";
		when x"7d4" => sin_out <= x"58f8";
		when x"7d5" => sin_out <= x"5901";
		when x"7d6" => sin_out <= x"590a";
		when x"7d7" => sin_out <= x"5913";
		when x"7d8" => sin_out <= x"591c";
		when x"7d9" => sin_out <= x"5925";
		when x"7da" => sin_out <= x"592e";
		when x"7db" => sin_out <= x"5937";
		when x"7dc" => sin_out <= x"5940";
		when x"7dd" => sin_out <= x"5949";
		when x"7de" => sin_out <= x"5952";
		when x"7df" => sin_out <= x"595b";
		when x"7e0" => sin_out <= x"5964";
		when x"7e1" => sin_out <= x"596d";
		when x"7e2" => sin_out <= x"5976";
		when x"7e3" => sin_out <= x"597f";
		when x"7e4" => sin_out <= x"5988";
		when x"7e5" => sin_out <= x"5991";
		when x"7e6" => sin_out <= x"599a";
		when x"7e7" => sin_out <= x"59a3";
		when x"7e8" => sin_out <= x"59ac";
		when x"7e9" => sin_out <= x"59b5";
		when x"7ea" => sin_out <= x"59bd";
		when x"7eb" => sin_out <= x"59c6";
		when x"7ec" => sin_out <= x"59cf";
		when x"7ed" => sin_out <= x"59d8";
		when x"7ee" => sin_out <= x"59e1";
		when x"7ef" => sin_out <= x"59ea";
		when x"7f0" => sin_out <= x"59f3";
		when x"7f1" => sin_out <= x"59fc";
		when x"7f2" => sin_out <= x"5a05";
		when x"7f3" => sin_out <= x"5a0e";
		when x"7f4" => sin_out <= x"5a17";
		when x"7f5" => sin_out <= x"5a20";
		when x"7f6" => sin_out <= x"5a29";
		when x"7f7" => sin_out <= x"5a32";
		when x"7f8" => sin_out <= x"5a3b";
		when x"7f9" => sin_out <= x"5a43";
		when x"7fa" => sin_out <= x"5a4c";
		when x"7fb" => sin_out <= x"5a55";
		when x"7fc" => sin_out <= x"5a5e";
		when x"7fd" => sin_out <= x"5a67";
		when x"7fe" => sin_out <= x"5a70";
		when x"7ff" => sin_out <= x"5a79";
		when x"800" => sin_out <= x"5a82";
		when x"801" => sin_out <= x"5a8b";
		when x"802" => sin_out <= x"5a94";
		when x"803" => sin_out <= x"5a9c";
		when x"804" => sin_out <= x"5aa5";
		when x"805" => sin_out <= x"5aae";
		when x"806" => sin_out <= x"5ab7";
		when x"807" => sin_out <= x"5ac0";
		when x"808" => sin_out <= x"5ac9";
		when x"809" => sin_out <= x"5ad2";
		when x"80a" => sin_out <= x"5ada";
		when x"80b" => sin_out <= x"5ae3";
		when x"80c" => sin_out <= x"5aec";
		when x"80d" => sin_out <= x"5af5";
		when x"80e" => sin_out <= x"5afe";
		when x"80f" => sin_out <= x"5b07";
		when x"810" => sin_out <= x"5b0f";
		when x"811" => sin_out <= x"5b18";
		when x"812" => sin_out <= x"5b21";
		when x"813" => sin_out <= x"5b2a";
		when x"814" => sin_out <= x"5b33";
		when x"815" => sin_out <= x"5b3c";
		when x"816" => sin_out <= x"5b44";
		when x"817" => sin_out <= x"5b4d";
		when x"818" => sin_out <= x"5b56";
		when x"819" => sin_out <= x"5b5f";
		when x"81a" => sin_out <= x"5b68";
		when x"81b" => sin_out <= x"5b70";
		when x"81c" => sin_out <= x"5b79";
		when x"81d" => sin_out <= x"5b82";
		when x"81e" => sin_out <= x"5b8b";
		when x"81f" => sin_out <= x"5b94";
		when x"820" => sin_out <= x"5b9c";
		when x"821" => sin_out <= x"5ba5";
		when x"822" => sin_out <= x"5bae";
		when x"823" => sin_out <= x"5bb7";
		when x"824" => sin_out <= x"5bbf";
		when x"825" => sin_out <= x"5bc8";
		when x"826" => sin_out <= x"5bd1";
		when x"827" => sin_out <= x"5bda";
		when x"828" => sin_out <= x"5be2";
		when x"829" => sin_out <= x"5beb";
		when x"82a" => sin_out <= x"5bf4";
		when x"82b" => sin_out <= x"5bfd";
		when x"82c" => sin_out <= x"5c05";
		when x"82d" => sin_out <= x"5c0e";
		when x"82e" => sin_out <= x"5c17";
		when x"82f" => sin_out <= x"5c20";
		when x"830" => sin_out <= x"5c28";
		when x"831" => sin_out <= x"5c31";
		when x"832" => sin_out <= x"5c3a";
		when x"833" => sin_out <= x"5c42";
		when x"834" => sin_out <= x"5c4b";
		when x"835" => sin_out <= x"5c54";
		when x"836" => sin_out <= x"5c5d";
		when x"837" => sin_out <= x"5c65";
		when x"838" => sin_out <= x"5c6e";
		when x"839" => sin_out <= x"5c77";
		when x"83a" => sin_out <= x"5c7f";
		when x"83b" => sin_out <= x"5c88";
		when x"83c" => sin_out <= x"5c91";
		when x"83d" => sin_out <= x"5c99";
		when x"83e" => sin_out <= x"5ca2";
		when x"83f" => sin_out <= x"5cab";
		when x"840" => sin_out <= x"5cb3";
		when x"841" => sin_out <= x"5cbc";
		when x"842" => sin_out <= x"5cc5";
		when x"843" => sin_out <= x"5ccd";
		when x"844" => sin_out <= x"5cd6";
		when x"845" => sin_out <= x"5cdf";
		when x"846" => sin_out <= x"5ce7";
		when x"847" => sin_out <= x"5cf0";
		when x"848" => sin_out <= x"5cf9";
		when x"849" => sin_out <= x"5d01";
		when x"84a" => sin_out <= x"5d0a";
		when x"84b" => sin_out <= x"5d13";
		when x"84c" => sin_out <= x"5d1b";
		when x"84d" => sin_out <= x"5d24";
		when x"84e" => sin_out <= x"5d2c";
		when x"84f" => sin_out <= x"5d35";
		when x"850" => sin_out <= x"5d3e";
		when x"851" => sin_out <= x"5d46";
		when x"852" => sin_out <= x"5d4f";
		when x"853" => sin_out <= x"5d57";
		when x"854" => sin_out <= x"5d60";
		when x"855" => sin_out <= x"5d69";
		when x"856" => sin_out <= x"5d71";
		when x"857" => sin_out <= x"5d7a";
		when x"858" => sin_out <= x"5d82";
		when x"859" => sin_out <= x"5d8b";
		when x"85a" => sin_out <= x"5d94";
		when x"85b" => sin_out <= x"5d9c";
		when x"85c" => sin_out <= x"5da5";
		when x"85d" => sin_out <= x"5dad";
		when x"85e" => sin_out <= x"5db6";
		when x"85f" => sin_out <= x"5dbe";
		when x"860" => sin_out <= x"5dc7";
		when x"861" => sin_out <= x"5dcf";
		when x"862" => sin_out <= x"5dd8";
		when x"863" => sin_out <= x"5de1";
		when x"864" => sin_out <= x"5de9";
		when x"865" => sin_out <= x"5df2";
		when x"866" => sin_out <= x"5dfa";
		when x"867" => sin_out <= x"5e03";
		when x"868" => sin_out <= x"5e0b";
		when x"869" => sin_out <= x"5e14";
		when x"86a" => sin_out <= x"5e1c";
		when x"86b" => sin_out <= x"5e25";
		when x"86c" => sin_out <= x"5e2d";
		when x"86d" => sin_out <= x"5e36";
		when x"86e" => sin_out <= x"5e3e";
		when x"86f" => sin_out <= x"5e47";
		when x"870" => sin_out <= x"5e4f";
		when x"871" => sin_out <= x"5e58";
		when x"872" => sin_out <= x"5e60";
		when x"873" => sin_out <= x"5e69";
		when x"874" => sin_out <= x"5e71";
		when x"875" => sin_out <= x"5e7a";
		when x"876" => sin_out <= x"5e82";
		when x"877" => sin_out <= x"5e8b";
		when x"878" => sin_out <= x"5e93";
		when x"879" => sin_out <= x"5e9c";
		when x"87a" => sin_out <= x"5ea4";
		when x"87b" => sin_out <= x"5ead";
		when x"87c" => sin_out <= x"5eb5";
		when x"87d" => sin_out <= x"5ebd";
		when x"87e" => sin_out <= x"5ec6";
		when x"87f" => sin_out <= x"5ece";
		when x"880" => sin_out <= x"5ed7";
		when x"881" => sin_out <= x"5edf";
		when x"882" => sin_out <= x"5ee8";
		when x"883" => sin_out <= x"5ef0";
		when x"884" => sin_out <= x"5ef8";
		when x"885" => sin_out <= x"5f01";
		when x"886" => sin_out <= x"5f09";
		when x"887" => sin_out <= x"5f12";
		when x"888" => sin_out <= x"5f1a";
		when x"889" => sin_out <= x"5f23";
		when x"88a" => sin_out <= x"5f2b";
		when x"88b" => sin_out <= x"5f33";
		when x"88c" => sin_out <= x"5f3c";
		when x"88d" => sin_out <= x"5f44";
		when x"88e" => sin_out <= x"5f4d";
		when x"88f" => sin_out <= x"5f55";
		when x"890" => sin_out <= x"5f5d";
		when x"891" => sin_out <= x"5f66";
		when x"892" => sin_out <= x"5f6e";
		when x"893" => sin_out <= x"5f76";
		when x"894" => sin_out <= x"5f7f";
		when x"895" => sin_out <= x"5f87";
		when x"896" => sin_out <= x"5f90";
		when x"897" => sin_out <= x"5f98";
		when x"898" => sin_out <= x"5fa0";
		when x"899" => sin_out <= x"5fa9";
		when x"89a" => sin_out <= x"5fb1";
		when x"89b" => sin_out <= x"5fb9";
		when x"89c" => sin_out <= x"5fc2";
		when x"89d" => sin_out <= x"5fca";
		when x"89e" => sin_out <= x"5fd2";
		when x"89f" => sin_out <= x"5fdb";
		when x"8a0" => sin_out <= x"5fe3";
		when x"8a1" => sin_out <= x"5feb";
		when x"8a2" => sin_out <= x"5ff4";
		when x"8a3" => sin_out <= x"5ffc";
		when x"8a4" => sin_out <= x"6004";
		when x"8a5" => sin_out <= x"600d";
		when x"8a6" => sin_out <= x"6015";
		when x"8a7" => sin_out <= x"601d";
		when x"8a8" => sin_out <= x"6025";
		when x"8a9" => sin_out <= x"602e";
		when x"8aa" => sin_out <= x"6036";
		when x"8ab" => sin_out <= x"603e";
		when x"8ac" => sin_out <= x"6047";
		when x"8ad" => sin_out <= x"604f";
		when x"8ae" => sin_out <= x"6057";
		when x"8af" => sin_out <= x"605f";
		when x"8b0" => sin_out <= x"6068";
		when x"8b1" => sin_out <= x"6070";
		when x"8b2" => sin_out <= x"6078";
		when x"8b3" => sin_out <= x"6080";
		when x"8b4" => sin_out <= x"6089";
		when x"8b5" => sin_out <= x"6091";
		when x"8b6" => sin_out <= x"6099";
		when x"8b7" => sin_out <= x"60a1";
		when x"8b8" => sin_out <= x"60aa";
		when x"8b9" => sin_out <= x"60b2";
		when x"8ba" => sin_out <= x"60ba";
		when x"8bb" => sin_out <= x"60c2";
		when x"8bc" => sin_out <= x"60cb";
		when x"8bd" => sin_out <= x"60d3";
		when x"8be" => sin_out <= x"60db";
		when x"8bf" => sin_out <= x"60e3";
		when x"8c0" => sin_out <= x"60eb";
		when x"8c1" => sin_out <= x"60f4";
		when x"8c2" => sin_out <= x"60fc";
		when x"8c3" => sin_out <= x"6104";
		when x"8c4" => sin_out <= x"610c";
		when x"8c5" => sin_out <= x"6114";
		when x"8c6" => sin_out <= x"611d";
		when x"8c7" => sin_out <= x"6125";
		when x"8c8" => sin_out <= x"612d";
		when x"8c9" => sin_out <= x"6135";
		when x"8ca" => sin_out <= x"613d";
		when x"8cb" => sin_out <= x"6146";
		when x"8cc" => sin_out <= x"614e";
		when x"8cd" => sin_out <= x"6156";
		when x"8ce" => sin_out <= x"615e";
		when x"8cf" => sin_out <= x"6166";
		when x"8d0" => sin_out <= x"616e";
		when x"8d1" => sin_out <= x"6176";
		when x"8d2" => sin_out <= x"617f";
		when x"8d3" => sin_out <= x"6187";
		when x"8d4" => sin_out <= x"618f";
		when x"8d5" => sin_out <= x"6197";
		when x"8d6" => sin_out <= x"619f";
		when x"8d7" => sin_out <= x"61a7";
		when x"8d8" => sin_out <= x"61af";
		when x"8d9" => sin_out <= x"61b8";
		when x"8da" => sin_out <= x"61c0";
		when x"8db" => sin_out <= x"61c8";
		when x"8dc" => sin_out <= x"61d0";
		when x"8dd" => sin_out <= x"61d8";
		when x"8de" => sin_out <= x"61e0";
		when x"8df" => sin_out <= x"61e8";
		when x"8e0" => sin_out <= x"61f0";
		when x"8e1" => sin_out <= x"61f8";
		when x"8e2" => sin_out <= x"6200";
		when x"8e3" => sin_out <= x"6208";
		when x"8e4" => sin_out <= x"6211";
		when x"8e5" => sin_out <= x"6219";
		when x"8e6" => sin_out <= x"6221";
		when x"8e7" => sin_out <= x"6229";
		when x"8e8" => sin_out <= x"6231";
		when x"8e9" => sin_out <= x"6239";
		when x"8ea" => sin_out <= x"6241";
		when x"8eb" => sin_out <= x"6249";
		when x"8ec" => sin_out <= x"6251";
		when x"8ed" => sin_out <= x"6259";
		when x"8ee" => sin_out <= x"6261";
		when x"8ef" => sin_out <= x"6269";
		when x"8f0" => sin_out <= x"6271";
		when x"8f1" => sin_out <= x"6279";
		when x"8f2" => sin_out <= x"6281";
		when x"8f3" => sin_out <= x"6289";
		when x"8f4" => sin_out <= x"6291";
		when x"8f5" => sin_out <= x"6299";
		when x"8f6" => sin_out <= x"62a1";
		when x"8f7" => sin_out <= x"62a9";
		when x"8f8" => sin_out <= x"62b1";
		when x"8f9" => sin_out <= x"62b9";
		when x"8fa" => sin_out <= x"62c1";
		when x"8fb" => sin_out <= x"62c9";
		when x"8fc" => sin_out <= x"62d1";
		when x"8fd" => sin_out <= x"62d9";
		when x"8fe" => sin_out <= x"62e1";
		when x"8ff" => sin_out <= x"62e9";
		when x"900" => sin_out <= x"62f1";
		when x"901" => sin_out <= x"62f9";
		when x"902" => sin_out <= x"6301";
		when x"903" => sin_out <= x"6309";
		when x"904" => sin_out <= x"6311";
		when x"905" => sin_out <= x"6319";
		when x"906" => sin_out <= x"6321";
		when x"907" => sin_out <= x"6329";
		when x"908" => sin_out <= x"6331";
		when x"909" => sin_out <= x"6339";
		when x"90a" => sin_out <= x"6341";
		when x"90b" => sin_out <= x"6349";
		when x"90c" => sin_out <= x"6351";
		when x"90d" => sin_out <= x"6359";
		when x"90e" => sin_out <= x"6360";
		when x"90f" => sin_out <= x"6368";
		when x"910" => sin_out <= x"6370";
		when x"911" => sin_out <= x"6378";
		when x"912" => sin_out <= x"6380";
		when x"913" => sin_out <= x"6388";
		when x"914" => sin_out <= x"6390";
		when x"915" => sin_out <= x"6398";
		when x"916" => sin_out <= x"63a0";
		when x"917" => sin_out <= x"63a8";
		when x"918" => sin_out <= x"63af";
		when x"919" => sin_out <= x"63b7";
		when x"91a" => sin_out <= x"63bf";
		when x"91b" => sin_out <= x"63c7";
		when x"91c" => sin_out <= x"63cf";
		when x"91d" => sin_out <= x"63d7";
		when x"91e" => sin_out <= x"63df";
		when x"91f" => sin_out <= x"63e7";
		when x"920" => sin_out <= x"63ee";
		when x"921" => sin_out <= x"63f6";
		when x"922" => sin_out <= x"63fe";
		when x"923" => sin_out <= x"6406";
		when x"924" => sin_out <= x"640e";
		when x"925" => sin_out <= x"6416";
		when x"926" => sin_out <= x"641d";
		when x"927" => sin_out <= x"6425";
		when x"928" => sin_out <= x"642d";
		when x"929" => sin_out <= x"6435";
		when x"92a" => sin_out <= x"643d";
		when x"92b" => sin_out <= x"6445";
		when x"92c" => sin_out <= x"644c";
		when x"92d" => sin_out <= x"6454";
		when x"92e" => sin_out <= x"645c";
		when x"92f" => sin_out <= x"6464";
		when x"930" => sin_out <= x"646c";
		when x"931" => sin_out <= x"6473";
		when x"932" => sin_out <= x"647b";
		when x"933" => sin_out <= x"6483";
		when x"934" => sin_out <= x"648b";
		when x"935" => sin_out <= x"6492";
		when x"936" => sin_out <= x"649a";
		when x"937" => sin_out <= x"64a2";
		when x"938" => sin_out <= x"64aa";
		when x"939" => sin_out <= x"64b2";
		when x"93a" => sin_out <= x"64b9";
		when x"93b" => sin_out <= x"64c1";
		when x"93c" => sin_out <= x"64c9";
		when x"93d" => sin_out <= x"64d1";
		when x"93e" => sin_out <= x"64d8";
		when x"93f" => sin_out <= x"64e0";
		when x"940" => sin_out <= x"64e8";
		when x"941" => sin_out <= x"64ef";
		when x"942" => sin_out <= x"64f7";
		when x"943" => sin_out <= x"64ff";
		when x"944" => sin_out <= x"6507";
		when x"945" => sin_out <= x"650e";
		when x"946" => sin_out <= x"6516";
		when x"947" => sin_out <= x"651e";
		when x"948" => sin_out <= x"6525";
		when x"949" => sin_out <= x"652d";
		when x"94a" => sin_out <= x"6535";
		when x"94b" => sin_out <= x"653d";
		when x"94c" => sin_out <= x"6544";
		when x"94d" => sin_out <= x"654c";
		when x"94e" => sin_out <= x"6554";
		when x"94f" => sin_out <= x"655b";
		when x"950" => sin_out <= x"6563";
		when x"951" => sin_out <= x"656b";
		when x"952" => sin_out <= x"6572";
		when x"953" => sin_out <= x"657a";
		when x"954" => sin_out <= x"6582";
		when x"955" => sin_out <= x"6589";
		when x"956" => sin_out <= x"6591";
		when x"957" => sin_out <= x"6599";
		when x"958" => sin_out <= x"65a0";
		when x"959" => sin_out <= x"65a8";
		when x"95a" => sin_out <= x"65af";
		when x"95b" => sin_out <= x"65b7";
		when x"95c" => sin_out <= x"65bf";
		when x"95d" => sin_out <= x"65c6";
		when x"95e" => sin_out <= x"65ce";
		when x"95f" => sin_out <= x"65d6";
		when x"960" => sin_out <= x"65dd";
		when x"961" => sin_out <= x"65e5";
		when x"962" => sin_out <= x"65ec";
		when x"963" => sin_out <= x"65f4";
		when x"964" => sin_out <= x"65fc";
		when x"965" => sin_out <= x"6603";
		when x"966" => sin_out <= x"660b";
		when x"967" => sin_out <= x"6612";
		when x"968" => sin_out <= x"661a";
		when x"969" => sin_out <= x"6622";
		when x"96a" => sin_out <= x"6629";
		when x"96b" => sin_out <= x"6631";
		when x"96c" => sin_out <= x"6638";
		when x"96d" => sin_out <= x"6640";
		when x"96e" => sin_out <= x"6647";
		when x"96f" => sin_out <= x"664f";
		when x"970" => sin_out <= x"6656";
		when x"971" => sin_out <= x"665e";
		when x"972" => sin_out <= x"6666";
		when x"973" => sin_out <= x"666d";
		when x"974" => sin_out <= x"6675";
		when x"975" => sin_out <= x"667c";
		when x"976" => sin_out <= x"6684";
		when x"977" => sin_out <= x"668b";
		when x"978" => sin_out <= x"6693";
		when x"979" => sin_out <= x"669a";
		when x"97a" => sin_out <= x"66a2";
		when x"97b" => sin_out <= x"66a9";
		when x"97c" => sin_out <= x"66b1";
		when x"97d" => sin_out <= x"66b8";
		when x"97e" => sin_out <= x"66c0";
		when x"97f" => sin_out <= x"66c7";
		when x"980" => sin_out <= x"66cf";
		when x"981" => sin_out <= x"66d6";
		when x"982" => sin_out <= x"66de";
		when x"983" => sin_out <= x"66e5";
		when x"984" => sin_out <= x"66ed";
		when x"985" => sin_out <= x"66f4";
		when x"986" => sin_out <= x"66fc";
		when x"987" => sin_out <= x"6703";
		when x"988" => sin_out <= x"670a";
		when x"989" => sin_out <= x"6712";
		when x"98a" => sin_out <= x"6719";
		when x"98b" => sin_out <= x"6721";
		when x"98c" => sin_out <= x"6728";
		when x"98d" => sin_out <= x"6730";
		when x"98e" => sin_out <= x"6737";
		when x"98f" => sin_out <= x"673f";
		when x"990" => sin_out <= x"6746";
		when x"991" => sin_out <= x"674d";
		when x"992" => sin_out <= x"6755";
		when x"993" => sin_out <= x"675c";
		when x"994" => sin_out <= x"6764";
		when x"995" => sin_out <= x"676b";
		when x"996" => sin_out <= x"6772";
		when x"997" => sin_out <= x"677a";
		when x"998" => sin_out <= x"6781";
		when x"999" => sin_out <= x"6789";
		when x"99a" => sin_out <= x"6790";
		when x"99b" => sin_out <= x"6797";
		when x"99c" => sin_out <= x"679f";
		when x"99d" => sin_out <= x"67a6";
		when x"99e" => sin_out <= x"67ae";
		when x"99f" => sin_out <= x"67b5";
		when x"9a0" => sin_out <= x"67bc";
		when x"9a1" => sin_out <= x"67c4";
		when x"9a2" => sin_out <= x"67cb";
		when x"9a3" => sin_out <= x"67d2";
		when x"9a4" => sin_out <= x"67da";
		when x"9a5" => sin_out <= x"67e1";
		when x"9a6" => sin_out <= x"67e8";
		when x"9a7" => sin_out <= x"67f0";
		when x"9a8" => sin_out <= x"67f7";
		when x"9a9" => sin_out <= x"67fe";
		when x"9aa" => sin_out <= x"6806";
		when x"9ab" => sin_out <= x"680d";
		when x"9ac" => sin_out <= x"6814";
		when x"9ad" => sin_out <= x"681c";
		when x"9ae" => sin_out <= x"6823";
		when x"9af" => sin_out <= x"682a";
		when x"9b0" => sin_out <= x"6832";
		when x"9b1" => sin_out <= x"6839";
		when x"9b2" => sin_out <= x"6840";
		when x"9b3" => sin_out <= x"6847";
		when x"9b4" => sin_out <= x"684f";
		when x"9b5" => sin_out <= x"6856";
		when x"9b6" => sin_out <= x"685d";
		when x"9b7" => sin_out <= x"6865";
		when x"9b8" => sin_out <= x"686c";
		when x"9b9" => sin_out <= x"6873";
		when x"9ba" => sin_out <= x"687a";
		when x"9bb" => sin_out <= x"6882";
		when x"9bc" => sin_out <= x"6889";
		when x"9bd" => sin_out <= x"6890";
		when x"9be" => sin_out <= x"6897";
		when x"9bf" => sin_out <= x"689f";
		when x"9c0" => sin_out <= x"68a6";
		when x"9c1" => sin_out <= x"68ad";
		when x"9c2" => sin_out <= x"68b4";
		when x"9c3" => sin_out <= x"68bb";
		when x"9c4" => sin_out <= x"68c3";
		when x"9c5" => sin_out <= x"68ca";
		when x"9c6" => sin_out <= x"68d1";
		when x"9c7" => sin_out <= x"68d8";
		when x"9c8" => sin_out <= x"68e0";
		when x"9c9" => sin_out <= x"68e7";
		when x"9ca" => sin_out <= x"68ee";
		when x"9cb" => sin_out <= x"68f5";
		when x"9cc" => sin_out <= x"68fc";
		when x"9cd" => sin_out <= x"6904";
		when x"9ce" => sin_out <= x"690b";
		when x"9cf" => sin_out <= x"6912";
		when x"9d0" => sin_out <= x"6919";
		when x"9d1" => sin_out <= x"6920";
		when x"9d2" => sin_out <= x"6927";
		when x"9d3" => sin_out <= x"692f";
		when x"9d4" => sin_out <= x"6936";
		when x"9d5" => sin_out <= x"693d";
		when x"9d6" => sin_out <= x"6944";
		when x"9d7" => sin_out <= x"694b";
		when x"9d8" => sin_out <= x"6952";
		when x"9d9" => sin_out <= x"6959";
		when x"9da" => sin_out <= x"6961";
		when x"9db" => sin_out <= x"6968";
		when x"9dc" => sin_out <= x"696f";
		when x"9dd" => sin_out <= x"6976";
		when x"9de" => sin_out <= x"697d";
		when x"9df" => sin_out <= x"6984";
		when x"9e0" => sin_out <= x"698b";
		when x"9e1" => sin_out <= x"6992";
		when x"9e2" => sin_out <= x"699a";
		when x"9e3" => sin_out <= x"69a1";
		when x"9e4" => sin_out <= x"69a8";
		when x"9e5" => sin_out <= x"69af";
		when x"9e6" => sin_out <= x"69b6";
		when x"9e7" => sin_out <= x"69bd";
		when x"9e8" => sin_out <= x"69c4";
		when x"9e9" => sin_out <= x"69cb";
		when x"9ea" => sin_out <= x"69d2";
		when x"9eb" => sin_out <= x"69d9";
		when x"9ec" => sin_out <= x"69e0";
		when x"9ed" => sin_out <= x"69e7";
		when x"9ee" => sin_out <= x"69ee";
		when x"9ef" => sin_out <= x"69f6";
		when x"9f0" => sin_out <= x"69fd";
		when x"9f1" => sin_out <= x"6a04";
		when x"9f2" => sin_out <= x"6a0b";
		when x"9f3" => sin_out <= x"6a12";
		when x"9f4" => sin_out <= x"6a19";
		when x"9f5" => sin_out <= x"6a20";
		when x"9f6" => sin_out <= x"6a27";
		when x"9f7" => sin_out <= x"6a2e";
		when x"9f8" => sin_out <= x"6a35";
		when x"9f9" => sin_out <= x"6a3c";
		when x"9fa" => sin_out <= x"6a43";
		when x"9fb" => sin_out <= x"6a4a";
		when x"9fc" => sin_out <= x"6a51";
		when x"9fd" => sin_out <= x"6a58";
		when x"9fe" => sin_out <= x"6a5f";
		when x"9ff" => sin_out <= x"6a66";
		when x"a00" => sin_out <= x"6a6d";
		when x"a01" => sin_out <= x"6a74";
		when x"a02" => sin_out <= x"6a7b";
		when x"a03" => sin_out <= x"6a82";
		when x"a04" => sin_out <= x"6a89";
		when x"a05" => sin_out <= x"6a90";
		when x"a06" => sin_out <= x"6a97";
		when x"a07" => sin_out <= x"6a9e";
		when x"a08" => sin_out <= x"6aa4";
		when x"a09" => sin_out <= x"6aab";
		when x"a0a" => sin_out <= x"6ab2";
		when x"a0b" => sin_out <= x"6ab9";
		when x"a0c" => sin_out <= x"6ac0";
		when x"a0d" => sin_out <= x"6ac7";
		when x"a0e" => sin_out <= x"6ace";
		when x"a0f" => sin_out <= x"6ad5";
		when x"a10" => sin_out <= x"6adc";
		when x"a11" => sin_out <= x"6ae3";
		when x"a12" => sin_out <= x"6aea";
		when x"a13" => sin_out <= x"6af1";
		when x"a14" => sin_out <= x"6af8";
		when x"a15" => sin_out <= x"6afe";
		when x"a16" => sin_out <= x"6b05";
		when x"a17" => sin_out <= x"6b0c";
		when x"a18" => sin_out <= x"6b13";
		when x"a19" => sin_out <= x"6b1a";
		when x"a1a" => sin_out <= x"6b21";
		when x"a1b" => sin_out <= x"6b28";
		when x"a1c" => sin_out <= x"6b2f";
		when x"a1d" => sin_out <= x"6b36";
		when x"a1e" => sin_out <= x"6b3c";
		when x"a1f" => sin_out <= x"6b43";
		when x"a20" => sin_out <= x"6b4a";
		when x"a21" => sin_out <= x"6b51";
		when x"a22" => sin_out <= x"6b58";
		when x"a23" => sin_out <= x"6b5f";
		when x"a24" => sin_out <= x"6b65";
		when x"a25" => sin_out <= x"6b6c";
		when x"a26" => sin_out <= x"6b73";
		when x"a27" => sin_out <= x"6b7a";
		when x"a28" => sin_out <= x"6b81";
		when x"a29" => sin_out <= x"6b88";
		when x"a2a" => sin_out <= x"6b8e";
		when x"a2b" => sin_out <= x"6b95";
		when x"a2c" => sin_out <= x"6b9c";
		when x"a2d" => sin_out <= x"6ba3";
		when x"a2e" => sin_out <= x"6baa";
		when x"a2f" => sin_out <= x"6bb0";
		when x"a30" => sin_out <= x"6bb7";
		when x"a31" => sin_out <= x"6bbe";
		when x"a32" => sin_out <= x"6bc5";
		when x"a33" => sin_out <= x"6bcc";
		when x"a34" => sin_out <= x"6bd2";
		when x"a35" => sin_out <= x"6bd9";
		when x"a36" => sin_out <= x"6be0";
		when x"a37" => sin_out <= x"6be7";
		when x"a38" => sin_out <= x"6bed";
		when x"a39" => sin_out <= x"6bf4";
		when x"a3a" => sin_out <= x"6bfb";
		when x"a3b" => sin_out <= x"6c02";
		when x"a3c" => sin_out <= x"6c08";
		when x"a3d" => sin_out <= x"6c0f";
		when x"a3e" => sin_out <= x"6c16";
		when x"a3f" => sin_out <= x"6c1d";
		when x"a40" => sin_out <= x"6c23";
		when x"a41" => sin_out <= x"6c2a";
		when x"a42" => sin_out <= x"6c31";
		when x"a43" => sin_out <= x"6c37";
		when x"a44" => sin_out <= x"6c3e";
		when x"a45" => sin_out <= x"6c45";
		when x"a46" => sin_out <= x"6c4c";
		when x"a47" => sin_out <= x"6c52";
		when x"a48" => sin_out <= x"6c59";
		when x"a49" => sin_out <= x"6c60";
		when x"a4a" => sin_out <= x"6c66";
		when x"a4b" => sin_out <= x"6c6d";
		when x"a4c" => sin_out <= x"6c74";
		when x"a4d" => sin_out <= x"6c7a";
		when x"a4e" => sin_out <= x"6c81";
		when x"a4f" => sin_out <= x"6c88";
		when x"a50" => sin_out <= x"6c8e";
		when x"a51" => sin_out <= x"6c95";
		when x"a52" => sin_out <= x"6c9c";
		when x"a53" => sin_out <= x"6ca2";
		when x"a54" => sin_out <= x"6ca9";
		when x"a55" => sin_out <= x"6cb0";
		when x"a56" => sin_out <= x"6cb6";
		when x"a57" => sin_out <= x"6cbd";
		when x"a58" => sin_out <= x"6cc3";
		when x"a59" => sin_out <= x"6cca";
		when x"a5a" => sin_out <= x"6cd1";
		when x"a5b" => sin_out <= x"6cd7";
		when x"a5c" => sin_out <= x"6cde";
		when x"a5d" => sin_out <= x"6ce5";
		when x"a5e" => sin_out <= x"6ceb";
		when x"a5f" => sin_out <= x"6cf2";
		when x"a60" => sin_out <= x"6cf8";
		when x"a61" => sin_out <= x"6cff";
		when x"a62" => sin_out <= x"6d06";
		when x"a63" => sin_out <= x"6d0c";
		when x"a64" => sin_out <= x"6d13";
		when x"a65" => sin_out <= x"6d19";
		when x"a66" => sin_out <= x"6d20";
		when x"a67" => sin_out <= x"6d26";
		when x"a68" => sin_out <= x"6d2d";
		when x"a69" => sin_out <= x"6d34";
		when x"a6a" => sin_out <= x"6d3a";
		when x"a6b" => sin_out <= x"6d41";
		when x"a6c" => sin_out <= x"6d47";
		when x"a6d" => sin_out <= x"6d4e";
		when x"a6e" => sin_out <= x"6d54";
		when x"a6f" => sin_out <= x"6d5b";
		when x"a70" => sin_out <= x"6d61";
		when x"a71" => sin_out <= x"6d68";
		when x"a72" => sin_out <= x"6d6e";
		when x"a73" => sin_out <= x"6d75";
		when x"a74" => sin_out <= x"6d7b";
		when x"a75" => sin_out <= x"6d82";
		when x"a76" => sin_out <= x"6d88";
		when x"a77" => sin_out <= x"6d8f";
		when x"a78" => sin_out <= x"6d95";
		when x"a79" => sin_out <= x"6d9c";
		when x"a7a" => sin_out <= x"6da2";
		when x"a7b" => sin_out <= x"6da9";
		when x"a7c" => sin_out <= x"6daf";
		when x"a7d" => sin_out <= x"6db6";
		when x"a7e" => sin_out <= x"6dbc";
		when x"a7f" => sin_out <= x"6dc3";
		when x"a80" => sin_out <= x"6dc9";
		when x"a81" => sin_out <= x"6dd0";
		when x"a82" => sin_out <= x"6dd6";
		when x"a83" => sin_out <= x"6ddd";
		when x"a84" => sin_out <= x"6de3";
		when x"a85" => sin_out <= x"6de9";
		when x"a86" => sin_out <= x"6df0";
		when x"a87" => sin_out <= x"6df6";
		when x"a88" => sin_out <= x"6dfd";
		when x"a89" => sin_out <= x"6e03";
		when x"a8a" => sin_out <= x"6e0a";
		when x"a8b" => sin_out <= x"6e10";
		when x"a8c" => sin_out <= x"6e16";
		when x"a8d" => sin_out <= x"6e1d";
		when x"a8e" => sin_out <= x"6e23";
		when x"a8f" => sin_out <= x"6e2a";
		when x"a90" => sin_out <= x"6e30";
		when x"a91" => sin_out <= x"6e36";
		when x"a92" => sin_out <= x"6e3d";
		when x"a93" => sin_out <= x"6e43";
		when x"a94" => sin_out <= x"6e4a";
		when x"a95" => sin_out <= x"6e50";
		when x"a96" => sin_out <= x"6e56";
		when x"a97" => sin_out <= x"6e5d";
		when x"a98" => sin_out <= x"6e63";
		when x"a99" => sin_out <= x"6e69";
		when x"a9a" => sin_out <= x"6e70";
		when x"a9b" => sin_out <= x"6e76";
		when x"a9c" => sin_out <= x"6e7c";
		when x"a9d" => sin_out <= x"6e83";
		when x"a9e" => sin_out <= x"6e89";
		when x"a9f" => sin_out <= x"6e8f";
		when x"aa0" => sin_out <= x"6e96";
		when x"aa1" => sin_out <= x"6e9c";
		when x"aa2" => sin_out <= x"6ea2";
		when x"aa3" => sin_out <= x"6ea9";
		when x"aa4" => sin_out <= x"6eaf";
		when x"aa5" => sin_out <= x"6eb5";
		when x"aa6" => sin_out <= x"6ebc";
		when x"aa7" => sin_out <= x"6ec2";
		when x"aa8" => sin_out <= x"6ec8";
		when x"aa9" => sin_out <= x"6ecf";
		when x"aaa" => sin_out <= x"6ed5";
		when x"aab" => sin_out <= x"6edb";
		when x"aac" => sin_out <= x"6ee1";
		when x"aad" => sin_out <= x"6ee8";
		when x"aae" => sin_out <= x"6eee";
		when x"aaf" => sin_out <= x"6ef4";
		when x"ab0" => sin_out <= x"6efb";
		when x"ab1" => sin_out <= x"6f01";
		when x"ab2" => sin_out <= x"6f07";
		when x"ab3" => sin_out <= x"6f0d";
		when x"ab4" => sin_out <= x"6f14";
		when x"ab5" => sin_out <= x"6f1a";
		when x"ab6" => sin_out <= x"6f20";
		when x"ab7" => sin_out <= x"6f26";
		when x"ab8" => sin_out <= x"6f2c";
		when x"ab9" => sin_out <= x"6f33";
		when x"aba" => sin_out <= x"6f39";
		when x"abb" => sin_out <= x"6f3f";
		when x"abc" => sin_out <= x"6f45";
		when x"abd" => sin_out <= x"6f4c";
		when x"abe" => sin_out <= x"6f52";
		when x"abf" => sin_out <= x"6f58";
		when x"ac0" => sin_out <= x"6f5e";
		when x"ac1" => sin_out <= x"6f64";
		when x"ac2" => sin_out <= x"6f6b";
		when x"ac3" => sin_out <= x"6f71";
		when x"ac4" => sin_out <= x"6f77";
		when x"ac5" => sin_out <= x"6f7d";
		when x"ac6" => sin_out <= x"6f83";
		when x"ac7" => sin_out <= x"6f89";
		when x"ac8" => sin_out <= x"6f90";
		when x"ac9" => sin_out <= x"6f96";
		when x"aca" => sin_out <= x"6f9c";
		when x"acb" => sin_out <= x"6fa2";
		when x"acc" => sin_out <= x"6fa8";
		when x"acd" => sin_out <= x"6fae";
		when x"ace" => sin_out <= x"6fb4";
		when x"acf" => sin_out <= x"6fbb";
		when x"ad0" => sin_out <= x"6fc1";
		when x"ad1" => sin_out <= x"6fc7";
		when x"ad2" => sin_out <= x"6fcd";
		when x"ad3" => sin_out <= x"6fd3";
		when x"ad4" => sin_out <= x"6fd9";
		when x"ad5" => sin_out <= x"6fdf";
		when x"ad6" => sin_out <= x"6fe5";
		when x"ad7" => sin_out <= x"6feb";
		when x"ad8" => sin_out <= x"6ff2";
		when x"ad9" => sin_out <= x"6ff8";
		when x"ada" => sin_out <= x"6ffe";
		when x"adb" => sin_out <= x"7004";
		when x"adc" => sin_out <= x"700a";
		when x"add" => sin_out <= x"7010";
		when x"ade" => sin_out <= x"7016";
		when x"adf" => sin_out <= x"701c";
		when x"ae0" => sin_out <= x"7022";
		when x"ae1" => sin_out <= x"7028";
		when x"ae2" => sin_out <= x"702e";
		when x"ae3" => sin_out <= x"7034";
		when x"ae4" => sin_out <= x"703a";
		when x"ae5" => sin_out <= x"7040";
		when x"ae6" => sin_out <= x"7046";
		when x"ae7" => sin_out <= x"704c";
		when x"ae8" => sin_out <= x"7053";
		when x"ae9" => sin_out <= x"7059";
		when x"aea" => sin_out <= x"705f";
		when x"aeb" => sin_out <= x"7065";
		when x"aec" => sin_out <= x"706b";
		when x"aed" => sin_out <= x"7071";
		when x"aee" => sin_out <= x"7077";
		when x"aef" => sin_out <= x"707d";
		when x"af0" => sin_out <= x"7083";
		when x"af1" => sin_out <= x"7089";
		when x"af2" => sin_out <= x"708f";
		when x"af3" => sin_out <= x"7095";
		when x"af4" => sin_out <= x"709b";
		when x"af5" => sin_out <= x"70a0";
		when x"af6" => sin_out <= x"70a6";
		when x"af7" => sin_out <= x"70ac";
		when x"af8" => sin_out <= x"70b2";
		when x"af9" => sin_out <= x"70b8";
		when x"afa" => sin_out <= x"70be";
		when x"afb" => sin_out <= x"70c4";
		when x"afc" => sin_out <= x"70ca";
		when x"afd" => sin_out <= x"70d0";
		when x"afe" => sin_out <= x"70d6";
		when x"aff" => sin_out <= x"70dc";
		when x"b00" => sin_out <= x"70e2";
		when x"b01" => sin_out <= x"70e8";
		when x"b02" => sin_out <= x"70ee";
		when x"b03" => sin_out <= x"70f4";
		when x"b04" => sin_out <= x"70fa";
		when x"b05" => sin_out <= x"70ff";
		when x"b06" => sin_out <= x"7105";
		when x"b07" => sin_out <= x"710b";
		when x"b08" => sin_out <= x"7111";
		when x"b09" => sin_out <= x"7117";
		when x"b0a" => sin_out <= x"711d";
		when x"b0b" => sin_out <= x"7123";
		when x"b0c" => sin_out <= x"7129";
		when x"b0d" => sin_out <= x"712f";
		when x"b0e" => sin_out <= x"7134";
		when x"b0f" => sin_out <= x"713a";
		when x"b10" => sin_out <= x"7140";
		when x"b11" => sin_out <= x"7146";
		when x"b12" => sin_out <= x"714c";
		when x"b13" => sin_out <= x"7152";
		when x"b14" => sin_out <= x"7158";
		when x"b15" => sin_out <= x"715d";
		when x"b16" => sin_out <= x"7163";
		when x"b17" => sin_out <= x"7169";
		when x"b18" => sin_out <= x"716f";
		when x"b19" => sin_out <= x"7175";
		when x"b1a" => sin_out <= x"717a";
		when x"b1b" => sin_out <= x"7180";
		when x"b1c" => sin_out <= x"7186";
		when x"b1d" => sin_out <= x"718c";
		when x"b1e" => sin_out <= x"7192";
		when x"b1f" => sin_out <= x"7197";
		when x"b20" => sin_out <= x"719d";
		when x"b21" => sin_out <= x"71a3";
		when x"b22" => sin_out <= x"71a9";
		when x"b23" => sin_out <= x"71af";
		when x"b24" => sin_out <= x"71b4";
		when x"b25" => sin_out <= x"71ba";
		when x"b26" => sin_out <= x"71c0";
		when x"b27" => sin_out <= x"71c6";
		when x"b28" => sin_out <= x"71cb";
		when x"b29" => sin_out <= x"71d1";
		when x"b2a" => sin_out <= x"71d7";
		when x"b2b" => sin_out <= x"71dd";
		when x"b2c" => sin_out <= x"71e2";
		when x"b2d" => sin_out <= x"71e8";
		when x"b2e" => sin_out <= x"71ee";
		when x"b2f" => sin_out <= x"71f4";
		when x"b30" => sin_out <= x"71f9";
		when x"b31" => sin_out <= x"71ff";
		when x"b32" => sin_out <= x"7205";
		when x"b33" => sin_out <= x"720a";
		when x"b34" => sin_out <= x"7210";
		when x"b35" => sin_out <= x"7216";
		when x"b36" => sin_out <= x"721c";
		when x"b37" => sin_out <= x"7221";
		when x"b38" => sin_out <= x"7227";
		when x"b39" => sin_out <= x"722d";
		when x"b3a" => sin_out <= x"7232";
		when x"b3b" => sin_out <= x"7238";
		when x"b3c" => sin_out <= x"723e";
		when x"b3d" => sin_out <= x"7243";
		when x"b3e" => sin_out <= x"7249";
		when x"b3f" => sin_out <= x"724f";
		when x"b40" => sin_out <= x"7254";
		when x"b41" => sin_out <= x"725a";
		when x"b42" => sin_out <= x"7260";
		when x"b43" => sin_out <= x"7265";
		when x"b44" => sin_out <= x"726b";
		when x"b45" => sin_out <= x"7270";
		when x"b46" => sin_out <= x"7276";
		when x"b47" => sin_out <= x"727c";
		when x"b48" => sin_out <= x"7281";
		when x"b49" => sin_out <= x"7287";
		when x"b4a" => sin_out <= x"728d";
		when x"b4b" => sin_out <= x"7292";
		when x"b4c" => sin_out <= x"7298";
		when x"b4d" => sin_out <= x"729d";
		when x"b4e" => sin_out <= x"72a3";
		when x"b4f" => sin_out <= x"72a9";
		when x"b50" => sin_out <= x"72ae";
		when x"b51" => sin_out <= x"72b4";
		when x"b52" => sin_out <= x"72b9";
		when x"b53" => sin_out <= x"72bf";
		when x"b54" => sin_out <= x"72c4";
		when x"b55" => sin_out <= x"72ca";
		when x"b56" => sin_out <= x"72d0";
		when x"b57" => sin_out <= x"72d5";
		when x"b58" => sin_out <= x"72db";
		when x"b59" => sin_out <= x"72e0";
		when x"b5a" => sin_out <= x"72e6";
		when x"b5b" => sin_out <= x"72eb";
		when x"b5c" => sin_out <= x"72f1";
		when x"b5d" => sin_out <= x"72f6";
		when x"b5e" => sin_out <= x"72fc";
		when x"b5f" => sin_out <= x"7301";
		when x"b60" => sin_out <= x"7307";
		when x"b61" => sin_out <= x"730c";
		when x"b62" => sin_out <= x"7312";
		when x"b63" => sin_out <= x"7317";
		when x"b64" => sin_out <= x"731d";
		when x"b65" => sin_out <= x"7322";
		when x"b66" => sin_out <= x"7328";
		when x"b67" => sin_out <= x"732d";
		when x"b68" => sin_out <= x"7333";
		when x"b69" => sin_out <= x"7338";
		when x"b6a" => sin_out <= x"733e";
		when x"b6b" => sin_out <= x"7343";
		when x"b6c" => sin_out <= x"7349";
		when x"b6d" => sin_out <= x"734e";
		when x"b6e" => sin_out <= x"7354";
		when x"b6f" => sin_out <= x"7359";
		when x"b70" => sin_out <= x"735e";
		when x"b71" => sin_out <= x"7364";
		when x"b72" => sin_out <= x"7369";
		when x"b73" => sin_out <= x"736f";
		when x"b74" => sin_out <= x"7374";
		when x"b75" => sin_out <= x"737a";
		when x"b76" => sin_out <= x"737f";
		when x"b77" => sin_out <= x"7384";
		when x"b78" => sin_out <= x"738a";
		when x"b79" => sin_out <= x"738f";
		when x"b7a" => sin_out <= x"7395";
		when x"b7b" => sin_out <= x"739a";
		when x"b7c" => sin_out <= x"739f";
		when x"b7d" => sin_out <= x"73a5";
		when x"b7e" => sin_out <= x"73aa";
		when x"b7f" => sin_out <= x"73b0";
		when x"b80" => sin_out <= x"73b5";
		when x"b81" => sin_out <= x"73ba";
		when x"b82" => sin_out <= x"73c0";
		when x"b83" => sin_out <= x"73c5";
		when x"b84" => sin_out <= x"73ca";
		when x"b85" => sin_out <= x"73d0";
		when x"b86" => sin_out <= x"73d5";
		when x"b87" => sin_out <= x"73db";
		when x"b88" => sin_out <= x"73e0";
		when x"b89" => sin_out <= x"73e5";
		when x"b8a" => sin_out <= x"73eb";
		when x"b8b" => sin_out <= x"73f0";
		when x"b8c" => sin_out <= x"73f5";
		when x"b8d" => sin_out <= x"73fa";
		when x"b8e" => sin_out <= x"7400";
		when x"b8f" => sin_out <= x"7405";
		when x"b90" => sin_out <= x"740a";
		when x"b91" => sin_out <= x"7410";
		when x"b92" => sin_out <= x"7415";
		when x"b93" => sin_out <= x"741a";
		when x"b94" => sin_out <= x"7420";
		when x"b95" => sin_out <= x"7425";
		when x"b96" => sin_out <= x"742a";
		when x"b97" => sin_out <= x"742f";
		when x"b98" => sin_out <= x"7435";
		when x"b99" => sin_out <= x"743a";
		when x"b9a" => sin_out <= x"743f";
		when x"b9b" => sin_out <= x"7444";
		when x"b9c" => sin_out <= x"744a";
		when x"b9d" => sin_out <= x"744f";
		when x"b9e" => sin_out <= x"7454";
		when x"b9f" => sin_out <= x"7459";
		when x"ba0" => sin_out <= x"745f";
		when x"ba1" => sin_out <= x"7464";
		when x"ba2" => sin_out <= x"7469";
		when x"ba3" => sin_out <= x"746e";
		when x"ba4" => sin_out <= x"7474";
		when x"ba5" => sin_out <= x"7479";
		when x"ba6" => sin_out <= x"747e";
		when x"ba7" => sin_out <= x"7483";
		when x"ba8" => sin_out <= x"7488";
		when x"ba9" => sin_out <= x"748e";
		when x"baa" => sin_out <= x"7493";
		when x"bab" => sin_out <= x"7498";
		when x"bac" => sin_out <= x"749d";
		when x"bad" => sin_out <= x"74a2";
		when x"bae" => sin_out <= x"74a8";
		when x"baf" => sin_out <= x"74ad";
		when x"bb0" => sin_out <= x"74b2";
		when x"bb1" => sin_out <= x"74b7";
		when x"bb2" => sin_out <= x"74bc";
		when x"bb3" => sin_out <= x"74c1";
		when x"bb4" => sin_out <= x"74c6";
		when x"bb5" => sin_out <= x"74cc";
		when x"bb6" => sin_out <= x"74d1";
		when x"bb7" => sin_out <= x"74d6";
		when x"bb8" => sin_out <= x"74db";
		when x"bb9" => sin_out <= x"74e0";
		when x"bba" => sin_out <= x"74e5";
		when x"bbb" => sin_out <= x"74ea";
		when x"bbc" => sin_out <= x"74f0";
		when x"bbd" => sin_out <= x"74f5";
		when x"bbe" => sin_out <= x"74fa";
		when x"bbf" => sin_out <= x"74ff";
		when x"bc0" => sin_out <= x"7504";
		when x"bc1" => sin_out <= x"7509";
		when x"bc2" => sin_out <= x"750e";
		when x"bc3" => sin_out <= x"7513";
		when x"bc4" => sin_out <= x"7518";
		when x"bc5" => sin_out <= x"751d";
		when x"bc6" => sin_out <= x"7522";
		when x"bc7" => sin_out <= x"7527";
		when x"bc8" => sin_out <= x"752d";
		when x"bc9" => sin_out <= x"7532";
		when x"bca" => sin_out <= x"7537";
		when x"bcb" => sin_out <= x"753c";
		when x"bcc" => sin_out <= x"7541";
		when x"bcd" => sin_out <= x"7546";
		when x"bce" => sin_out <= x"754b";
		when x"bcf" => sin_out <= x"7550";
		when x"bd0" => sin_out <= x"7555";
		when x"bd1" => sin_out <= x"755a";
		when x"bd2" => sin_out <= x"755f";
		when x"bd3" => sin_out <= x"7564";
		when x"bd4" => sin_out <= x"7569";
		when x"bd5" => sin_out <= x"756e";
		when x"bd6" => sin_out <= x"7573";
		when x"bd7" => sin_out <= x"7578";
		when x"bd8" => sin_out <= x"757d";
		when x"bd9" => sin_out <= x"7582";
		when x"bda" => sin_out <= x"7587";
		when x"bdb" => sin_out <= x"758c";
		when x"bdc" => sin_out <= x"7591";
		when x"bdd" => sin_out <= x"7596";
		when x"bde" => sin_out <= x"759b";
		when x"bdf" => sin_out <= x"75a0";
		when x"be0" => sin_out <= x"75a5";
		when x"be1" => sin_out <= x"75aa";
		when x"be2" => sin_out <= x"75ae";
		when x"be3" => sin_out <= x"75b3";
		when x"be4" => sin_out <= x"75b8";
		when x"be5" => sin_out <= x"75bd";
		when x"be6" => sin_out <= x"75c2";
		when x"be7" => sin_out <= x"75c7";
		when x"be8" => sin_out <= x"75cc";
		when x"be9" => sin_out <= x"75d1";
		when x"bea" => sin_out <= x"75d6";
		when x"beb" => sin_out <= x"75db";
		when x"bec" => sin_out <= x"75e0";
		when x"bed" => sin_out <= x"75e5";
		when x"bee" => sin_out <= x"75e9";
		when x"bef" => sin_out <= x"75ee";
		when x"bf0" => sin_out <= x"75f3";
		when x"bf1" => sin_out <= x"75f8";
		when x"bf2" => sin_out <= x"75fd";
		when x"bf3" => sin_out <= x"7602";
		when x"bf4" => sin_out <= x"7607";
		when x"bf5" => sin_out <= x"760c";
		when x"bf6" => sin_out <= x"7610";
		when x"bf7" => sin_out <= x"7615";
		when x"bf8" => sin_out <= x"761a";
		when x"bf9" => sin_out <= x"761f";
		when x"bfa" => sin_out <= x"7624";
		when x"bfb" => sin_out <= x"7629";
		when x"bfc" => sin_out <= x"762d";
		when x"bfd" => sin_out <= x"7632";
		when x"bfe" => sin_out <= x"7637";
		when x"bff" => sin_out <= x"763c";
		when x"c00" => sin_out <= x"7641";
		when x"c01" => sin_out <= x"7646";
		when x"c02" => sin_out <= x"764a";
		when x"c03" => sin_out <= x"764f";
		when x"c04" => sin_out <= x"7654";
		when x"c05" => sin_out <= x"7659";
		when x"c06" => sin_out <= x"765e";
		when x"c07" => sin_out <= x"7662";
		when x"c08" => sin_out <= x"7667";
		when x"c09" => sin_out <= x"766c";
		when x"c0a" => sin_out <= x"7671";
		when x"c0b" => sin_out <= x"7675";
		when x"c0c" => sin_out <= x"767a";
		when x"c0d" => sin_out <= x"767f";
		when x"c0e" => sin_out <= x"7684";
		when x"c0f" => sin_out <= x"7688";
		when x"c10" => sin_out <= x"768d";
		when x"c11" => sin_out <= x"7692";
		when x"c12" => sin_out <= x"7697";
		when x"c13" => sin_out <= x"769b";
		when x"c14" => sin_out <= x"76a0";
		when x"c15" => sin_out <= x"76a5";
		when x"c16" => sin_out <= x"76a9";
		when x"c17" => sin_out <= x"76ae";
		when x"c18" => sin_out <= x"76b3";
		when x"c19" => sin_out <= x"76b8";
		when x"c1a" => sin_out <= x"76bc";
		when x"c1b" => sin_out <= x"76c1";
		when x"c1c" => sin_out <= x"76c6";
		when x"c1d" => sin_out <= x"76ca";
		when x"c1e" => sin_out <= x"76cf";
		when x"c1f" => sin_out <= x"76d4";
		when x"c20" => sin_out <= x"76d8";
		when x"c21" => sin_out <= x"76dd";
		when x"c22" => sin_out <= x"76e2";
		when x"c23" => sin_out <= x"76e6";
		when x"c24" => sin_out <= x"76eb";
		when x"c25" => sin_out <= x"76f0";
		when x"c26" => sin_out <= x"76f4";
		when x"c27" => sin_out <= x"76f9";
		when x"c28" => sin_out <= x"76fe";
		when x"c29" => sin_out <= x"7702";
		when x"c2a" => sin_out <= x"7707";
		when x"c2b" => sin_out <= x"770b";
		when x"c2c" => sin_out <= x"7710";
		when x"c2d" => sin_out <= x"7715";
		when x"c2e" => sin_out <= x"7719";
		when x"c2f" => sin_out <= x"771e";
		when x"c30" => sin_out <= x"7722";
		when x"c31" => sin_out <= x"7727";
		when x"c32" => sin_out <= x"772c";
		when x"c33" => sin_out <= x"7730";
		when x"c34" => sin_out <= x"7735";
		when x"c35" => sin_out <= x"7739";
		when x"c36" => sin_out <= x"773e";
		when x"c37" => sin_out <= x"7742";
		when x"c38" => sin_out <= x"7747";
		when x"c39" => sin_out <= x"774c";
		when x"c3a" => sin_out <= x"7750";
		when x"c3b" => sin_out <= x"7755";
		when x"c3c" => sin_out <= x"7759";
		when x"c3d" => sin_out <= x"775e";
		when x"c3e" => sin_out <= x"7762";
		when x"c3f" => sin_out <= x"7767";
		when x"c40" => sin_out <= x"776b";
		when x"c41" => sin_out <= x"7770";
		when x"c42" => sin_out <= x"7774";
		when x"c43" => sin_out <= x"7779";
		when x"c44" => sin_out <= x"777d";
		when x"c45" => sin_out <= x"7782";
		when x"c46" => sin_out <= x"7786";
		when x"c47" => sin_out <= x"778b";
		when x"c48" => sin_out <= x"778f";
		when x"c49" => sin_out <= x"7794";
		when x"c4a" => sin_out <= x"7798";
		when x"c4b" => sin_out <= x"779d";
		when x"c4c" => sin_out <= x"77a1";
		when x"c4d" => sin_out <= x"77a6";
		when x"c4e" => sin_out <= x"77aa";
		when x"c4f" => sin_out <= x"77af";
		when x"c50" => sin_out <= x"77b3";
		when x"c51" => sin_out <= x"77b8";
		when x"c52" => sin_out <= x"77bc";
		when x"c53" => sin_out <= x"77c0";
		when x"c54" => sin_out <= x"77c5";
		when x"c55" => sin_out <= x"77c9";
		when x"c56" => sin_out <= x"77ce";
		when x"c57" => sin_out <= x"77d2";
		when x"c58" => sin_out <= x"77d7";
		when x"c59" => sin_out <= x"77db";
		when x"c5a" => sin_out <= x"77df";
		when x"c5b" => sin_out <= x"77e4";
		when x"c5c" => sin_out <= x"77e8";
		when x"c5d" => sin_out <= x"77ed";
		when x"c5e" => sin_out <= x"77f1";
		when x"c5f" => sin_out <= x"77f5";
		when x"c60" => sin_out <= x"77fa";
		when x"c61" => sin_out <= x"77fe";
		when x"c62" => sin_out <= x"7803";
		when x"c63" => sin_out <= x"7807";
		when x"c64" => sin_out <= x"780b";
		when x"c65" => sin_out <= x"7810";
		when x"c66" => sin_out <= x"7814";
		when x"c67" => sin_out <= x"7818";
		when x"c68" => sin_out <= x"781d";
		when x"c69" => sin_out <= x"7821";
		when x"c6a" => sin_out <= x"7825";
		when x"c6b" => sin_out <= x"782a";
		when x"c6c" => sin_out <= x"782e";
		when x"c6d" => sin_out <= x"7832";
		when x"c6e" => sin_out <= x"7837";
		when x"c6f" => sin_out <= x"783b";
		when x"c70" => sin_out <= x"783f";
		when x"c71" => sin_out <= x"7844";
		when x"c72" => sin_out <= x"7848";
		when x"c73" => sin_out <= x"784c";
		when x"c74" => sin_out <= x"7850";
		when x"c75" => sin_out <= x"7855";
		when x"c76" => sin_out <= x"7859";
		when x"c77" => sin_out <= x"785d";
		when x"c78" => sin_out <= x"7862";
		when x"c79" => sin_out <= x"7866";
		when x"c7a" => sin_out <= x"786a";
		when x"c7b" => sin_out <= x"786e";
		when x"c7c" => sin_out <= x"7873";
		when x"c7d" => sin_out <= x"7877";
		when x"c7e" => sin_out <= x"787b";
		when x"c7f" => sin_out <= x"787f";
		when x"c80" => sin_out <= x"7884";
		when x"c81" => sin_out <= x"7888";
		when x"c82" => sin_out <= x"788c";
		when x"c83" => sin_out <= x"7890";
		when x"c84" => sin_out <= x"7894";
		when x"c85" => sin_out <= x"7899";
		when x"c86" => sin_out <= x"789d";
		when x"c87" => sin_out <= x"78a1";
		when x"c88" => sin_out <= x"78a5";
		when x"c89" => sin_out <= x"78a9";
		when x"c8a" => sin_out <= x"78ae";
		when x"c8b" => sin_out <= x"78b2";
		when x"c8c" => sin_out <= x"78b6";
		when x"c8d" => sin_out <= x"78ba";
		when x"c8e" => sin_out <= x"78be";
		when x"c8f" => sin_out <= x"78c3";
		when x"c90" => sin_out <= x"78c7";
		when x"c91" => sin_out <= x"78cb";
		when x"c92" => sin_out <= x"78cf";
		when x"c93" => sin_out <= x"78d3";
		when x"c94" => sin_out <= x"78d7";
		when x"c95" => sin_out <= x"78db";
		when x"c96" => sin_out <= x"78e0";
		when x"c97" => sin_out <= x"78e4";
		when x"c98" => sin_out <= x"78e8";
		when x"c99" => sin_out <= x"78ec";
		when x"c9a" => sin_out <= x"78f0";
		when x"c9b" => sin_out <= x"78f4";
		when x"c9c" => sin_out <= x"78f8";
		when x"c9d" => sin_out <= x"78fc";
		when x"c9e" => sin_out <= x"7901";
		when x"c9f" => sin_out <= x"7905";
		when x"ca0" => sin_out <= x"7909";
		when x"ca1" => sin_out <= x"790d";
		when x"ca2" => sin_out <= x"7911";
		when x"ca3" => sin_out <= x"7915";
		when x"ca4" => sin_out <= x"7919";
		when x"ca5" => sin_out <= x"791d";
		when x"ca6" => sin_out <= x"7921";
		when x"ca7" => sin_out <= x"7925";
		when x"ca8" => sin_out <= x"7929";
		when x"ca9" => sin_out <= x"792d";
		when x"caa" => sin_out <= x"7931";
		when x"cab" => sin_out <= x"7935";
		when x"cac" => sin_out <= x"7939";
		when x"cad" => sin_out <= x"793d";
		when x"cae" => sin_out <= x"7941";
		when x"caf" => sin_out <= x"7946";
		when x"cb0" => sin_out <= x"794a";
		when x"cb1" => sin_out <= x"794e";
		when x"cb2" => sin_out <= x"7952";
		when x"cb3" => sin_out <= x"7956";
		when x"cb4" => sin_out <= x"795a";
		when x"cb5" => sin_out <= x"795e";
		when x"cb6" => sin_out <= x"7962";
		when x"cb7" => sin_out <= x"7966";
		when x"cb8" => sin_out <= x"796a";
		when x"cb9" => sin_out <= x"796d";
		when x"cba" => sin_out <= x"7971";
		when x"cbb" => sin_out <= x"7975";
		when x"cbc" => sin_out <= x"7979";
		when x"cbd" => sin_out <= x"797d";
		when x"cbe" => sin_out <= x"7981";
		when x"cbf" => sin_out <= x"7985";
		when x"cc0" => sin_out <= x"7989";
		when x"cc1" => sin_out <= x"798d";
		when x"cc2" => sin_out <= x"7991";
		when x"cc3" => sin_out <= x"7995";
		when x"cc4" => sin_out <= x"7999";
		when x"cc5" => sin_out <= x"799d";
		when x"cc6" => sin_out <= x"79a1";
		when x"cc7" => sin_out <= x"79a5";
		when x"cc8" => sin_out <= x"79a9";
		when x"cc9" => sin_out <= x"79ac";
		when x"cca" => sin_out <= x"79b0";
		when x"ccb" => sin_out <= x"79b4";
		when x"ccc" => sin_out <= x"79b8";
		when x"ccd" => sin_out <= x"79bc";
		when x"cce" => sin_out <= x"79c0";
		when x"ccf" => sin_out <= x"79c4";
		when x"cd0" => sin_out <= x"79c8";
		when x"cd1" => sin_out <= x"79cc";
		when x"cd2" => sin_out <= x"79cf";
		when x"cd3" => sin_out <= x"79d3";
		when x"cd4" => sin_out <= x"79d7";
		when x"cd5" => sin_out <= x"79db";
		when x"cd6" => sin_out <= x"79df";
		when x"cd7" => sin_out <= x"79e3";
		when x"cd8" => sin_out <= x"79e6";
		when x"cd9" => sin_out <= x"79ea";
		when x"cda" => sin_out <= x"79ee";
		when x"cdb" => sin_out <= x"79f2";
		when x"cdc" => sin_out <= x"79f6";
		when x"cdd" => sin_out <= x"79fa";
		when x"cde" => sin_out <= x"79fd";
		when x"cdf" => sin_out <= x"7a01";
		when x"ce0" => sin_out <= x"7a05";
		when x"ce1" => sin_out <= x"7a09";
		when x"ce2" => sin_out <= x"7a0d";
		when x"ce3" => sin_out <= x"7a10";
		when x"ce4" => sin_out <= x"7a14";
		when x"ce5" => sin_out <= x"7a18";
		when x"ce6" => sin_out <= x"7a1c";
		when x"ce7" => sin_out <= x"7a1f";
		when x"ce8" => sin_out <= x"7a23";
		when x"ce9" => sin_out <= x"7a27";
		when x"cea" => sin_out <= x"7a2b";
		when x"ceb" => sin_out <= x"7a2e";
		when x"cec" => sin_out <= x"7a32";
		when x"ced" => sin_out <= x"7a36";
		when x"cee" => sin_out <= x"7a3a";
		when x"cef" => sin_out <= x"7a3d";
		when x"cf0" => sin_out <= x"7a41";
		when x"cf1" => sin_out <= x"7a45";
		when x"cf2" => sin_out <= x"7a49";
		when x"cf3" => sin_out <= x"7a4c";
		when x"cf4" => sin_out <= x"7a50";
		when x"cf5" => sin_out <= x"7a54";
		when x"cf6" => sin_out <= x"7a57";
		when x"cf7" => sin_out <= x"7a5b";
		when x"cf8" => sin_out <= x"7a5f";
		when x"cf9" => sin_out <= x"7a62";
		when x"cfa" => sin_out <= x"7a66";
		when x"cfb" => sin_out <= x"7a6a";
		when x"cfc" => sin_out <= x"7a6d";
		when x"cfd" => sin_out <= x"7a71";
		when x"cfe" => sin_out <= x"7a75";
		when x"cff" => sin_out <= x"7a78";
		when x"d00" => sin_out <= x"7a7c";
		when x"d01" => sin_out <= x"7a80";
		when x"d02" => sin_out <= x"7a83";
		when x"d03" => sin_out <= x"7a87";
		when x"d04" => sin_out <= x"7a8b";
		when x"d05" => sin_out <= x"7a8e";
		when x"d06" => sin_out <= x"7a92";
		when x"d07" => sin_out <= x"7a95";
		when x"d08" => sin_out <= x"7a99";
		when x"d09" => sin_out <= x"7a9d";
		when x"d0a" => sin_out <= x"7aa0";
		when x"d0b" => sin_out <= x"7aa4";
		when x"d0c" => sin_out <= x"7aa8";
		when x"d0d" => sin_out <= x"7aab";
		when x"d0e" => sin_out <= x"7aaf";
		when x"d0f" => sin_out <= x"7ab2";
		when x"d10" => sin_out <= x"7ab6";
		when x"d11" => sin_out <= x"7ab9";
		when x"d12" => sin_out <= x"7abd";
		when x"d13" => sin_out <= x"7ac1";
		when x"d14" => sin_out <= x"7ac4";
		when x"d15" => sin_out <= x"7ac8";
		when x"d16" => sin_out <= x"7acb";
		when x"d17" => sin_out <= x"7acf";
		when x"d18" => sin_out <= x"7ad2";
		when x"d19" => sin_out <= x"7ad6";
		when x"d1a" => sin_out <= x"7ad9";
		when x"d1b" => sin_out <= x"7add";
		when x"d1c" => sin_out <= x"7ae0";
		when x"d1d" => sin_out <= x"7ae4";
		when x"d1e" => sin_out <= x"7ae7";
		when x"d1f" => sin_out <= x"7aeb";
		when x"d20" => sin_out <= x"7aee";
		when x"d21" => sin_out <= x"7af2";
		when x"d22" => sin_out <= x"7af5";
		when x"d23" => sin_out <= x"7af9";
		when x"d24" => sin_out <= x"7afc";
		when x"d25" => sin_out <= x"7b00";
		when x"d26" => sin_out <= x"7b03";
		when x"d27" => sin_out <= x"7b07";
		when x"d28" => sin_out <= x"7b0a";
		when x"d29" => sin_out <= x"7b0e";
		when x"d2a" => sin_out <= x"7b11";
		when x"d2b" => sin_out <= x"7b15";
		when x"d2c" => sin_out <= x"7b18";
		when x"d2d" => sin_out <= x"7b1c";
		when x"d2e" => sin_out <= x"7b1f";
		when x"d2f" => sin_out <= x"7b22";
		when x"d30" => sin_out <= x"7b26";
		when x"d31" => sin_out <= x"7b29";
		when x"d32" => sin_out <= x"7b2d";
		when x"d33" => sin_out <= x"7b30";
		when x"d34" => sin_out <= x"7b33";
		when x"d35" => sin_out <= x"7b37";
		when x"d36" => sin_out <= x"7b3a";
		when x"d37" => sin_out <= x"7b3e";
		when x"d38" => sin_out <= x"7b41";
		when x"d39" => sin_out <= x"7b44";
		when x"d3a" => sin_out <= x"7b48";
		when x"d3b" => sin_out <= x"7b4b";
		when x"d3c" => sin_out <= x"7b4f";
		when x"d3d" => sin_out <= x"7b52";
		when x"d3e" => sin_out <= x"7b55";
		when x"d3f" => sin_out <= x"7b59";
		when x"d40" => sin_out <= x"7b5c";
		when x"d41" => sin_out <= x"7b5f";
		when x"d42" => sin_out <= x"7b63";
		when x"d43" => sin_out <= x"7b66";
		when x"d44" => sin_out <= x"7b69";
		when x"d45" => sin_out <= x"7b6d";
		when x"d46" => sin_out <= x"7b70";
		when x"d47" => sin_out <= x"7b73";
		when x"d48" => sin_out <= x"7b77";
		when x"d49" => sin_out <= x"7b7a";
		when x"d4a" => sin_out <= x"7b7d";
		when x"d4b" => sin_out <= x"7b81";
		when x"d4c" => sin_out <= x"7b84";
		when x"d4d" => sin_out <= x"7b87";
		when x"d4e" => sin_out <= x"7b8b";
		when x"d4f" => sin_out <= x"7b8e";
		when x"d50" => sin_out <= x"7b91";
		when x"d51" => sin_out <= x"7b94";
		when x"d52" => sin_out <= x"7b98";
		when x"d53" => sin_out <= x"7b9b";
		when x"d54" => sin_out <= x"7b9e";
		when x"d55" => sin_out <= x"7ba1";
		when x"d56" => sin_out <= x"7ba5";
		when x"d57" => sin_out <= x"7ba8";
		when x"d58" => sin_out <= x"7bab";
		when x"d59" => sin_out <= x"7bae";
		when x"d5a" => sin_out <= x"7bb2";
		when x"d5b" => sin_out <= x"7bb5";
		when x"d5c" => sin_out <= x"7bb8";
		when x"d5d" => sin_out <= x"7bbb";
		when x"d5e" => sin_out <= x"7bbf";
		when x"d5f" => sin_out <= x"7bc2";
		when x"d60" => sin_out <= x"7bc5";
		when x"d61" => sin_out <= x"7bc8";
		when x"d62" => sin_out <= x"7bcb";
		when x"d63" => sin_out <= x"7bcf";
		when x"d64" => sin_out <= x"7bd2";
		when x"d65" => sin_out <= x"7bd5";
		when x"d66" => sin_out <= x"7bd8";
		when x"d67" => sin_out <= x"7bdb";
		when x"d68" => sin_out <= x"7bde";
		when x"d69" => sin_out <= x"7be2";
		when x"d6a" => sin_out <= x"7be5";
		when x"d6b" => sin_out <= x"7be8";
		when x"d6c" => sin_out <= x"7beb";
		when x"d6d" => sin_out <= x"7bee";
		when x"d6e" => sin_out <= x"7bf1";
		when x"d6f" => sin_out <= x"7bf4";
		when x"d70" => sin_out <= x"7bf8";
		when x"d71" => sin_out <= x"7bfb";
		when x"d72" => sin_out <= x"7bfe";
		when x"d73" => sin_out <= x"7c01";
		when x"d74" => sin_out <= x"7c04";
		when x"d75" => sin_out <= x"7c07";
		when x"d76" => sin_out <= x"7c0a";
		when x"d77" => sin_out <= x"7c0d";
		when x"d78" => sin_out <= x"7c10";
		when x"d79" => sin_out <= x"7c14";
		when x"d7a" => sin_out <= x"7c17";
		when x"d7b" => sin_out <= x"7c1a";
		when x"d7c" => sin_out <= x"7c1d";
		when x"d7d" => sin_out <= x"7c20";
		when x"d7e" => sin_out <= x"7c23";
		when x"d7f" => sin_out <= x"7c26";
		when x"d80" => sin_out <= x"7c29";
		when x"d81" => sin_out <= x"7c2c";
		when x"d82" => sin_out <= x"7c2f";
		when x"d83" => sin_out <= x"7c32";
		when x"d84" => sin_out <= x"7c35";
		when x"d85" => sin_out <= x"7c38";
		when x"d86" => sin_out <= x"7c3b";
		when x"d87" => sin_out <= x"7c3e";
		when x"d88" => sin_out <= x"7c41";
		when x"d89" => sin_out <= x"7c44";
		when x"d8a" => sin_out <= x"7c47";
		when x"d8b" => sin_out <= x"7c4a";
		when x"d8c" => sin_out <= x"7c4d";
		when x"d8d" => sin_out <= x"7c50";
		when x"d8e" => sin_out <= x"7c53";
		when x"d8f" => sin_out <= x"7c56";
		when x"d90" => sin_out <= x"7c59";
		when x"d91" => sin_out <= x"7c5c";
		when x"d92" => sin_out <= x"7c5f";
		when x"d93" => sin_out <= x"7c62";
		when x"d94" => sin_out <= x"7c65";
		when x"d95" => sin_out <= x"7c68";
		when x"d96" => sin_out <= x"7c6b";
		when x"d97" => sin_out <= x"7c6e";
		when x"d98" => sin_out <= x"7c71";
		when x"d99" => sin_out <= x"7c74";
		when x"d9a" => sin_out <= x"7c77";
		when x"d9b" => sin_out <= x"7c7a";
		when x"d9c" => sin_out <= x"7c7d";
		when x"d9d" => sin_out <= x"7c80";
		when x"d9e" => sin_out <= x"7c83";
		when x"d9f" => sin_out <= x"7c85";
		when x"da0" => sin_out <= x"7c88";
		when x"da1" => sin_out <= x"7c8b";
		when x"da2" => sin_out <= x"7c8e";
		when x"da3" => sin_out <= x"7c91";
		when x"da4" => sin_out <= x"7c94";
		when x"da5" => sin_out <= x"7c97";
		when x"da6" => sin_out <= x"7c9a";
		when x"da7" => sin_out <= x"7c9d";
		when x"da8" => sin_out <= x"7c9f";
		when x"da9" => sin_out <= x"7ca2";
		when x"daa" => sin_out <= x"7ca5";
		when x"dab" => sin_out <= x"7ca8";
		when x"dac" => sin_out <= x"7cab";
		when x"dad" => sin_out <= x"7cae";
		when x"dae" => sin_out <= x"7cb1";
		when x"daf" => sin_out <= x"7cb3";
		when x"db0" => sin_out <= x"7cb6";
		when x"db1" => sin_out <= x"7cb9";
		when x"db2" => sin_out <= x"7cbc";
		when x"db3" => sin_out <= x"7cbf";
		when x"db4" => sin_out <= x"7cc1";
		when x"db5" => sin_out <= x"7cc4";
		when x"db6" => sin_out <= x"7cc7";
		when x"db7" => sin_out <= x"7cca";
		when x"db8" => sin_out <= x"7ccd";
		when x"db9" => sin_out <= x"7ccf";
		when x"dba" => sin_out <= x"7cd2";
		when x"dbb" => sin_out <= x"7cd5";
		when x"dbc" => sin_out <= x"7cd8";
		when x"dbd" => sin_out <= x"7cdb";
		when x"dbe" => sin_out <= x"7cdd";
		when x"dbf" => sin_out <= x"7ce0";
		when x"dc0" => sin_out <= x"7ce3";
		when x"dc1" => sin_out <= x"7ce6";
		when x"dc2" => sin_out <= x"7ce8";
		when x"dc3" => sin_out <= x"7ceb";
		when x"dc4" => sin_out <= x"7cee";
		when x"dc5" => sin_out <= x"7cf1";
		when x"dc6" => sin_out <= x"7cf3";
		when x"dc7" => sin_out <= x"7cf6";
		when x"dc8" => sin_out <= x"7cf9";
		when x"dc9" => sin_out <= x"7cfb";
		when x"dca" => sin_out <= x"7cfe";
		when x"dcb" => sin_out <= x"7d01";
		when x"dcc" => sin_out <= x"7d04";
		when x"dcd" => sin_out <= x"7d06";
		when x"dce" => sin_out <= x"7d09";
		when x"dcf" => sin_out <= x"7d0c";
		when x"dd0" => sin_out <= x"7d0e";
		when x"dd1" => sin_out <= x"7d11";
		when x"dd2" => sin_out <= x"7d14";
		when x"dd3" => sin_out <= x"7d16";
		when x"dd4" => sin_out <= x"7d19";
		when x"dd5" => sin_out <= x"7d1c";
		when x"dd6" => sin_out <= x"7d1e";
		when x"dd7" => sin_out <= x"7d21";
		when x"dd8" => sin_out <= x"7d24";
		when x"dd9" => sin_out <= x"7d26";
		when x"dda" => sin_out <= x"7d29";
		when x"ddb" => sin_out <= x"7d2b";
		when x"ddc" => sin_out <= x"7d2e";
		when x"ddd" => sin_out <= x"7d31";
		when x"dde" => sin_out <= x"7d33";
		when x"ddf" => sin_out <= x"7d36";
		when x"de0" => sin_out <= x"7d39";
		when x"de1" => sin_out <= x"7d3b";
		when x"de2" => sin_out <= x"7d3e";
		when x"de3" => sin_out <= x"7d40";
		when x"de4" => sin_out <= x"7d43";
		when x"de5" => sin_out <= x"7d45";
		when x"de6" => sin_out <= x"7d48";
		when x"de7" => sin_out <= x"7d4b";
		when x"de8" => sin_out <= x"7d4d";
		when x"de9" => sin_out <= x"7d50";
		when x"dea" => sin_out <= x"7d52";
		when x"deb" => sin_out <= x"7d55";
		when x"dec" => sin_out <= x"7d57";
		when x"ded" => sin_out <= x"7d5a";
		when x"dee" => sin_out <= x"7d5c";
		when x"def" => sin_out <= x"7d5f";
		when x"df0" => sin_out <= x"7d62";
		when x"df1" => sin_out <= x"7d64";
		when x"df2" => sin_out <= x"7d67";
		when x"df3" => sin_out <= x"7d69";
		when x"df4" => sin_out <= x"7d6c";
		when x"df5" => sin_out <= x"7d6e";
		when x"df6" => sin_out <= x"7d71";
		when x"df7" => sin_out <= x"7d73";
		when x"df8" => sin_out <= x"7d76";
		when x"df9" => sin_out <= x"7d78";
		when x"dfa" => sin_out <= x"7d7b";
		when x"dfb" => sin_out <= x"7d7d";
		when x"dfc" => sin_out <= x"7d80";
		when x"dfd" => sin_out <= x"7d82";
		when x"dfe" => sin_out <= x"7d84";
		when x"dff" => sin_out <= x"7d87";
		when x"e00" => sin_out <= x"7d89";
		when x"e01" => sin_out <= x"7d8c";
		when x"e02" => sin_out <= x"7d8e";
		when x"e03" => sin_out <= x"7d91";
		when x"e04" => sin_out <= x"7d93";
		when x"e05" => sin_out <= x"7d96";
		when x"e06" => sin_out <= x"7d98";
		when x"e07" => sin_out <= x"7d9a";
		when x"e08" => sin_out <= x"7d9d";
		when x"e09" => sin_out <= x"7d9f";
		when x"e0a" => sin_out <= x"7da2";
		when x"e0b" => sin_out <= x"7da4";
		when x"e0c" => sin_out <= x"7da6";
		when x"e0d" => sin_out <= x"7da9";
		when x"e0e" => sin_out <= x"7dab";
		when x"e0f" => sin_out <= x"7dae";
		when x"e10" => sin_out <= x"7db0";
		when x"e11" => sin_out <= x"7db2";
		when x"e12" => sin_out <= x"7db5";
		when x"e13" => sin_out <= x"7db7";
		when x"e14" => sin_out <= x"7db9";
		when x"e15" => sin_out <= x"7dbc";
		when x"e16" => sin_out <= x"7dbe";
		when x"e17" => sin_out <= x"7dc1";
		when x"e18" => sin_out <= x"7dc3";
		when x"e19" => sin_out <= x"7dc5";
		when x"e1a" => sin_out <= x"7dc8";
		when x"e1b" => sin_out <= x"7dca";
		when x"e1c" => sin_out <= x"7dcc";
		when x"e1d" => sin_out <= x"7dce";
		when x"e1e" => sin_out <= x"7dd1";
		when x"e1f" => sin_out <= x"7dd3";
		when x"e20" => sin_out <= x"7dd5";
		when x"e21" => sin_out <= x"7dd8";
		when x"e22" => sin_out <= x"7dda";
		when x"e23" => sin_out <= x"7ddc";
		when x"e24" => sin_out <= x"7ddf";
		when x"e25" => sin_out <= x"7de1";
		when x"e26" => sin_out <= x"7de3";
		when x"e27" => sin_out <= x"7de5";
		when x"e28" => sin_out <= x"7de8";
		when x"e29" => sin_out <= x"7dea";
		when x"e2a" => sin_out <= x"7dec";
		when x"e2b" => sin_out <= x"7dee";
		when x"e2c" => sin_out <= x"7df1";
		when x"e2d" => sin_out <= x"7df3";
		when x"e2e" => sin_out <= x"7df5";
		when x"e2f" => sin_out <= x"7df7";
		when x"e30" => sin_out <= x"7dfa";
		when x"e31" => sin_out <= x"7dfc";
		when x"e32" => sin_out <= x"7dfe";
		when x"e33" => sin_out <= x"7e00";
		when x"e34" => sin_out <= x"7e02";
		when x"e35" => sin_out <= x"7e05";
		when x"e36" => sin_out <= x"7e07";
		when x"e37" => sin_out <= x"7e09";
		when x"e38" => sin_out <= x"7e0b";
		when x"e39" => sin_out <= x"7e0d";
		when x"e3a" => sin_out <= x"7e10";
		when x"e3b" => sin_out <= x"7e12";
		when x"e3c" => sin_out <= x"7e14";
		when x"e3d" => sin_out <= x"7e16";
		when x"e3e" => sin_out <= x"7e18";
		when x"e3f" => sin_out <= x"7e1a";
		when x"e40" => sin_out <= x"7e1d";
		when x"e41" => sin_out <= x"7e1f";
		when x"e42" => sin_out <= x"7e21";
		when x"e43" => sin_out <= x"7e23";
		when x"e44" => sin_out <= x"7e25";
		when x"e45" => sin_out <= x"7e27";
		when x"e46" => sin_out <= x"7e29";
		when x"e47" => sin_out <= x"7e2c";
		when x"e48" => sin_out <= x"7e2e";
		when x"e49" => sin_out <= x"7e30";
		when x"e4a" => sin_out <= x"7e32";
		when x"e4b" => sin_out <= x"7e34";
		when x"e4c" => sin_out <= x"7e36";
		when x"e4d" => sin_out <= x"7e38";
		when x"e4e" => sin_out <= x"7e3a";
		when x"e4f" => sin_out <= x"7e3c";
		when x"e50" => sin_out <= x"7e3e";
		when x"e51" => sin_out <= x"7e40";
		when x"e52" => sin_out <= x"7e42";
		when x"e53" => sin_out <= x"7e45";
		when x"e54" => sin_out <= x"7e47";
		when x"e55" => sin_out <= x"7e49";
		when x"e56" => sin_out <= x"7e4b";
		when x"e57" => sin_out <= x"7e4d";
		when x"e58" => sin_out <= x"7e4f";
		when x"e59" => sin_out <= x"7e51";
		when x"e5a" => sin_out <= x"7e53";
		when x"e5b" => sin_out <= x"7e55";
		when x"e5c" => sin_out <= x"7e57";
		when x"e5d" => sin_out <= x"7e59";
		when x"e5e" => sin_out <= x"7e5b";
		when x"e5f" => sin_out <= x"7e5d";
		when x"e60" => sin_out <= x"7e5f";
		when x"e61" => sin_out <= x"7e61";
		when x"e62" => sin_out <= x"7e63";
		when x"e63" => sin_out <= x"7e65";
		when x"e64" => sin_out <= x"7e67";
		when x"e65" => sin_out <= x"7e69";
		when x"e66" => sin_out <= x"7e6b";
		when x"e67" => sin_out <= x"7e6d";
		when x"e68" => sin_out <= x"7e6f";
		when x"e69" => sin_out <= x"7e71";
		when x"e6a" => sin_out <= x"7e73";
		when x"e6b" => sin_out <= x"7e75";
		when x"e6c" => sin_out <= x"7e77";
		when x"e6d" => sin_out <= x"7e78";
		when x"e6e" => sin_out <= x"7e7a";
		when x"e6f" => sin_out <= x"7e7c";
		when x"e70" => sin_out <= x"7e7e";
		when x"e71" => sin_out <= x"7e80";
		when x"e72" => sin_out <= x"7e82";
		when x"e73" => sin_out <= x"7e84";
		when x"e74" => sin_out <= x"7e86";
		when x"e75" => sin_out <= x"7e88";
		when x"e76" => sin_out <= x"7e8a";
		when x"e77" => sin_out <= x"7e8c";
		when x"e78" => sin_out <= x"7e8d";
		when x"e79" => sin_out <= x"7e8f";
		when x"e7a" => sin_out <= x"7e91";
		when x"e7b" => sin_out <= x"7e93";
		when x"e7c" => sin_out <= x"7e95";
		when x"e7d" => sin_out <= x"7e97";
		when x"e7e" => sin_out <= x"7e99";
		when x"e7f" => sin_out <= x"7e9b";
		when x"e80" => sin_out <= x"7e9c";
		when x"e81" => sin_out <= x"7e9e";
		when x"e82" => sin_out <= x"7ea0";
		when x"e83" => sin_out <= x"7ea2";
		when x"e84" => sin_out <= x"7ea4";
		when x"e85" => sin_out <= x"7ea6";
		when x"e86" => sin_out <= x"7ea7";
		when x"e87" => sin_out <= x"7ea9";
		when x"e88" => sin_out <= x"7eab";
		when x"e89" => sin_out <= x"7ead";
		when x"e8a" => sin_out <= x"7eaf";
		when x"e8b" => sin_out <= x"7eb0";
		when x"e8c" => sin_out <= x"7eb2";
		when x"e8d" => sin_out <= x"7eb4";
		when x"e8e" => sin_out <= x"7eb6";
		when x"e8f" => sin_out <= x"7eb7";
		when x"e90" => sin_out <= x"7eb9";
		when x"e91" => sin_out <= x"7ebb";
		when x"e92" => sin_out <= x"7ebd";
		when x"e93" => sin_out <= x"7ebf";
		when x"e94" => sin_out <= x"7ec0";
		when x"e95" => sin_out <= x"7ec2";
		when x"e96" => sin_out <= x"7ec4";
		when x"e97" => sin_out <= x"7ec5";
		when x"e98" => sin_out <= x"7ec7";
		when x"e99" => sin_out <= x"7ec9";
		when x"e9a" => sin_out <= x"7ecb";
		when x"e9b" => sin_out <= x"7ecc";
		when x"e9c" => sin_out <= x"7ece";
		when x"e9d" => sin_out <= x"7ed0";
		when x"e9e" => sin_out <= x"7ed2";
		when x"e9f" => sin_out <= x"7ed3";
		when x"ea0" => sin_out <= x"7ed5";
		when x"ea1" => sin_out <= x"7ed7";
		when x"ea2" => sin_out <= x"7ed8";
		when x"ea3" => sin_out <= x"7eda";
		when x"ea4" => sin_out <= x"7edc";
		when x"ea5" => sin_out <= x"7edd";
		when x"ea6" => sin_out <= x"7edf";
		when x"ea7" => sin_out <= x"7ee1";
		when x"ea8" => sin_out <= x"7ee2";
		when x"ea9" => sin_out <= x"7ee4";
		when x"eaa" => sin_out <= x"7ee6";
		when x"eab" => sin_out <= x"7ee7";
		when x"eac" => sin_out <= x"7ee9";
		when x"ead" => sin_out <= x"7eea";
		when x"eae" => sin_out <= x"7eec";
		when x"eaf" => sin_out <= x"7eee";
		when x"eb0" => sin_out <= x"7eef";
		when x"eb1" => sin_out <= x"7ef1";
		when x"eb2" => sin_out <= x"7ef3";
		when x"eb3" => sin_out <= x"7ef4";
		when x"eb4" => sin_out <= x"7ef6";
		when x"eb5" => sin_out <= x"7ef7";
		when x"eb6" => sin_out <= x"7ef9";
		when x"eb7" => sin_out <= x"7efb";
		when x"eb8" => sin_out <= x"7efc";
		when x"eb9" => sin_out <= x"7efe";
		when x"eba" => sin_out <= x"7eff";
		when x"ebb" => sin_out <= x"7f01";
		when x"ebc" => sin_out <= x"7f02";
		when x"ebd" => sin_out <= x"7f04";
		when x"ebe" => sin_out <= x"7f05";
		when x"ebf" => sin_out <= x"7f07";
		when x"ec0" => sin_out <= x"7f09";
		when x"ec1" => sin_out <= x"7f0a";
		when x"ec2" => sin_out <= x"7f0c";
		when x"ec3" => sin_out <= x"7f0d";
		when x"ec4" => sin_out <= x"7f0f";
		when x"ec5" => sin_out <= x"7f10";
		when x"ec6" => sin_out <= x"7f12";
		when x"ec7" => sin_out <= x"7f13";
		when x"ec8" => sin_out <= x"7f15";
		when x"ec9" => sin_out <= x"7f16";
		when x"eca" => sin_out <= x"7f18";
		when x"ecb" => sin_out <= x"7f19";
		when x"ecc" => sin_out <= x"7f1b";
		when x"ecd" => sin_out <= x"7f1c";
		when x"ece" => sin_out <= x"7f1e";
		when x"ecf" => sin_out <= x"7f1f";
		when x"ed0" => sin_out <= x"7f21";
		when x"ed1" => sin_out <= x"7f22";
		when x"ed2" => sin_out <= x"7f23";
		when x"ed3" => sin_out <= x"7f25";
		when x"ed4" => sin_out <= x"7f26";
		when x"ed5" => sin_out <= x"7f28";
		when x"ed6" => sin_out <= x"7f29";
		when x"ed7" => sin_out <= x"7f2b";
		when x"ed8" => sin_out <= x"7f2c";
		when x"ed9" => sin_out <= x"7f2e";
		when x"eda" => sin_out <= x"7f2f";
		when x"edb" => sin_out <= x"7f30";
		when x"edc" => sin_out <= x"7f32";
		when x"edd" => sin_out <= x"7f33";
		when x"ede" => sin_out <= x"7f35";
		when x"edf" => sin_out <= x"7f36";
		when x"ee0" => sin_out <= x"7f37";
		when x"ee1" => sin_out <= x"7f39";
		when x"ee2" => sin_out <= x"7f3a";
		when x"ee3" => sin_out <= x"7f3b";
		when x"ee4" => sin_out <= x"7f3d";
		when x"ee5" => sin_out <= x"7f3e";
		when x"ee6" => sin_out <= x"7f40";
		when x"ee7" => sin_out <= x"7f41";
		when x"ee8" => sin_out <= x"7f42";
		when x"ee9" => sin_out <= x"7f44";
		when x"eea" => sin_out <= x"7f45";
		when x"eeb" => sin_out <= x"7f46";
		when x"eec" => sin_out <= x"7f48";
		when x"eed" => sin_out <= x"7f49";
		when x"eee" => sin_out <= x"7f4a";
		when x"eef" => sin_out <= x"7f4c";
		when x"ef0" => sin_out <= x"7f4d";
		when x"ef1" => sin_out <= x"7f4e";
		when x"ef2" => sin_out <= x"7f50";
		when x"ef3" => sin_out <= x"7f51";
		when x"ef4" => sin_out <= x"7f52";
		when x"ef5" => sin_out <= x"7f53";
		when x"ef6" => sin_out <= x"7f55";
		when x"ef7" => sin_out <= x"7f56";
		when x"ef8" => sin_out <= x"7f57";
		when x"ef9" => sin_out <= x"7f58";
		when x"efa" => sin_out <= x"7f5a";
		when x"efb" => sin_out <= x"7f5b";
		when x"efc" => sin_out <= x"7f5c";
		when x"efd" => sin_out <= x"7f5e";
		when x"efe" => sin_out <= x"7f5f";
		when x"eff" => sin_out <= x"7f60";
		when x"f00" => sin_out <= x"7f61";
		when x"f01" => sin_out <= x"7f62";
		when x"f02" => sin_out <= x"7f64";
		when x"f03" => sin_out <= x"7f65";
		when x"f04" => sin_out <= x"7f66";
		when x"f05" => sin_out <= x"7f67";
		when x"f06" => sin_out <= x"7f69";
		when x"f07" => sin_out <= x"7f6a";
		when x"f08" => sin_out <= x"7f6b";
		when x"f09" => sin_out <= x"7f6c";
		when x"f0a" => sin_out <= x"7f6d";
		when x"f0b" => sin_out <= x"7f6e";
		when x"f0c" => sin_out <= x"7f70";
		when x"f0d" => sin_out <= x"7f71";
		when x"f0e" => sin_out <= x"7f72";
		when x"f0f" => sin_out <= x"7f73";
		when x"f10" => sin_out <= x"7f74";
		when x"f11" => sin_out <= x"7f75";
		when x"f12" => sin_out <= x"7f77";
		when x"f13" => sin_out <= x"7f78";
		when x"f14" => sin_out <= x"7f79";
		when x"f15" => sin_out <= x"7f7a";
		when x"f16" => sin_out <= x"7f7b";
		when x"f17" => sin_out <= x"7f7c";
		when x"f18" => sin_out <= x"7f7d";
		when x"f19" => sin_out <= x"7f7f";
		when x"f1a" => sin_out <= x"7f80";
		when x"f1b" => sin_out <= x"7f81";
		when x"f1c" => sin_out <= x"7f82";
		when x"f1d" => sin_out <= x"7f83";
		when x"f1e" => sin_out <= x"7f84";
		when x"f1f" => sin_out <= x"7f85";
		when x"f20" => sin_out <= x"7f86";
		when x"f21" => sin_out <= x"7f87";
		when x"f22" => sin_out <= x"7f88";
		when x"f23" => sin_out <= x"7f89";
		when x"f24" => sin_out <= x"7f8a";
		when x"f25" => sin_out <= x"7f8c";
		when x"f26" => sin_out <= x"7f8d";
		when x"f27" => sin_out <= x"7f8e";
		when x"f28" => sin_out <= x"7f8f";
		when x"f29" => sin_out <= x"7f90";
		when x"f2a" => sin_out <= x"7f91";
		when x"f2b" => sin_out <= x"7f92";
		when x"f2c" => sin_out <= x"7f93";
		when x"f2d" => sin_out <= x"7f94";
		when x"f2e" => sin_out <= x"7f95";
		when x"f2f" => sin_out <= x"7f96";
		when x"f30" => sin_out <= x"7f97";
		when x"f31" => sin_out <= x"7f98";
		when x"f32" => sin_out <= x"7f99";
		when x"f33" => sin_out <= x"7f9a";
		when x"f34" => sin_out <= x"7f9b";
		when x"f35" => sin_out <= x"7f9c";
		when x"f36" => sin_out <= x"7f9d";
		when x"f37" => sin_out <= x"7f9e";
		when x"f38" => sin_out <= x"7f9f";
		when x"f39" => sin_out <= x"7fa0";
		when x"f3a" => sin_out <= x"7fa1";
		when x"f3b" => sin_out <= x"7fa2";
		when x"f3c" => sin_out <= x"7fa2";
		when x"f3d" => sin_out <= x"7fa3";
		when x"f3e" => sin_out <= x"7fa4";
		when x"f3f" => sin_out <= x"7fa5";
		when x"f40" => sin_out <= x"7fa6";
		when x"f41" => sin_out <= x"7fa7";
		when x"f42" => sin_out <= x"7fa8";
		when x"f43" => sin_out <= x"7fa9";
		when x"f44" => sin_out <= x"7faa";
		when x"f45" => sin_out <= x"7fab";
		when x"f46" => sin_out <= x"7fac";
		when x"f47" => sin_out <= x"7fad";
		when x"f48" => sin_out <= x"7fad";
		when x"f49" => sin_out <= x"7fae";
		when x"f4a" => sin_out <= x"7faf";
		when x"f4b" => sin_out <= x"7fb0";
		when x"f4c" => sin_out <= x"7fb1";
		when x"f4d" => sin_out <= x"7fb2";
		when x"f4e" => sin_out <= x"7fb3";
		when x"f4f" => sin_out <= x"7fb4";
		when x"f50" => sin_out <= x"7fb4";
		when x"f51" => sin_out <= x"7fb5";
		when x"f52" => sin_out <= x"7fb6";
		when x"f53" => sin_out <= x"7fb7";
		when x"f54" => sin_out <= x"7fb8";
		when x"f55" => sin_out <= x"7fb9";
		when x"f56" => sin_out <= x"7fb9";
		when x"f57" => sin_out <= x"7fba";
		when x"f58" => sin_out <= x"7fbb";
		when x"f59" => sin_out <= x"7fbc";
		when x"f5a" => sin_out <= x"7fbd";
		when x"f5b" => sin_out <= x"7fbd";
		when x"f5c" => sin_out <= x"7fbe";
		when x"f5d" => sin_out <= x"7fbf";
		when x"f5e" => sin_out <= x"7fc0";
		when x"f5f" => sin_out <= x"7fc1";
		when x"f60" => sin_out <= x"7fc1";
		when x"f61" => sin_out <= x"7fc2";
		when x"f62" => sin_out <= x"7fc3";
		when x"f63" => sin_out <= x"7fc4";
		when x"f64" => sin_out <= x"7fc4";
		when x"f65" => sin_out <= x"7fc5";
		when x"f66" => sin_out <= x"7fc6";
		when x"f67" => sin_out <= x"7fc7";
		when x"f68" => sin_out <= x"7fc7";
		when x"f69" => sin_out <= x"7fc8";
		when x"f6a" => sin_out <= x"7fc9";
		when x"f6b" => sin_out <= x"7fca";
		when x"f6c" => sin_out <= x"7fca";
		when x"f6d" => sin_out <= x"7fcb";
		when x"f6e" => sin_out <= x"7fcc";
		when x"f6f" => sin_out <= x"7fcc";
		when x"f70" => sin_out <= x"7fcd";
		when x"f71" => sin_out <= x"7fce";
		when x"f72" => sin_out <= x"7fce";
		when x"f73" => sin_out <= x"7fcf";
		when x"f74" => sin_out <= x"7fd0";
		when x"f75" => sin_out <= x"7fd0";
		when x"f76" => sin_out <= x"7fd1";
		when x"f77" => sin_out <= x"7fd2";
		when x"f78" => sin_out <= x"7fd2";
		when x"f79" => sin_out <= x"7fd3";
		when x"f7a" => sin_out <= x"7fd4";
		when x"f7b" => sin_out <= x"7fd4";
		when x"f7c" => sin_out <= x"7fd5";
		when x"f7d" => sin_out <= x"7fd6";
		when x"f7e" => sin_out <= x"7fd6";
		when x"f7f" => sin_out <= x"7fd7";
		when x"f80" => sin_out <= x"7fd8";
		when x"f81" => sin_out <= x"7fd8";
		when x"f82" => sin_out <= x"7fd9";
		when x"f83" => sin_out <= x"7fd9";
		when x"f84" => sin_out <= x"7fda";
		when x"f85" => sin_out <= x"7fdb";
		when x"f86" => sin_out <= x"7fdb";
		when x"f87" => sin_out <= x"7fdc";
		when x"f88" => sin_out <= x"7fdc";
		when x"f89" => sin_out <= x"7fdd";
		when x"f8a" => sin_out <= x"7fdd";
		when x"f8b" => sin_out <= x"7fde";
		when x"f8c" => sin_out <= x"7fdf";
		when x"f8d" => sin_out <= x"7fdf";
		when x"f8e" => sin_out <= x"7fe0";
		when x"f8f" => sin_out <= x"7fe0";
		when x"f90" => sin_out <= x"7fe1";
		when x"f91" => sin_out <= x"7fe1";
		when x"f92" => sin_out <= x"7fe2";
		when x"f93" => sin_out <= x"7fe2";
		when x"f94" => sin_out <= x"7fe3";
		when x"f95" => sin_out <= x"7fe3";
		when x"f96" => sin_out <= x"7fe4";
		when x"f97" => sin_out <= x"7fe4";
		when x"f98" => sin_out <= x"7fe5";
		when x"f99" => sin_out <= x"7fe5";
		when x"f9a" => sin_out <= x"7fe6";
		when x"f9b" => sin_out <= x"7fe6";
		when x"f9c" => sin_out <= x"7fe7";
		when x"f9d" => sin_out <= x"7fe7";
		when x"f9e" => sin_out <= x"7fe8";
		when x"f9f" => sin_out <= x"7fe8";
		when x"fa0" => sin_out <= x"7fe9";
		when x"fa1" => sin_out <= x"7fe9";
		when x"fa2" => sin_out <= x"7fea";
		when x"fa3" => sin_out <= x"7fea";
		when x"fa4" => sin_out <= x"7feb";
		when x"fa5" => sin_out <= x"7feb";
		when x"fa6" => sin_out <= x"7feb";
		when x"fa7" => sin_out <= x"7fec";
		when x"fa8" => sin_out <= x"7fec";
		when x"fa9" => sin_out <= x"7fed";
		when x"faa" => sin_out <= x"7fed";
		when x"fab" => sin_out <= x"7fee";
		when x"fac" => sin_out <= x"7fee";
		when x"fad" => sin_out <= x"7fee";
		when x"fae" => sin_out <= x"7fef";
		when x"faf" => sin_out <= x"7fef";
		when x"fb0" => sin_out <= x"7ff0";
		when x"fb1" => sin_out <= x"7ff0";
		when x"fb2" => sin_out <= x"7ff0";
		when x"fb3" => sin_out <= x"7ff1";
		when x"fb4" => sin_out <= x"7ff1";
		when x"fb5" => sin_out <= x"7ff1";
		when x"fb6" => sin_out <= x"7ff2";
		when x"fb7" => sin_out <= x"7ff2";
		when x"fb8" => sin_out <= x"7ff3";
		when x"fb9" => sin_out <= x"7ff3";
		when x"fba" => sin_out <= x"7ff3";
		when x"fbb" => sin_out <= x"7ff4";
		when x"fbc" => sin_out <= x"7ff4";
		when x"fbd" => sin_out <= x"7ff4";
		when x"fbe" => sin_out <= x"7ff5";
		when x"fbf" => sin_out <= x"7ff5";
		when x"fc0" => sin_out <= x"7ff5";
		when x"fc1" => sin_out <= x"7ff5";
		when x"fc2" => sin_out <= x"7ff6";
		when x"fc3" => sin_out <= x"7ff6";
		when x"fc4" => sin_out <= x"7ff6";
		when x"fc5" => sin_out <= x"7ff7";
		when x"fc6" => sin_out <= x"7ff7";
		when x"fc7" => sin_out <= x"7ff7";
		when x"fc8" => sin_out <= x"7ff7";
		when x"fc9" => sin_out <= x"7ff8";
		when x"fca" => sin_out <= x"7ff8";
		when x"fcb" => sin_out <= x"7ff8";
		when x"fcc" => sin_out <= x"7ff8";
		when x"fcd" => sin_out <= x"7ff9";
		when x"fce" => sin_out <= x"7ff9";
		when x"fcf" => sin_out <= x"7ff9";
		when x"fd0" => sin_out <= x"7ff9";
		when x"fd1" => sin_out <= x"7ffa";
		when x"fd2" => sin_out <= x"7ffa";
		when x"fd3" => sin_out <= x"7ffa";
		when x"fd4" => sin_out <= x"7ffa";
		when x"fd5" => sin_out <= x"7ffb";
		when x"fd6" => sin_out <= x"7ffb";
		when x"fd7" => sin_out <= x"7ffb";
		when x"fd8" => sin_out <= x"7ffb";
		when x"fd9" => sin_out <= x"7ffb";
		when x"fda" => sin_out <= x"7ffc";
		when x"fdb" => sin_out <= x"7ffc";
		when x"fdc" => sin_out <= x"7ffc";
		when x"fdd" => sin_out <= x"7ffc";
		when x"fde" => sin_out <= x"7ffc";
		when x"fdf" => sin_out <= x"7ffc";
		when x"fe0" => sin_out <= x"7ffd";
		when x"fe1" => sin_out <= x"7ffd";
		when x"fe2" => sin_out <= x"7ffd";
		when x"fe3" => sin_out <= x"7ffd";
		when x"fe4" => sin_out <= x"7ffd";
		when x"fe5" => sin_out <= x"7ffd";
		when x"fe6" => sin_out <= x"7ffd";
		when x"fe7" => sin_out <= x"7ffd";
		when x"fe8" => sin_out <= x"7ffe";
		when x"fe9" => sin_out <= x"7ffe";
		when x"fea" => sin_out <= x"7ffe";
		when x"feb" => sin_out <= x"7ffe";
		when x"fec" => sin_out <= x"7ffe";
		when x"fed" => sin_out <= x"7ffe";
		when x"fee" => sin_out <= x"7ffe";
		when x"fef" => sin_out <= x"7ffe";
		when x"ff0" => sin_out <= x"7ffe";
		when x"ff1" => sin_out <= x"7ffe";
		when x"ff2" => sin_out <= x"7fff";
		when x"ff3" => sin_out <= x"7fff";
		when x"ff4" => sin_out <= x"7fff";
		when x"ff5" => sin_out <= x"7fff";
		when x"ff6" => sin_out <= x"7fff";
		when x"ff7" => sin_out <= x"7fff";
		when x"ff8" => sin_out <= x"7fff";
		when x"ff9" => sin_out <= x"7fff";
		when x"ffa" => sin_out <= x"7fff";
		when x"ffb" => sin_out <= x"7fff";
		when x"ffc" => sin_out <= x"7fff";
		when x"ffd" => sin_out <= x"7fff";
		when x"ffe" => sin_out <= x"7fff";
		when x"fff" => sin_out <= x"7fff";
		when others => null ;
	end case ;
end process ;

--***************************************************************--
reg_rom_data : process ( SysCLK_in )
begin
	if ( SysCLK_in'event and SysCLK_in = '1' ) then
		rom_data(14 downto 0) <= sin_out(14 downto 0) ;
	end if ;
end process ;

--***************************************************************--
phaseadrs_equ : process ( SysCLK_in )
begin
	if ( SysRST_in = '1' ) then
		dly1_phase_adrs <= "00" ;
	elsif ( SysCLK_in'event and SysCLK_in = '1' ) then
		dly1_phase_adrs <= phase_adrs ;				-- Pipeline compensation
	end if ;
end process ;

--***************************************************************--
sinout1_equ : process ( SysCLK_in )
begin
	if ( SysRST_in = '1' ) then
		reg_sin_out1 <= x"0000" ;
	elsif ( SysCLK_in'event and SysCLK_in = '1' ) then
		case dly1_phase_adrs is
			when "00" => reg_sin_out1 <= '0' & rom_data(14 downto 0) ;		-- + value
			when "01" => reg_sin_out1 <= '0' & rom_data(14 downto 0) ;		-- + value
			when "10" => reg_sin_out1 <= '1' & not rom_data(14 downto 0) ;		-- - value
			when "11" => reg_sin_out1 <= '1' & not rom_data(14 downto 0) ;		-- - value
			when others => null ;
		end case ;
	end if ;
end process ;

	dout1	<= reg_sin_out1		 after 1 ns ;

--***************************************************************--
sinout2_equ : process ( SysCLK_in )
begin
	if ( SysRST_in = '1' ) then
		reg_sin_out2 <= x"0000" ;
	elsif ( SysCLK_in'event and SysCLK_in = '1' ) then
		case dly1_phase_adrs is
			when "00" => reg_sin_out2 <= '1' & rom_data(14 downto 0) ;		-- + value
			when "01" => reg_sin_out2 <= '1' & rom_data(14 downto 0) ;		-- + value
			when "10" => reg_sin_out2 <= '0' & not rom_data(14 downto 0) ;		-- - value
			when "11" => reg_sin_out2 <= '0' & not rom_data(14 downto 0) ;		-- - value
			when others => null ;
		end case ;
	end if ;
end process ;

	dout2	<= reg_sin_out2		 after 1 ns ;

end Behavioral;
