
########## Tcl recorder starts at 05/15/09 14:23:05 ##########

set version "7.2"
set proj_dir "C:/marutsu/FPGA/MFPGA_LAT"
cd $proj_dir

# Get directory paths
set pver $version
regsub -all {\.} $pver {_} pver
set lscfile "lsc_"
append lscfile $pver ".ini"
set lsvini_dir [lindex [array get env LSC_INI_PATH] 1]
set lsvini_path [file join $lsvini_dir $lscfile]
if {[catch {set fid [open $lsvini_path]} msg]} {
	 puts "File Open Error: $lsvini_path"
	 return false
} else {set data [read $fid]; close $fid }
foreach line [split $data '\n'] { 
	set lline [string tolower $line]
	set lline [string trim $lline]
	if {[string compare $lline "\[paths\]"] == 0} { set path 1; continue}
	if {$path && [regexp {^\[} $lline]} {set path 0; break}
	if {$path && [regexp {^bin} $lline]} {set cpld_bin $line; continue}
	if {$path && [regexp {^fpgapath} $lline]} {set fpga_dir $line; continue}
	if {$path && [regexp {^fpgabinpath} $lline]} {set fpga_bin $line}}

set cpld_bin [string range $cpld_bin [expr [string first "=" $cpld_bin]+1] end]
regsub -all "\"" $cpld_bin "" cpld_bin
set cpld_bin [file join $cpld_bin]
set install_dir [string range $cpld_bin 0 [expr [string first "ispcpld" $cpld_bin]-2]]
regsub -all "\"" $install_dir "" install_dir
set install_dir [file join $install_dir]
set fpga_dir [string range $fpga_dir [expr [string first "=" $fpga_dir]+1] end]
regsub -all "\"" $fpga_dir "" fpga_dir
set fpga_dir [file join $fpga_dir]
set fpga_bin [string range $fpga_bin [expr [string first "=" $fpga_bin]+1] end]
regsub -all "\"" $fpga_bin "" fpga_bin
set fpga_bin [file join $fpga_bin]

if {[string match "*$fpga_bin;*" $env(PATH)] == 0 } {
   set env(PATH) "$fpga_bin;$env(PATH)" }

if {[string match "*$cpld_bin;*" $env(PATH)] == 0 } {
   set env(PATH) "$cpld_bin;$env(PATH)" }

lappend auto_path [file join $install_dir "ispcpld" "tcltk" "lib" "ispwidget" "runproc"]
package require runcmd

# Commands to make the Process: 
# Generate Data File (JEDEC)
if [catch {open mfpga_lat.rvp w} rspFile] {
	puts stderr "Cannot create response file mfpga_lat.rvp: $rspFile"
} else {
	puts $rspFile "STYFILENAME=mfpga_lat.sty
PROJECT=mfpga_lat
ENTRY=Schematic/VHDL
WORKING_PATH=$proj_dir
MODULE=MFPGA_ALT
TOP_FILE=./hdl/mod_top.vhd
EDF_FILE_LIST=./hdl/mod_freq_div.vhd ./hdl/mod_uart_tx.vhd ./hdl/sintable.vhd ./hdl/mod_wavegen.vhd ./hdl/mod_pushsw_sync.vhd ./hdl/mod_pushsw_sync4.vhd ./hdl/mod_7seg.vhd ./hdl/mod_7seg_x4.vhd ./hdl/mod_top.vhd
VHDL_FILE_LIST=./hdl/mod_freq_div.vhd ./hdl/mod_uart_tx.vhd ./hdl/sintable.vhd ./hdl/mod_wavegen.vhd ./hdl/mod_pushsw_sync.vhd ./hdl/mod_pushsw_sync4.vhd ./hdl/mod_7seg.vhd ./hdl/mod_7seg_x4.vhd ./hdl/mod_top.vhd
VERILOG_FILE_LIST=./hdl/mod_freq_div.vhd ./hdl/mod_uart_tx.vhd ./hdl/sintable.vhd ./hdl/mod_wavegen.vhd ./hdl/mod_pushsw_sync.vhd ./hdl/mod_pushsw_sync4.vhd ./hdl/mod_7seg.vhd ./hdl/mod_7seg_x4.vhd ./hdl/mod_top.vhd
DEVICEPART=LFXP2-5E-5TN144C
"
	close $rspFile
}
if [catch {open MFPGA_ALT.cmd w} rspFile] {
	puts stderr "Cannot create response file MFPGA_ALT.cmd: $rspFile"
} else {
	puts $rspFile "STYFILENAME: mfpga_lat.sty
PROJECT: MFPGA_ALT
WORKING_PATH: \"$proj_dir\"
MODULE: work.MFPGA_ALT
VHDL_FILE_LIST: \"$install_dir/ispcpld/../cae_library/synthesis/vhdl/XP2.vhd\" ./hdl/mod_freq_div.vhd ./hdl/mod_uart_tx.vhd ./hdl/sintable.vhd ./hdl/mod_wavegen.vhd ./hdl/mod_pushsw_sync.vhd ./hdl/mod_pushsw_sync4.vhd ./hdl/mod_7seg.vhd ./hdl/mod_7seg_x4.vhd ./hdl/mod_top.vhd
OUTPUT_FILE_NAME: MFPGA_ALT
SUFFIX_NAME: edi
WRITE_PRF: false
FREQUENCY:  200
FANOUT_LIMIT:  100
DISABLE_IO_INSERTION: false
FORCE_GSR: false
SPEED_GRADE: -5
SYMBOLIC_FSM_COMPILER: true
NUM_CRITICAL_PATHS:   3
AUTO_CONSTRAIN_IO: true
NUM_STARTEND_POINTS:   0
COMPILER_COMPATIBLE: true
RETIMING: none
RESOURCE_SHARING: true
DEFAULT_ENUM_ENCODING: default
fixgatedclocks:  3
fixgeneratedclocks:  3
Vlog_std_v2001: V2001
DUP: false
ARRANGE_VHDL_FILES: true
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/Synpwrap\" -dyn -e MFPGA_ALT -target LATTICE-XP2 -part LFXP2_5E -notPro -oem"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$fpga_bin/edif2ngd\" -l LatticeXP2 -d LFXP2-5E \"MFPGA_ALT.edi\" \"MFPGA_ALT.ngo\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$fpga_bin/edfupdate\" -t \"mfpga_lat.tcy\" -w \"MFPGA_ALT.ngo\" -m \"MFPGA_ALT.ngo\" \"mfpga_lat.ngx\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$fpga_bin/ngdbuild\" -a LatticeXP2 -d LFXP2-5E -p \"$fpga_dir/mg5a00/data\" \"MFPGA_ALT.ngo\" \"mfpga_lat.ngd\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$fpga_bin/map\" -a LatticeXP2 -p LFXP2-5E -t TQFP144 -s 5 \"mfpga_lat.ngd\" -o \"mfpga_lat_map.ncd\" -mp \"mfpga_lat.mrp\" \"mfpga_lat.lpf\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [catch {open mfpga_lat.cm2 w} rspFile] {
	puts stderr "Cannot create response file mfpga_lat.cm2: $rspFile"
} else {
	puts $rspFile "-t mfpga_lat.mt
-to mfpga_lat.tw1
-o mfpga_lat.tcm
-log mfpga_lat.log
-pr mfpga_lat.prf
-rpt mfpga_lat.mrp
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/checkpoint\" -m -f \"mfpga_lat.cmm\" -f \"mfpga_lat.cm2\" -arch LatticeXP2 \"mfpga_lat_map.ncd\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
file delete mfpga_lat.cm2
if [catch {open mfpga_lat.p2t w} rspFile] {
	puts stderr "Cannot create response file mfpga_lat.p2t: $rspFile"
} else {
	puts $rspFile "-w
-i 6
-l 5
-n 1
-t 1
-s 1
-c 0
-e 0
-exp parCDP=Auto
-exp parCDR=1
-exp parPlcInLimit=0
-exp parPlcInNeighborSize=1
-exp parPathBased=OFF
-exp parHold=OFF
"
	close $rspFile
}
if [catch {open mfpga_lat.p3t w} rspFile] {
	puts stderr "Cannot create response file mfpga_lat.p3t: $rspFile"
} else {
	puts $rspFile "-rem
-log mfpga_lat.log
-o mfpga_lat_mp.par
-pr mfpga_lat.prf
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/multipar\" -p mfpga_lat.p2t -f \"mfpga_lat.p3t\" \"mfpga_lat_map.ncd\" \"mfpga_lat.ncd\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [catch {open mfpga_lat.cm2 w} rspFile] {
	puts stderr "Cannot create response file mfpga_lat.cm2: $rspFile"
} else {
	puts $rspFile "-t mfpga_lat.pt
-to mfpga_lat.twr
-o mfpga_lat.tcp
-log mfpga_lat.log
-pr mfpga_lat.prf
-rpt mfpga_lat.par
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/checkpoint\" -p -f \"mfpga_lat.cmp\" -f \"mfpga_lat.cm2\" -arch LatticeXP2 \"mfpga_lat.ncd\" -l 60"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
file delete mfpga_lat.cm2
if [catch {open mfpga_lat.t2b w} rspFile] {
	puts stderr "Cannot create response file mfpga_lat.t2b: $rspFile"
} else {
	puts $rspFile "-g DisableUES:FALSE
-g RamCfg:Reset
"
	close $rspFile
}
if [runCmd "\"$fpga_bin/bitgen\" -f \"mfpga_lat.t2b\" -w \"mfpga_lat.ncd\" -jedec -e -s \"mfpga_lat.sec\" -k \"mfpga_lat.bek\" \"mfpga_lat.prf\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 05/15/09 14:23:05 ###########


########## Tcl recorder starts at 05/18/09 17:00:09 ##########

# Commands to make the Process: 
# Generate Data File (JEDEC)
if [catch {open mfpga_lat.rvp w} rspFile] {
	puts stderr "Cannot create response file mfpga_lat.rvp: $rspFile"
} else {
	puts $rspFile "STYFILENAME=mfpga_lat.sty
PROJECT=mfpga_lat
ENTRY=Schematic/VHDL
WORKING_PATH=$proj_dir
MODULE=MFPGA_ALT
TOP_FILE=./hdl/mod_top.vhd
EDF_FILE_LIST=./hdl/mod_freq_div.vhd ./hdl/mod_uart_tx.vhd ./hdl/sintable.vhd ./hdl/mod_wavegen.vhd ./hdl/mod_pushsw_sync.vhd ./hdl/mod_pushsw_sync4.vhd ./hdl/mod_7seg.vhd ./hdl/mod_7seg_x4.vhd ./hdl/mod_top.vhd
VHDL_FILE_LIST=./hdl/mod_freq_div.vhd ./hdl/mod_uart_tx.vhd ./hdl/sintable.vhd ./hdl/mod_wavegen.vhd ./hdl/mod_pushsw_sync.vhd ./hdl/mod_pushsw_sync4.vhd ./hdl/mod_7seg.vhd ./hdl/mod_7seg_x4.vhd ./hdl/mod_top.vhd
VERILOG_FILE_LIST=./hdl/mod_freq_div.vhd ./hdl/mod_uart_tx.vhd ./hdl/sintable.vhd ./hdl/mod_wavegen.vhd ./hdl/mod_pushsw_sync.vhd ./hdl/mod_pushsw_sync4.vhd ./hdl/mod_7seg.vhd ./hdl/mod_7seg_x4.vhd ./hdl/mod_top.vhd
DEVICEPART=LFXP2-5E-5TN144C
"
	close $rspFile
}
if [catch {open MFPGA_ALT.cmd w} rspFile] {
	puts stderr "Cannot create response file MFPGA_ALT.cmd: $rspFile"
} else {
	puts $rspFile "STYFILENAME: mfpga_lat.sty
PROJECT: MFPGA_ALT
WORKING_PATH: \"$proj_dir\"
MODULE: work.MFPGA_ALT
VHDL_FILE_LIST: \"$install_dir/ispcpld/../cae_library/synthesis/vhdl/XP2.vhd\" ./hdl/mod_freq_div.vhd ./hdl/mod_uart_tx.vhd ./hdl/sintable.vhd ./hdl/mod_wavegen.vhd ./hdl/mod_pushsw_sync.vhd ./hdl/mod_pushsw_sync4.vhd ./hdl/mod_7seg.vhd ./hdl/mod_7seg_x4.vhd ./hdl/mod_top.vhd
OUTPUT_FILE_NAME: MFPGA_ALT
SUFFIX_NAME: edi
WRITE_PRF: false
FREQUENCY:  200
FANOUT_LIMIT:  100
DISABLE_IO_INSERTION: false
FORCE_GSR: false
SPEED_GRADE: -5
SYMBOLIC_FSM_COMPILER: true
NUM_CRITICAL_PATHS:   3
AUTO_CONSTRAIN_IO: true
NUM_STARTEND_POINTS:   0
COMPILER_COMPATIBLE: true
RETIMING: none
RESOURCE_SHARING: true
DEFAULT_ENUM_ENCODING: default
fixgatedclocks:  3
fixgeneratedclocks:  3
Vlog_std_v2001: V2001
DUP: false
ARRANGE_VHDL_FILES: true
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/Synpwrap\" -dyn -e MFPGA_ALT -target LATTICE-XP2 -part LFXP2_5E -notPro -oem"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$fpga_bin/edif2ngd\" -l LatticeXP2 -d LFXP2-5E \"MFPGA_ALT.edi\" \"MFPGA_ALT.ngo\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$fpga_bin/edfupdate\" -t \"mfpga_lat.tcy\" -w \"MFPGA_ALT.ngo\" -m \"MFPGA_ALT.ngo\" \"mfpga_lat.ngx\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$fpga_bin/ngdbuild\" -a LatticeXP2 -d LFXP2-5E -p \"$fpga_dir/mg5a00/data\" \"MFPGA_ALT.ngo\" \"mfpga_lat.ngd\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$fpga_bin/map\" -a LatticeXP2 -p LFXP2-5E -t TQFP144 -s 5 \"mfpga_lat.ngd\" -o \"mfpga_lat_map.ncd\" -mp \"mfpga_lat.mrp\" \"mfpga_lat.lpf\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [catch {open mfpga_lat.cm2 w} rspFile] {
	puts stderr "Cannot create response file mfpga_lat.cm2: $rspFile"
} else {
	puts $rspFile "-t mfpga_lat.mt
-to mfpga_lat.tw1
-o mfpga_lat.tcm
-log mfpga_lat.log
-pr mfpga_lat.prf
-rpt mfpga_lat.mrp
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/checkpoint\" -m -f \"mfpga_lat.cmm\" -f \"mfpga_lat.cm2\" -arch LatticeXP2 \"mfpga_lat_map.ncd\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
file delete mfpga_lat.cm2
if [catch {open mfpga_lat.p2t w} rspFile] {
	puts stderr "Cannot create response file mfpga_lat.p2t: $rspFile"
} else {
	puts $rspFile "-w
-i 6
-l 5
-n 1
-t 1
-s 1
-c 0
-e 0
-exp parCDP=Auto
-exp parCDR=1
-exp parPlcInLimit=0
-exp parPlcInNeighborSize=1
-exp parPathBased=OFF
-exp parHold=OFF
"
	close $rspFile
}
if [catch {open mfpga_lat.p3t w} rspFile] {
	puts stderr "Cannot create response file mfpga_lat.p3t: $rspFile"
} else {
	puts $rspFile "-rem
-log mfpga_lat.log
-o mfpga_lat_mp.par
-pr mfpga_lat.prf
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/multipar\" -p mfpga_lat.p2t -f \"mfpga_lat.p3t\" \"mfpga_lat_map.ncd\" \"mfpga_lat.ncd\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [catch {open mfpga_lat.cm2 w} rspFile] {
	puts stderr "Cannot create response file mfpga_lat.cm2: $rspFile"
} else {
	puts $rspFile "-t mfpga_lat.pt
-to mfpga_lat.twr
-o mfpga_lat.tcp
-log mfpga_lat.log
-pr mfpga_lat.prf
-rpt mfpga_lat.par
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/checkpoint\" -p -f \"mfpga_lat.cmp\" -f \"mfpga_lat.cm2\" -arch LatticeXP2 \"mfpga_lat.ncd\" -l 60"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
file delete mfpga_lat.cm2
if [catch {open mfpga_lat.t2b w} rspFile] {
	puts stderr "Cannot create response file mfpga_lat.t2b: $rspFile"
} else {
	puts $rspFile "-g DisableUES:FALSE
-g RamCfg:Reset
"
	close $rspFile
}
if [runCmd "\"$fpga_bin/bitgen\" -f \"mfpga_lat.t2b\" -w \"mfpga_lat.ncd\" -jedec -e -s \"mfpga_lat.sec\" -k \"mfpga_lat.bek\" \"mfpga_lat.prf\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 05/18/09 17:00:09 ###########


########## Tcl recorder starts at 05/18/09 17:04:12 ##########

# Commands to make the Process: 
# Generate Data File (JEDEC)
if [catch {open mfpga_lat.rvp w} rspFile] {
	puts stderr "Cannot create response file mfpga_lat.rvp: $rspFile"
} else {
	puts $rspFile "STYFILENAME=mfpga_lat.sty
PROJECT=mfpga_lat
ENTRY=Schematic/VHDL
WORKING_PATH=$proj_dir
MODULE=Module_TOP
TOP_FILE=./hdl/mod_top.vhd
EDF_FILE_LIST=./hdl/mod_freq_div.vhd ./hdl/mod_uart_tx.vhd ./hdl/sintable.vhd ./hdl/mod_wavegen.vhd ./hdl/mod_pushsw_sync.vhd ./hdl/mod_pushsw_sync4.vhd ./hdl/mod_7seg.vhd ./hdl/mod_7seg_x4.vhd ./hdl/mod_top.vhd
VHDL_FILE_LIST=./hdl/mod_freq_div.vhd ./hdl/mod_uart_tx.vhd ./hdl/sintable.vhd ./hdl/mod_wavegen.vhd ./hdl/mod_pushsw_sync.vhd ./hdl/mod_pushsw_sync4.vhd ./hdl/mod_7seg.vhd ./hdl/mod_7seg_x4.vhd ./hdl/mod_top.vhd
VERILOG_FILE_LIST=./hdl/mod_freq_div.vhd ./hdl/mod_uart_tx.vhd ./hdl/sintable.vhd ./hdl/mod_wavegen.vhd ./hdl/mod_pushsw_sync.vhd ./hdl/mod_pushsw_sync4.vhd ./hdl/mod_7seg.vhd ./hdl/mod_7seg_x4.vhd ./hdl/mod_top.vhd
DEVICEPART=LFXP2-5E-5TN144C
"
	close $rspFile
}
if [catch {open Module_TOP.cmd w} rspFile] {
	puts stderr "Cannot create response file Module_TOP.cmd: $rspFile"
} else {
	puts $rspFile "STYFILENAME: mfpga_lat.sty
PROJECT: Module_TOP
WORKING_PATH: \"$proj_dir\"
MODULE: work.Module_TOP
VHDL_FILE_LIST: \"$install_dir/ispcpld/../cae_library/synthesis/vhdl/XP2.vhd\" ./hdl/mod_freq_div.vhd ./hdl/mod_uart_tx.vhd ./hdl/sintable.vhd ./hdl/mod_wavegen.vhd ./hdl/mod_pushsw_sync.vhd ./hdl/mod_pushsw_sync4.vhd ./hdl/mod_7seg.vhd ./hdl/mod_7seg_x4.vhd ./hdl/mod_top.vhd
OUTPUT_FILE_NAME: Module_TOP
SUFFIX_NAME: edi
WRITE_PRF: false
FREQUENCY:  200
FANOUT_LIMIT:  100
DISABLE_IO_INSERTION: false
FORCE_GSR: false
SPEED_GRADE: -5
SYMBOLIC_FSM_COMPILER: true
NUM_CRITICAL_PATHS:   3
AUTO_CONSTRAIN_IO: true
NUM_STARTEND_POINTS:   0
COMPILER_COMPATIBLE: true
RETIMING: none
RESOURCE_SHARING: true
DEFAULT_ENUM_ENCODING: default
fixgatedclocks:  3
fixgeneratedclocks:  3
Vlog_std_v2001: V2001
DUP: false
ARRANGE_VHDL_FILES: true
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/Synpwrap\" -dyn -e Module_TOP -target LATTICE-XP2 -part LFXP2_5E -notPro -oem"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$fpga_bin/edif2ngd\" -l LatticeXP2 -d LFXP2-5E \"Module_TOP.edi\" \"Module_TOP.ngo\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$fpga_bin/edfupdate\" -t \"mfpga_lat.tcy\" -w \"Module_TOP.ngo\" -m \"Module_TOP.ngo\" \"mfpga_lat.ngx\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$fpga_bin/ngdbuild\" -a LatticeXP2 -d LFXP2-5E -p \"$fpga_dir/mg5a00/data\" \"Module_TOP.ngo\" \"mfpga_lat.ngd\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$fpga_bin/map\" -a LatticeXP2 -p LFXP2-5E -t TQFP144 -s 5 \"mfpga_lat.ngd\" -o \"mfpga_lat_map.ncd\" -mp \"mfpga_lat.mrp\" \"mfpga_lat.lpf\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [catch {open mfpga_lat.cm2 w} rspFile] {
	puts stderr "Cannot create response file mfpga_lat.cm2: $rspFile"
} else {
	puts $rspFile "-t mfpga_lat.mt
-to mfpga_lat.tw1
-o mfpga_lat.tcm
-log mfpga_lat.log
-pr mfpga_lat.prf
-rpt mfpga_lat.mrp
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/checkpoint\" -m -f \"mfpga_lat.cmm\" -f \"mfpga_lat.cm2\" -arch LatticeXP2 \"mfpga_lat_map.ncd\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
file delete mfpga_lat.cm2
if [catch {open mfpga_lat.p2t w} rspFile] {
	puts stderr "Cannot create response file mfpga_lat.p2t: $rspFile"
} else {
	puts $rspFile "-w
-i 6
-l 5
-n 1
-t 1
-s 1
-c 0
-e 0
-exp parCDP=Auto
-exp parCDR=1
-exp parPlcInLimit=0
-exp parPlcInNeighborSize=1
-exp parPathBased=OFF
-exp parHold=OFF
"
	close $rspFile
}
if [catch {open mfpga_lat.p3t w} rspFile] {
	puts stderr "Cannot create response file mfpga_lat.p3t: $rspFile"
} else {
	puts $rspFile "-rem
-log mfpga_lat.log
-o mfpga_lat_mp.par
-pr mfpga_lat.prf
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/multipar\" -p mfpga_lat.p2t -f \"mfpga_lat.p3t\" \"mfpga_lat_map.ncd\" \"mfpga_lat.ncd\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [catch {open mfpga_lat.cm2 w} rspFile] {
	puts stderr "Cannot create response file mfpga_lat.cm2: $rspFile"
} else {
	puts $rspFile "-t mfpga_lat.pt
-to mfpga_lat.twr
-o mfpga_lat.tcp
-log mfpga_lat.log
-pr mfpga_lat.prf
-rpt mfpga_lat.par
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/checkpoint\" -p -f \"mfpga_lat.cmp\" -f \"mfpga_lat.cm2\" -arch LatticeXP2 \"mfpga_lat.ncd\" -l 60"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
file delete mfpga_lat.cm2
if [catch {open mfpga_lat.t2b w} rspFile] {
	puts stderr "Cannot create response file mfpga_lat.t2b: $rspFile"
} else {
	puts $rspFile "-g DisableUES:FALSE
-g RamCfg:Reset
"
	close $rspFile
}
if [runCmd "\"$fpga_bin/bitgen\" -f \"mfpga_lat.t2b\" -w \"mfpga_lat.ncd\" -jedec -e -s \"mfpga_lat.sec\" -k \"mfpga_lat.bek\" \"mfpga_lat.prf\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 05/18/09 17:04:12 ###########


########## Tcl recorder starts at 05/18/09 19:09:00 ##########

# Commands to make the Process: 
# Build Database
if [catch {open mfpga_lat.rvp w} rspFile] {
	puts stderr "Cannot create response file mfpga_lat.rvp: $rspFile"
} else {
	puts $rspFile "STYFILENAME=mfpga_lat.sty
PROJECT=mfpga_lat
ENTRY=Schematic/VHDL
WORKING_PATH=$proj_dir
MODULE=Module_TOP
TOP_FILE=./hdl/mod_top.vhd
EDF_FILE_LIST=./hdl/mod_freq_div.vhd ./hdl/mod_uart_tx.vhd ./hdl/sintable.vhd ./hdl/mod_wavegen.vhd ./hdl/mod_pushsw_sync.vhd ./hdl/mod_pushsw_sync4.vhd ./hdl/mod_7seg.vhd ./hdl/mod_7seg_x4.vhd ./hdl/mod_top.vhd
VHDL_FILE_LIST=./hdl/mod_freq_div.vhd ./hdl/mod_uart_tx.vhd ./hdl/sintable.vhd ./hdl/mod_wavegen.vhd ./hdl/mod_pushsw_sync.vhd ./hdl/mod_pushsw_sync4.vhd ./hdl/mod_7seg.vhd ./hdl/mod_7seg_x4.vhd ./hdl/mod_top.vhd
VERILOG_FILE_LIST=./hdl/mod_freq_div.vhd ./hdl/mod_uart_tx.vhd ./hdl/sintable.vhd ./hdl/mod_wavegen.vhd ./hdl/mod_pushsw_sync.vhd ./hdl/mod_pushsw_sync4.vhd ./hdl/mod_7seg.vhd ./hdl/mod_7seg_x4.vhd ./hdl/mod_top.vhd
DEVICEPART=LFXP2-5E-5TN144C
"
	close $rspFile
}
if [catch {open Module_TOP.cmd w} rspFile] {
	puts stderr "Cannot create response file Module_TOP.cmd: $rspFile"
} else {
	puts $rspFile "STYFILENAME: mfpga_lat.sty
PROJECT: Module_TOP
WORKING_PATH: \"$proj_dir\"
MODULE: work.Module_TOP
VHDL_FILE_LIST: \"$install_dir/ispcpld/../cae_library/synthesis/vhdl/XP2.vhd\" ./hdl/mod_freq_div.vhd ./hdl/mod_uart_tx.vhd ./hdl/sintable.vhd ./hdl/mod_wavegen.vhd ./hdl/mod_pushsw_sync.vhd ./hdl/mod_pushsw_sync4.vhd ./hdl/mod_7seg.vhd ./hdl/mod_7seg_x4.vhd ./hdl/mod_top.vhd
OUTPUT_FILE_NAME: Module_TOP
SUFFIX_NAME: edi
WRITE_PRF: false
FREQUENCY:  200
FANOUT_LIMIT:  100
DISABLE_IO_INSERTION: false
FORCE_GSR: false
SPEED_GRADE: -5
SYMBOLIC_FSM_COMPILER: true
NUM_CRITICAL_PATHS:   3
AUTO_CONSTRAIN_IO: true
NUM_STARTEND_POINTS:   0
COMPILER_COMPATIBLE: true
RETIMING: none
RESOURCE_SHARING: true
DEFAULT_ENUM_ENCODING: default
fixgatedclocks:  3
fixgeneratedclocks:  3
Vlog_std_v2001: V2001
DUP: false
ARRANGE_VHDL_FILES: true
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/Synpwrap\" -dyn -e Module_TOP -target LATTICE-XP2 -part LFXP2_5E -notPro -oem"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$fpga_bin/edif2ngd\" -l LatticeXP2 -d LFXP2-5E \"Module_TOP.edi\" \"Module_TOP.ngo\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$fpga_bin/edfupdate\" -t \"mfpga_lat.tcy\" -w \"Module_TOP.ngo\" -m \"Module_TOP.ngo\" \"mfpga_lat.ngx\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$fpga_bin/ngdbuild\" -a LatticeXP2 -d LFXP2-5E -p \"$fpga_dir/mg5a00/data\" \"Module_TOP.ngo\" \"mfpga_lat.ngd\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 05/18/09 19:09:00 ###########


########## Tcl recorder starts at 05/18/09 19:09:44 ##########

# Commands to make the Process: 
# Generate Data File (JEDEC)
if [runCmd "\"$fpga_bin/map\" -a LatticeXP2 -p LFXP2-5E -t TQFP144 -s 5 \"mfpga_lat.ngd\" -o \"mfpga_lat_map.ncd\" -mp \"mfpga_lat.mrp\" \"mfpga_lat.lpf\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [catch {open mfpga_lat.cm2 w} rspFile] {
	puts stderr "Cannot create response file mfpga_lat.cm2: $rspFile"
} else {
	puts $rspFile "-t mfpga_lat.mt
-to mfpga_lat.tw1
-o mfpga_lat.tcm
-log mfpga_lat.log
-pr mfpga_lat.prf
-rpt mfpga_lat.mrp
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/checkpoint\" -m -f \"mfpga_lat.cmm\" -f \"mfpga_lat.cm2\" -arch LatticeXP2 \"mfpga_lat_map.ncd\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
file delete mfpga_lat.cm2
if [catch {open mfpga_lat.p2t w} rspFile] {
	puts stderr "Cannot create response file mfpga_lat.p2t: $rspFile"
} else {
	puts $rspFile "-w
-i 6
-l 5
-n 1
-t 1
-s 1
-c 0
-e 0
-exp parCDP=Auto
-exp parCDR=1
-exp parPlcInLimit=0
-exp parPlcInNeighborSize=1
-exp parPathBased=OFF
-exp parHold=OFF
"
	close $rspFile
}
if [catch {open mfpga_lat.p3t w} rspFile] {
	puts stderr "Cannot create response file mfpga_lat.p3t: $rspFile"
} else {
	puts $rspFile "-rem
-log mfpga_lat.log
-o mfpga_lat_mp.par
-pr mfpga_lat.prf
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/multipar\" -p mfpga_lat.p2t -f \"mfpga_lat.p3t\" \"mfpga_lat_map.ncd\" \"mfpga_lat.ncd\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [catch {open mfpga_lat.cm2 w} rspFile] {
	puts stderr "Cannot create response file mfpga_lat.cm2: $rspFile"
} else {
	puts $rspFile "-t mfpga_lat.pt
-to mfpga_lat.twr
-o mfpga_lat.tcp
-log mfpga_lat.log
-pr mfpga_lat.prf
-rpt mfpga_lat.par
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/checkpoint\" -p -f \"mfpga_lat.cmp\" -f \"mfpga_lat.cm2\" -arch LatticeXP2 \"mfpga_lat.ncd\" -l 60"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
file delete mfpga_lat.cm2
if [catch {open mfpga_lat.t2b w} rspFile] {
	puts stderr "Cannot create response file mfpga_lat.t2b: $rspFile"
} else {
	puts $rspFile "-g DisableUES:FALSE
-g RamCfg:Reset
"
	close $rspFile
}
if [runCmd "\"$fpga_bin/bitgen\" -f \"mfpga_lat.t2b\" -w \"mfpga_lat.ncd\" -jedec -e -s \"mfpga_lat.sec\" -k \"mfpga_lat.bek\" \"mfpga_lat.prf\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 05/18/09 19:09:44 ###########


########## Tcl recorder starts at 05/18/09 20:08:16 ##########

# Commands to make the Process: 
# Design Planner (Pre-Map)
if [catch {open mfpga_lat.rvp w} rspFile] {
	puts stderr "Cannot create response file mfpga_lat.rvp: $rspFile"
} else {
	puts $rspFile "STYFILENAME=mfpga_lat.sty
PROJECT=mfpga_lat
ENTRY=Schematic/VHDL
WORKING_PATH=$proj_dir
MODULE=Module_TOP
TOP_FILE=./hdl/mod_top.vhd
EDF_FILE_LIST=./hdl/mod_freq_div.vhd ./hdl/mod_uart_tx.vhd ./hdl/sintable.vhd ./hdl/mod_wavegen.vhd ./hdl/mod_pushsw_sync.vhd ./hdl/mod_pushsw_sync4.vhd ./hdl/mod_7seg.vhd ./hdl/mod_7seg_x4.vhd ./hdl/mod_top.vhd
VHDL_FILE_LIST=./hdl/mod_freq_div.vhd ./hdl/mod_uart_tx.vhd ./hdl/sintable.vhd ./hdl/mod_wavegen.vhd ./hdl/mod_pushsw_sync.vhd ./hdl/mod_pushsw_sync4.vhd ./hdl/mod_7seg.vhd ./hdl/mod_7seg_x4.vhd ./hdl/mod_top.vhd
VERILOG_FILE_LIST=./hdl/mod_freq_div.vhd ./hdl/mod_uart_tx.vhd ./hdl/sintable.vhd ./hdl/mod_wavegen.vhd ./hdl/mod_pushsw_sync.vhd ./hdl/mod_pushsw_sync4.vhd ./hdl/mod_7seg.vhd ./hdl/mod_7seg_x4.vhd ./hdl/mod_top.vhd
DEVICEPART=LFXP2-5E-5TN144C
"
	close $rspFile
}
if [catch {open Module_TOP.cmd w} rspFile] {
	puts stderr "Cannot create response file Module_TOP.cmd: $rspFile"
} else {
	puts $rspFile "STYFILENAME: mfpga_lat.sty
PROJECT: Module_TOP
WORKING_PATH: \"$proj_dir\"
MODULE: work.Module_TOP
VHDL_FILE_LIST: \"$install_dir/ispcpld/../cae_library/synthesis/vhdl/XP2.vhd\" ./hdl/mod_freq_div.vhd ./hdl/mod_uart_tx.vhd ./hdl/sintable.vhd ./hdl/mod_wavegen.vhd ./hdl/mod_pushsw_sync.vhd ./hdl/mod_pushsw_sync4.vhd ./hdl/mod_7seg.vhd ./hdl/mod_7seg_x4.vhd ./hdl/mod_top.vhd
OUTPUT_FILE_NAME: Module_TOP
SUFFIX_NAME: edi
WRITE_PRF: false
FREQUENCY:  200
FANOUT_LIMIT:  100
DISABLE_IO_INSERTION: false
FORCE_GSR: false
SPEED_GRADE: -5
SYMBOLIC_FSM_COMPILER: true
NUM_CRITICAL_PATHS:   3
AUTO_CONSTRAIN_IO: true
NUM_STARTEND_POINTS:   0
COMPILER_COMPATIBLE: true
RETIMING: none
RESOURCE_SHARING: true
DEFAULT_ENUM_ENCODING: default
fixgatedclocks:  3
fixgeneratedclocks:  3
Vlog_std_v2001: V2001
DUP: false
ARRANGE_VHDL_FILES: true
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/Synpwrap\" -dyn -e Module_TOP -target LATTICE-XP2 -part LFXP2_5E -notPro -oem"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$fpga_bin/edif2ngd\" -l LatticeXP2 -d LFXP2-5E \"Module_TOP.edi\" \"Module_TOP.ngo\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$fpga_bin/edfupdate\" -t \"mfpga_lat.tcy\" -w \"Module_TOP.ngo\" -m \"Module_TOP.ngo\" \"mfpga_lat.ngx\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$fpga_bin/ngdbuild\" -a LatticeXP2 -d LFXP2-5E -p \"$fpga_dir/mg5a00/data\" \"Module_TOP.ngo\" \"mfpga_lat.ngd\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
# Application to view the Process: 
# Design Planner (Pre-Map)
if [catch {open lattice.rsb w} rspFile] {
	puts stderr "Cannot create response file lattice.rsb: $rspFile"
} else {
	puts $rspFile "-inp \"mfpga_lat.ngd\" -dir \"$proj_dir\" -prj \"mfpga_lat\" -gui -touch ngd -a LatticeXP2 -p LFXP2-5E -t TQFP144 -s 5 -lpf \"mfpga_lat.lpf\" -msg \"Pre-Map Design Floorplan\"
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/flmainappw\" @lattice.rsb"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 05/18/09 20:08:16 ###########


########## Tcl recorder starts at 05/19/09 15:09:10 ##########

# Commands to make the Process: 
# Generate Data File (JEDEC)
if [catch {open mfpga_lat.rvp w} rspFile] {
	puts stderr "Cannot create response file mfpga_lat.rvp: $rspFile"
} else {
	puts $rspFile "STYFILENAME=mfpga_lat.sty
PROJECT=mfpga_lat
ENTRY=Schematic/VHDL
WORKING_PATH=$proj_dir
MODULE=Module_TOP
TOP_FILE=./hdl/mod_top.vhd
EDF_FILE_LIST=./hdl/mod_freq_div.vhd ./hdl/mod_uart_tx.vhd ./hdl/sintable.vhd ./hdl/mod_wavegen.vhd ./hdl/mod_pushsw_sync.vhd ./hdl/mod_pushsw_sync4.vhd ./hdl/mod_7seg.vhd ./hdl/mod_7seg_x4.vhd ./hdl/mod_top.vhd
VHDL_FILE_LIST=./hdl/mod_freq_div.vhd ./hdl/mod_uart_tx.vhd ./hdl/sintable.vhd ./hdl/mod_wavegen.vhd ./hdl/mod_pushsw_sync.vhd ./hdl/mod_pushsw_sync4.vhd ./hdl/mod_7seg.vhd ./hdl/mod_7seg_x4.vhd ./hdl/mod_top.vhd
VERILOG_FILE_LIST=./hdl/mod_freq_div.vhd ./hdl/mod_uart_tx.vhd ./hdl/sintable.vhd ./hdl/mod_wavegen.vhd ./hdl/mod_pushsw_sync.vhd ./hdl/mod_pushsw_sync4.vhd ./hdl/mod_7seg.vhd ./hdl/mod_7seg_x4.vhd ./hdl/mod_top.vhd
DEVICEPART=LFXP2-5E-5TN144C
"
	close $rspFile
}
if [catch {open Module_TOP.cmd w} rspFile] {
	puts stderr "Cannot create response file Module_TOP.cmd: $rspFile"
} else {
	puts $rspFile "STYFILENAME: mfpga_lat.sty
PROJECT: Module_TOP
WORKING_PATH: \"$proj_dir\"
MODULE: work.Module_TOP
VHDL_FILE_LIST: \"$install_dir/ispcpld/../cae_library/synthesis/vhdl/XP2.vhd\" ./hdl/mod_freq_div.vhd ./hdl/mod_uart_tx.vhd ./hdl/sintable.vhd ./hdl/mod_wavegen.vhd ./hdl/mod_pushsw_sync.vhd ./hdl/mod_pushsw_sync4.vhd ./hdl/mod_7seg.vhd ./hdl/mod_7seg_x4.vhd ./hdl/mod_top.vhd
OUTPUT_FILE_NAME: Module_TOP
SUFFIX_NAME: edi
WRITE_PRF: false
FREQUENCY:  200
FANOUT_LIMIT:  100
DISABLE_IO_INSERTION: false
FORCE_GSR: false
SPEED_GRADE: -5
SYMBOLIC_FSM_COMPILER: true
NUM_CRITICAL_PATHS:   3
AUTO_CONSTRAIN_IO: true
NUM_STARTEND_POINTS:   0
COMPILER_COMPATIBLE: true
RETIMING: none
RESOURCE_SHARING: true
DEFAULT_ENUM_ENCODING: default
fixgatedclocks:  3
fixgeneratedclocks:  3
Vlog_std_v2001: V2001
DUP: false
ARRANGE_VHDL_FILES: true
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/Synpwrap\" -dyn -e Module_TOP -target LATTICE-XP2 -part LFXP2_5E -notPro -oem"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$fpga_bin/edif2ngd\" -l LatticeXP2 -d LFXP2-5E \"Module_TOP.edi\" \"Module_TOP.ngo\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$fpga_bin/edfupdate\" -t \"mfpga_lat.tcy\" -w \"Module_TOP.ngo\" -m \"Module_TOP.ngo\" \"mfpga_lat.ngx\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$fpga_bin/ngdbuild\" -a LatticeXP2 -d LFXP2-5E -p \"$fpga_dir/mg5a00/data\" \"Module_TOP.ngo\" \"mfpga_lat.ngd\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [runCmd "\"$fpga_bin/map\" -a LatticeXP2 -p LFXP2-5E -t TQFP144 -s 5 \"mfpga_lat.ngd\" -o \"mfpga_lat_map.ncd\" -mp \"mfpga_lat.mrp\" \"mfpga_lat.lpf\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [catch {open mfpga_lat.cm2 w} rspFile] {
	puts stderr "Cannot create response file mfpga_lat.cm2: $rspFile"
} else {
	puts $rspFile "-t mfpga_lat.mt
-to mfpga_lat.tw1
-o mfpga_lat.tcm
-log mfpga_lat.log
-pr mfpga_lat.prf
-rpt mfpga_lat.mrp
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/checkpoint\" -m -f \"mfpga_lat.cmm\" -f \"mfpga_lat.cm2\" -arch LatticeXP2 \"mfpga_lat_map.ncd\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
file delete mfpga_lat.cm2
if [catch {open mfpga_lat.p2t w} rspFile] {
	puts stderr "Cannot create response file mfpga_lat.p2t: $rspFile"
} else {
	puts $rspFile "-w
-i 6
-l 5
-n 1
-t 1
-s 1
-c 0
-e 0
-exp parCDP=Auto
-exp parCDR=1
-exp parPlcInLimit=0
-exp parPlcInNeighborSize=1
-exp parPathBased=OFF
-exp parHold=OFF
"
	close $rspFile
}
if [catch {open mfpga_lat.p3t w} rspFile] {
	puts stderr "Cannot create response file mfpga_lat.p3t: $rspFile"
} else {
	puts $rspFile "-rem
-log mfpga_lat.log
-o mfpga_lat_mp.par
-pr mfpga_lat.prf
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/multipar\" -p mfpga_lat.p2t -f \"mfpga_lat.p3t\" \"mfpga_lat_map.ncd\" \"mfpga_lat.ncd\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
if [catch {open mfpga_lat.cm2 w} rspFile] {
	puts stderr "Cannot create response file mfpga_lat.cm2: $rspFile"
} else {
	puts $rspFile "-t mfpga_lat.pt
-to mfpga_lat.twr
-o mfpga_lat.tcp
-log mfpga_lat.log
-pr mfpga_lat.prf
-rpt mfpga_lat.par
"
	close $rspFile
}
if [runCmd "\"$cpld_bin/checkpoint\" -p -f \"mfpga_lat.cmp\" -f \"mfpga_lat.cm2\" -arch LatticeXP2 \"mfpga_lat.ncd\" -l 60"] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}
file delete mfpga_lat.cm2
if [catch {open mfpga_lat.t2b w} rspFile] {
	puts stderr "Cannot create response file mfpga_lat.t2b: $rspFile"
} else {
	puts $rspFile "-g DisableUES:FALSE
-g RamCfg:Reset
"
	close $rspFile
}
if [runCmd "\"$fpga_bin/bitgen\" -f \"mfpga_lat.t2b\" -w \"mfpga_lat.ncd\" -jedec -e -s \"mfpga_lat.sec\" -k \"mfpga_lat.bek\" \"mfpga_lat.prf\""] {
	return
} else {
	vwait done
	if [checkResult $done] {
		return
	}
}

########## Tcl recorder end at 05/19/09 15:09:10 ###########

