----------------------------------------------------------------------------------
-- }cdq
--
-- @@@@yMFPGA-BASEz@@FPGAg[jOpwKx[X{[h 
-- 
-- @@@@@@@\ؗp@TvR[h
--
-- ݌v	: VHDL
-- FPGA	: čUCNXЁ@XC3S250E-VQ100
-- ݌v	: 2009N214
-- 񋟓	: 2009N410
-- o[W	: 1.0.0
--
----------------------------------------------------------------------------------
-- Description: 
--
--		Clock divider
--
----------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity Module_Freq_div is
	port (
	--**** System signals **** --
		SysCLK_in			: in	std_logic ;				-- 10.000MHz oscillator
		SysRST_in			: in	std_logic ;
		
		DIV_rate			: in	std_logic_vector(23 downto 0) ;
		
		SysOSC_out			: out	std_logic
	) ;
end Module_Freq_div;

architecture Behavioral of Module_Freq_div is

	signal	internal_counter	: std_logic_vector(23 downto 0) := ( others => '0' ) ;

begin

Freq_divider_equ : process ( SysCLK_in )
begin
	if ( SysCLK_in'event and SysCLK_in = '1' ) then
		if ( internal_counter = DIV_rate ) then
			internal_counter <= ( others => '0' ) ;
		else
			internal_counter <= internal_counter + 1 ;
		end if ;
	end if ;
end process ;

Divder_out_equ : process ( SysCLK_in )
begin
	if ( SysCLK_in'event and SysCLK_in = '1' ) then
		if ( SysRST_in = '1' ) then
			SysOSC_out <= '0' ;
		else
			if ( internal_counter = x"000000" ) then
				SysOSC_out <= '1' ;
			else
				SysOSC_out <= '0' ;
			end if ;
		end if ;
	end if ;
end process ;


end Behavioral;

