----------------------------------------------------------------------------------
-- }cdq
--
-- @@@@yMFPGA-BASEz@@FPGAg[jOpwKx[X{[h 
-- 
-- @@@@@@@\ؗp@TvR[h
--
-- ݌v	: VHDL
-- FPGA	: čUCNXЁ@XC3S250E-VQ100
-- ݌v	: 2009N214
-- 񋟓	: 2009N410
-- o[W	: 1.0.0
--
----------------------------------------------------------------------------------
-- Description: 
--
--		4bit HEX -> 8bit 7Segment Output data encode.
--
----------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity module_7seg is
	port (
	--**** Hexa-decimal data input ****--
		HEX_Data_in		: in	std_logic_vector(3 downto 0) ;
		SEG7_porarity	: in	std_logic ;				-- 1 : H-Light, 0 : L-Light
		
	--**** 7segment array output ****--
		Seg_Data_out	: out	std_logic_vector(7 downto 0)
	) ;
end module_7seg ;

architecture Behavioral of module_7seg is

	signal	int_Seg_Data_out	: std_logic_vector(7 downto 0) := x"00" ;

begin
    int_Seg_Data_out <= "00111111" when HEX_Data_in = "0000" else	-- "0"
						"00000110" when HEX_Data_in = "0001" else	-- "1"
						"01011011" when HEX_Data_in = "0010" else	-- "2"
						"01001111" when HEX_Data_in = "0011" else	-- "3"
						"01100110" when HEX_Data_in = "0100" else	-- "4"
						"01101101" when HEX_Data_in = "0101" else	-- "5"
						"01111101" when HEX_Data_in = "0110" else	-- "6"
						"00000111" when HEX_Data_in = "0111" else	-- "7"
						"01111111" when HEX_Data_in = "1000" else	-- "8"
						"01101111" when HEX_Data_in = "1001" else	-- "9"
						"01110111" when HEX_Data_in = "1010" else	-- "A"
						"01111100" when HEX_Data_in = "1011" else	-- "B"
						"00111001" when HEX_Data_in = "1100" else	-- "C"
						"01011110" when HEX_Data_in = "1101" else	-- "D"
						"01111001" when HEX_Data_in = "1110" else	-- "E"
						"01110001" when HEX_Data_in = "1111" else	-- "F"
						"10000000" ;								-- "."
						

	Seg_Data_out <= 	int_Seg_Data_out	when ( SEG7_porarity = '1' )	else	-- Active-H light
					not int_Seg_Data_out ;											-- Active-L light

end Behavioral;

