----------------------------------------------------------------------------------
-- }cdq
--
-- @@@@yMFPGA-BASEz@@FPGAg[jOpwKx[X{[h 
-- 
-- @@@@@@@\ؗp@TvR[h
--
-- ݌v	: VHDL
-- FPGA	: čUCNXЁ@XC3S250E-VQ100
-- ݌v	: 2009N214
-- 񋟓	: 2009N410
-- o[W	: 1.0.0
--
----------------------------------------------------------------------------------
-- Description:   
-- 
-- VHDL Test Bench Created by ISE for module: Module_WaveGenerator
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_unsigned.all;
USE ieee.numeric_std.ALL;

ENTITY tst_mdl_WaveGen_vhd IS
	generic (
		tCYC	: time	:= 10 ns ;
		tPD		: time	:= 1 ns
	) ;
END tst_mdl_WaveGen_vhd;

ARCHITECTURE behavior OF tst_mdl_WaveGen_vhd IS 

	-- Component Declaration for the Unit Under Test (UUT)
	COMPONENT Module_WaveGenerator
	PORT(
		SysCLK_in : IN std_logic;
		SysRST_in : IN std_logic;
		STEP_in : IN std_logic_vector(7 downto 0);
		STEP_IncEnb_in : IN std_logic;
		WaveType_in : IN std_logic_vector(1 downto 0);          
		WaveOut : OUT std_logic_vector(7 downto 0)
		);
	END COMPONENT;

	--Inputs
	SIGNAL SysCLK_in :  std_logic := '1';
	SIGNAL SysRST_in :  std_logic := '1';
	SIGNAL STEP_IncEnb_in :  std_logic := '0';
	SIGNAL STEP_in :  std_logic_vector(7 downto 0) := x"40" ;
	SIGNAL WaveType_in :  std_logic_vector(1 downto 0) := "01" ;

	--Outputs
	SIGNAL WaveOut :  std_logic_vector(7 downto 0);

BEGIN

	-- Instantiate the Unit Under Test (UUT)
	uut: Module_WaveGenerator PORT MAP(
		SysCLK_in => SysCLK_in,
		SysRST_in => SysRST_in,
		STEP_in => STEP_in,
		STEP_IncEnb_in => STEP_IncEnb_in,
		WaveType_in => WaveType_in,
		WaveOut => WaveOut
	);

Clkgen : process
begin
	wait for (tCYC/2) ;		SysCLK_in	<= not SysCLK_in ;
end process ;

CNTen_gen : process
begin
	wait for tCYC*3 ;		STEP_IncEnb_in <= '1' ;
	wait for tCYC*1 ;		STEP_IncEnb_in <= '0' ;
end process ;

tb : PROCESS
BEGIN
	wait for tPD ;
	wait for ( tCYC*4) ;
		SysRST_in	<= '0' ;
	

	wait; -- will wait forever
END PROCESS;

END;
